<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>冠军登录信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					if($("input[name='loginType']:checked").val()==0){
						layer.alert('请选择中国登录类型！', {
						  skin: 'layui-layer-molv'
						  ,closeBtn: 0
						}) 
						return;
					}
					if($("#pedigreeNum").val()!=$("#pedigreeCertified").val() && $("#id").val()==''){
		                layer.alert('若更改了所查询的血统证书号，请重新查询！', {
                          skin: 'layui-layer-molv'
                          ,closeBtn: 0
                        }) 
		                return;
		            }
					if($("#reviewState").val()==1&&$("#loginCode").val()==''){
						layer.alert('请填写登录序号！', {
	                          skin: 'layui-layer-molv'
	                          ,closeBtn: 0
	                        }) 
	                        return;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			if($("#id").val()==''){
				$("input[name=loginType]:eq(0)").attr("checked",'checked');
	            $("input[name=postType]:eq(0)").attr("checked",'checked');
	            $("#pedigreeCertified").attr("readonly",false);
			} else {
				$("#selectDog").attr("disabled","true");
				$("input[name=loginType]").attr("disabled","true");
				/* 页面初始化时，进入编辑页面查询犬只成绩 */
                getDogMessage();
			}
			showOrHide();
			var loginType = $("input[name='loginType']:checked").val();
			if(loginType==6||loginType==7){
				$("#loginTypeDiv").hide(); 
			}
			if($("#reviewState").val()!=2){
				$("#remark").hide();
			}
		});
		function changeType(){
			showOrHide();
        }
		function showOrHide(){
			var check = $("input[name='loginType']:checked").val();
            if(check==0||(check!=6&&check!=7)){
                $("#loginTypeDiv").show();
                $("#ccDiv").show();
                $("#showDiv").hide(); 
                $("#cacibDiv").hide();
            }else if(check==6){
                $("#loginTypeDiv").hide();
                $("#ccDiv").hide();
                $("#attention").html("注：犬只完成登陆后，如需更换加头衔血统证书，请将原证书寄回给繁殖部缴费补做。")
                $("#showDiv").show();
                $("#cacibDiv").show();
            }else{
                $("#loginTypeDiv").hide();
                $("#ccDiv").hide();
                $("#cacibDiv").hide();
                $("#attention").html("注：青年冠军只颁发《青年冠军资质证书》，犬名前不添加登录头衔，不可报名冠军组参展。")
                $("#showDiv").show(); 
            }
		}
		/*根据血统证书号查询犬只信息*/
		function getDogMessage(){
			var pedigreeCertified = $("#pedigreeCertified").val();
			if(pedigreeCertified==''){
				layer.alert('请输入血统证书号！', {
                    skin: 'layui-layer-molv'
                    ,closeBtn: 0
                  }) 
				return;
			}
			$.ajax({
                type:"POST",
                url: ctx+"/championlogin/championLogin/getDogMessage?pedigreeCertified="+pedigreeCertified,
                date : {'pedigreeCertified':pedigreeCertified},
                dataType: 'json',
                async: false, 
                success: function(json){
                	if(json.message=='success'){
                		$("#dogBreed").val(json.dogType);
                        $("#identificationFlag").val(json.identifiSign);
                        $("#nameEn").val(json.dogEgName);
                        $("#dogCnName").val(json.dogCnName);
                        $("#dogGender").val(json.breeder);
                        $("input[type=radio][name='dogGender'][value="+json.dogGender+"]").attr("checked",'checked'); 
                        $("#dogOwner").val(json.dogOwner);
                        $("#memberNum").val(json.memberNum);
                        $("#pedigreeNum").val(json.pedigreeNum);
                        $("#resultCc").val(json.resultCc);
                        $("#resultJcc").val(json.resultJcc);
                        $("#resultGcc").val(json.resultGcc);
                        $("#resultRcc").val(json.resultRcc);
						$("#resultRjcc").val(json.resultRjcc);
                        $("#resultBis").val(json.resultBis);
                        $("#resultCacib").val(json.resultCacib);
                	} else {
                		layer.alert('犬只信息不存在！', {
                            skin: 'layui-layer-molv'
                            ,closeBtn: 0
                          }) 
                	}
                }
            });
		}
		/*改变审核状态*/
		function changeState(){
			var state = $("#reviewState").val();
			if(state==2){
				$("#remark").show();
			}else{
				$("#remark").hide();
				$("#reviewRemarks").val('');
			}
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/championlogin/championLogin/">冠军登录信息列表</a></li>
		<li class="active"><a href="${ctx}/championlogin/championLogin/view?id=${championLogin.id}">冠军登录信息<shiro:hasPermission name="championlogin:championLogin:view">${not empty championLogin.id?'查看':'添加'}</shiro:hasPermission><shiro:lacksPermission name="championlogin:championLogin:view">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="championLogin" action="" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<input id="pedigreeNum" type="hidden" />
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">登录类型：</label>
			<div class="controls">
				<form:radiobuttons path="loginType" items="${fns:getDictList('main_login_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" onclick="changeType()"/>
			</div>
			<tr><td>&nbsp;</td></tr>
			<div class="controls" id="loginTypeDiv">
                <form:radiobuttons path="loginType" items="${fns:getDictList('champion_login_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class=""/>
                <br>
                <ul>
                   <li><font color="#FF0000">注：犬只完成登陆后，如需更换加头衔血统证书，请将原证书寄回给繁殖部缴费补做。 </font></li>
                </ul>
            </div>
            <div class="controls" id="showDiv" hidden="true">
                <ul>
                   <li id=""><font id="attention" color="#FF0000"> </font></li>
                </ul>
            </div>
		</div>
		<div class="control-group" >
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				${not empty championLogin.id?'':'<input id="selectDog" class="btn btn-primary" value="查" type="button" onclick="getDogMessage()"/>'}
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">身份识别标志：</label>
            <div class="controls">
                <form:input id="identificationFlag" path="dog.identificationFlag" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
            <label class="control-label">英文名：</label>
            <div class="controls">
                <form:input id="nameEn" path="dog.nameEn" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group" >
            <label class="control-label">中文名：</label>
            <div class="controls">
                <input id="dogCnName" class="input-xlarge" readonly="true" type="text"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬种：</label>
			<div class="controls">
				<form:input path="dogBreed" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
		<label class="control-label">性别：</label>
            <div class="controls">
            <form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" disabled="true"/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">犬主姓名：</label>
            <div class="controls">
                <form:input path="dogOwner" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberNum" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">成绩：</label>
            <div class="controls">
                <input id="resultBis" class="input-xlarge" readonly="true" type="text"/>
            </div>
        </div>
        <div class="control-group" id="ccDiv">
            <label class="control-label">CC：</label>
            <div class="controls">
                <input id="resultCc" class="input-xlarge" readonly="true" type="text"/>
            </div>
        </div>
         <div class="control-group" id="gccDiv">
            <label class="control-label">GCC：</label>
            <div class="controls">
                <input id="resultGcc" class="input-xlarge" readonly="true" type="text"/>
            </div>
        </div>
        <div class="control-group" id="cacibDiv">
            <label class="control-label">CACIB：</label>
            <div class="controls">
                <input id="resultCacib" class="input-xlarge" readonly="true" type="text"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">RCC：</label>
			<div class="controls">
				<input id="resultRcc" class="input-xlarge" readonly="true" type="text"/>
			</div>
		</div>
		<div class="control-group"  style="float: left">
			<label class="control-label">JCC：</label>
			<div class="controls">
				<input id="resultJcc" class="input-xlarge" readonly="true" type="text"/>
			</div>
		</div>
		
		<div style = "clear:both;"/>
		<div class="control-group"  style="float: left">
			<label class="control-label">RJCC：</label>
			<div class="controls">
				<input id="resultRjcc" class="input-xlarge" readonly="true" type="text"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
            <label class="control-label">登录序号：</label>
            <div class="controls">
                <form:input path="loginCode" htmlEscape="false" maxlength="100" class="input-xlarge" readonly="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">邮寄类型：</label>
			<div class="controls">
				<form:radiobuttons path="postType" items="${fns:getDictList('mailing_way')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮寄地址：</label>
			<div class="controls">
                <form:textarea path="postAddress" htmlEscape="false" rows="4" maxlength="100" class="input-xxlarge " readonly="true"/>
            </div>
		</div>
		<div class="control-group">
            <label class="control-label">犬只图片：</label>
            <div class="controls">
                <sys:singleImgUpload module="championLogin" imgId="${championLogin.dogImg}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
                <form:input id="dogImg" path="dogImg" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
                <!-- 文件上传成功的回调方法 -->
                <script type="text/javascript">
                    function uploadSuccess(file,response){
                        $("#dogImg").val(response.id);
                    }
                </script>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge " onclick="changeState()" disabled="true">
					<form:options items="${fns:getDictList('champion_login_review')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" id="remark">
			<label class="control-label">审核原因：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
		<div style = "clear:both;"></div>
	</form:form>
</body>
</html>