<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 110px!important;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			var bo;
			$("#name").blur(function(){
				var name = encodeURI($("#name").val());
				var id = $("#id").val();
				if(name!=''){
					$.ajax({
						type: "POST",
		                dataType:"json",
		                url:"${ctx}/kennel/kennel/nameCheck?name="+name+"&id="+id,
		                async: false,
		                error: function(request, textStatus, errorThrown) {
		                    alert("请求失败！");
		                },
		                success: function(data) {
		                	if(data.rc == false){
		                		bo = data.rc;
		                		$("#nameError").html('犬舍中文名已经存在！');
								$("#nameError").show();
		                	}else{
		                		bo = data.rc;
		                	}
		                }
					})
				}
			});
			$("#name").focus(function(){
				$("#nameError").hide();
			})
			$("#inputForm").validate({
				submitHandler: function(form){
					if(bo == false){
						$("#nameError").attr("value", '犬舍中文名已经存在！');
						$("#nameError").show();
						$("#name").attr("value", '');
					}else{
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			/* //审核中 审核通过 锁定fci英文名不可编辑
			var i='${kennel.fciReviewState}';
			if(i==3){
				$("#fciName").attr("disabled",true);
			}
			if(i==1){
				$("#fciName").attr("disabled",true);
			}*/
			//免核算不显示核算日期
			var i='${kennel.calculationState}';
			if(i==3){
				$("#calculationViewFlag").hide();
			}
		});
		
		 function seachKennel(val){//犬舍中文搜索
			 var name=$("#name").val();
			 if(name!=''){
	    	   $.ajax({
	               type:"POST",
	               url:"${ctx}/kennel/kennel/getKennel",
	               data:{
	            	   name:name
	               },
	               async: false, 
	               success: function(data){
	                   var str = eval(data);
	                   $("#tbody").html('');
	                   $("#table").show();
	                   $("#close").show();
	                   $.each(str,function(){
	                	   $("#tbody").append(
	                	   "<tr>"+
	                	   "<td>"+this.memberCode+"</td>"+
	                	   "<td>"+this.member.name+"</td>"+
	                	   "<td>"+this.name+"</td>"+
	                	   "<td>"+this.nameEn+"</td>"+
	                	   "</tr>"
	                	   )
	                   });
	               }
	          });
			 }
	       }
		 
		 function seachKennelFci(){
			 var fciName=$("#fciName").val();
			 if(fciName!=''){
	    	   $.ajax({
	               type:"POST",
	               url:"${ctx}/kennel/kennel/getKennelFci",
	               data:{
	            	   fciName:fciName
	               },
	               async: false, 
	               success: function(data){
	                   var str = eval(data);
	                   $("#tbody1").html('');
	                   $("#table1").show();
	                   $("#close1").show();
	                   $.each(str,function(){
	                	   $("#tbody1").append(
	                	   "<tr>"+
	                	   "<td>"+this.memberCode+"</td>"+
	                	   "<td>"+this.member.name+"</td>"+
	                	   "<td>"+this.name+"</td>"+
	                	   "<td>"+this.nameEn+"</td>"+
	                	   "</tr>"
	                	   )
	                   });
	               }
	          });
			 }
		 }
	       function closeTable(){
	    	   $("#table").hide();
	    	   $("#close").hide();
	    	   $("#table1").hide();
	    	   $("#close1").hide();
	       }
	       function closeTable1(){
	    	   $("#table1").hide();
	    	   $("#close1").hide();
	       }
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<%-- <li><a href="${ctx}/kennel/kennel/">犬舍列表</a></li>
		<li class="active"><a href="${ctx}/kennel/kennel/form?memberCode=${kennel.memberCode}">犬舍<shiro:hasPermission name="kennel:kennel:edit">${not empty kennel.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="kennel:kennel:edit">查看</shiro:lacksPermission></a></li> --%>
		<li>犬舍编辑</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="kennel" action="${ctx}/kennel/kennel/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<input type="hidden" name="temp" value=${temp }>
		<input type="hidden" name="tempFci" value=${tempFci }>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.member.name)}
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">犬舍状态：</label>
			<div class="controls">
				<c:if test="${kennel.endTime > date}">
					已缴费
				</c:if>
				<c:if test="${empty kennel.endTime || kennel.endTime < date}">
					未缴费
				</c:if>		
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">犬舍类型：</label>
			<div class="controls">
				<form:select path="type" class="input-xlarge " disabled="true">
					<form:options items="${fns:getDictList('kennel_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
                <!-- <ul>
                   <font color="#FF0000" style="margin-left: -25px;">注：犬舍无效的情况下可修改犬舍类型</font>
                </ul> -->
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">犬舍编号：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.kennelCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI犬舍编号：</label>
			<div class="controls">
				<form:input path="fciKennelCode"  htmlEscape="false"  maxlength="30" class="input-xlarge "/>
			</div>
		</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
				<button type="button" class="btn btn-primary" onclick="seachKennel()">查询</button>
				<label id="nameError" style="color:red;display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
				<!-- <button type="button" class="btn btn-primary" onclick="seachKennelEn()">查询</button>
				<label id="nameEnError" style="color:red;display:none" class="error"></label> -->
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">FCI英文名：</label>
			<div class="controls">
				<form:input path="fciName" htmlEscape="false" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
				<button type="button" class="btn btn-primary" onclick="seachKennelFci()">查询</button>
				<label id="fciNameError" style="color:red;display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI备用英文名：</label>
			<div class="controls">
				<form:input path="fciNameBackup" htmlEscape="false" class="input-xlarge "/>
				<!-- 
				<button type="button" class="btn btn-primary" onclick="seachKennelFciBackup()">查询</button>
				<label id="fciNameBackupError" style="color:red;display:none" class="error"></label> -->
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文犬舍地址：</label>
			<div class="controls">
				<form:input path="fciKennelAddress" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.createDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.endTime}" pattern="yyyy-MM-dd"/>
				<%-- <shiro:hasPermission name="finance:deductCost:payment">
					<c:if test="${fn:contains(payItem, ',')}">
						<button class=" btn btn-primary" onclick="util.mergePay('${kennel.id}','${payItem }','${kennel.memberCode}');return false;">缴费</button>
					</c:if>
					<c:if test="${!fn:contains(payItem, ',')}">
						<button class=" btn btn-primary" onclick="util.pay('${kennel.id}','${payItem }','1','','${kennel.memberCode}');return false;">缴费</button>
					</c:if>
				</shiro:hasPermission> --%>
				<c:if test="${isActiveMember==false}">
                <ul>
                   <font color="#FF0000" style="margin-left: -25px;">注：该会员为无效会员</font>
                </ul>
                </c:if>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬舍中文审核：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('kennel_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>		
		<div class="control-group" style="float: right">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				<form:textarea path="reviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
			<div class="control-group" style="float: left">
			<label class="control-label">FCI犬舍审核：</label>
			<div class="controls">
				<form:select path="fciReviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('fci_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" style="float: right">
			<label class="control-label">FCI未通过原因：</label>
			<div class="controls">
				<form:textarea path="fciReviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
		</div>
			<div class="control-group" style="float: left">
			<label class="control-label">犬舍核算状态：</label>
			<div class="controls">
				<form:select path="calculationState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('calculation_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" id="calculationViewFlag">
			<label class="control-label">核算时间：</label>
			<div class="controls">
				<fmt:formatDate value="${kennel.calculationDate}" pattern="yyyy-MM-dd"/>
				<shiro:hasPermission name="finance:deductCost:payment">
						<button class=" btn btn-primary" onclick="util.pay('${kennel.id}','kennel@calculation','1','','${kennel.memberCode}');return false;">缴费</button>
				</shiro:hasPermission>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false"  maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作记录：</label>
			<div class="controls">
				${fns:escapeHtml(kennel.operator)}
			</div>
		</div>
		<table id="table" class="table table-striped table-bordered table-condensed" style="display:none">
	        <thead>
	            <tr>
	                <th>会员号</th>
	                <th>会员名</th>
	                <th>中文犬舍名</th>
	                <th>英文犬舍名</th>
	            </tr>
	        </thead>
	        <tbody id="tbody">
	        </tbody>
	        <td colspan="10" style="display:none" id="count"></td>
        </table>
        <input id="close" class="btn" type="button" value="关闭" onclick="closeTable()" style="display:none"/>
        <table id="table1" class="table table-striped table-bordered table-condensed" style="display:none">
	        <thead>
	            <tr>
	                <th>会员号</th>
	                <th>会员名</th>
	                <th>中文犬舍名</th>
	                <th>英文犬舍名</th>
	            </tr>
	        </thead>
	        <tbody id="tbody1">
	        </tbody>
	        <td colspan="10" style="display:none" id="count"></td>
        </table>
        <input id="close1" class="btn" type="button" value="关闭" onclick="closeTable1()" style="display:none"/>
		<div style="clear:both;"/>
		<div class="form-actions">
			<shiro:hasPermission name="kennel:kennel:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>