<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍联盟管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});


			//经办人复选
			$("#operator").val("${fns:escapeHtml(kennelAlliance.operator)}");
			$("#operator").trigger("change");
			
			var a="${not empty kennelAlliance.id?'0':'1'}";
			if(a==0){
				$("#memberCode").attr("disabled",true);
				$("#btnSeacher").attr({"disabled":"disabled"});
			}
			
			var id="${not empty kennelAlliance.id?'1':'0'}";
			if(id==1){
				$('#combo').attr({"disabled":true});
			}
			
			
			
		});
		
		

		function setMemberInfo(){
			var memberCode = $("#memberCode").val();
			if(memberCode==''){
				$.jBox.alert("请输入会员号！","提示");
				return;
			}
		    $.post('${ctx}/kennel/kennelAlliance/setMemberInfo', {
		    	memberCode: memberCode
		    }, function(data) {

		    	if(data.status=='1'){
		    		$.jBox.alert(data.msg,"提示");
			    	$("#memberName").html("");
			    	$("#memberFirstPaymentTime").html("");
			    	$("#memberGender").html("");
			    	$("#memberBirthday").html("");
			    	$("#memberCardNo").html("");
			    	$("#memberMobile").html("");
			    	$("#memberAddress").html("");
			    	$("#memberMemberType").html("");
			    	$("#kennelType").html("");
			    	$("#kennelName").html("");
			    	$("#kennelNameEn").html("");
			    	$("#kennelBreed").html("");
			    	$("#kennelEndTime").html("");
		    		return;
		    	}

		    	$("#memberName").html(data.memberName);
		    	$("#memberFirstPaymentTime").html(data.memberFirstPaymentTime);
		    	$("#memberGender").html(data.memberGender);
		    	$("#memberBirthday").html(data.memberBirthday);
		    	$("#memberCardNo").html(data.memberCardNo);
		    	$("#memberMobile").html(data.memberMobile);
		    	$("#memberAddress").html(data.memberAddress);
		    	$("#memberMemberType").html(data.memberMemberType);
		    	$("#kennelType").html(data.kennelType);
		    	$("#kennelName").html(data.kennelName);
		    	$("#kennelNameEn").html(data.kennelNameEn);
		    	$("#kennelBreed").html(data.kennelBreed);
		    	$("#kennelEndTime").html(data.kennelEndTime);

		    });
		}

		function setPayAmount(){
			$('#payAmount').val($("#combo option:selected").val());
		}

	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/kennel/kennelAlliance/">犬舍联盟列表</a></li>
		<li class="active"><a href="${ctx}/kennel/kennelAlliance/form?id=${kennelAlliance.id}">犬舍联盟<shiro:hasPermission name="kennel:kennelAlliance:edit">${not empty kennelAlliance.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="kennel:kennelAlliance:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="kennelAlliance" action="${ctx}/kennel/kennelAlliance/${not empty kennelAlliance.id?'edit':'add'}" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<h3>会员信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input id="memberCode" path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<input id="btnSeacher" class="btn btn-primary" value="查询" type="button" onclick="setMemberInfo()"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls" id="memberName">${kennelAlliance.member.name}</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员开始时间：</label>
			<div class="controls" id="memberFirstPaymentTime"><fmt:formatDate value="${kennelAlliance.member.firstPaymentTime}" pattern="yyyy-MM-dd"/></div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls" id="memberGender">
				<c:if test="${kennelAlliance.member.gender=='male'}">男</c:if>
				<c:if test="${kennelAlliance.member.gender=='female'}">女</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls" id="memberBirthday"><fmt:formatDate value="${kennelAlliance.member.birthday}" pattern="yyyy-MM-dd"/></div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证号：</label>
			<div class="controls" id="memberCardNo">${kennelAlliance.member.cardNo}</div>
		</div>
		<div class="control-group">
			<label class="control-label">移动电话：</label>
			<div class="controls" id="memberMobile">${kennelAlliance.member.mobile}</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系地址：</label>
			<div class="controls" id="memberAddress">${kennelAlliance.member.province}${kennelAlliance.member.city}${kennelAlliance.member.street}${kennelAlliance.member.address}</div>
		</div>
		<div style = "clear:both;"/>
		</div>
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls" id="memberMemberType">
				<c:if test="${kennelAlliance.member.memberType=='basic'}">基础</c:if>
				<c:if test="${kennelAlliance.member.memberType=='professional'}">专业</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍类型：</label>
			<div class="controls" id="kennelType">
				<c:if test="${kennelAlliance.kennel.type=='year'}">年度</c:if>
				<c:if test="${kennelAlliance.kennel.type=='permanent'}">永久</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls" id="kennelName">${kennelAlliance.kennel.name}</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文及拼音：</label>
			<div class="controls" id="kennelNameEn">${kennelAlliance.kennel.nameEn}</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍犬种：</label>
			<div class="controls" id="kennelBreed">${kennelAlliance.kennel.breed}</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍截至时间：</label>
			<div class="controls" id="kennelEndTime"><fmt:formatDate value="${kennelAlliance.kennel.endTime}" pattern="yyyy-MM-dd"/></div>
		</div>
		<div style = "clear:both;"/>
		<h3>项目信息</h3>
		<div class="control-group">
			<label class="control-label">所属项目：</label>
			<div class="controls">
				<form:select path="project" class="input-medium required">
					<form:option value="" label="请选择"/>
					<form:option value="犬舍联盟" label="犬舍联盟"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">套餐：</label>
			<div  class="controls">
				<form:select id="combo" path="combo" onchange="setPayAmount()" class="input-medium required">
					<form:option value="" label="请选择"/>
					<form:option value="12000" label="12000"/>
					<form:option value="6000" label="6000"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">经办人：</label>
			<div class="controls">
				<form:select id="operator" path="operator" class="input-medium required">
					<option value="">请选择</option>
					<option value="马辉">马辉</option>
					<option value="常清">常清</option>
					<option value="董军">董军</option>
					<option value="霍彦坤">霍彦坤</option>
					<option value="宋剑平">宋剑平</option>
					<option value="张伟">张伟</option>
					<option value="张金村">张金村</option>
					<option value="王婷">王婷</option>
					<option value="李琼">李琼</option>
					<option value="王秋燚">王秋燚</option>
					<option value="迟婧">迟婧</option>
					<option value="CKU">CKU</option>
					<option value="杭州办">杭州办</option>
				</form:select>

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费金额：</label>
			<div class="controls">
				<form:input id="payAmount" path="payAmount" htmlEscape="false" readonly="true" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">有效期开始时间：</label>
			<div class="controls">
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${kennelAlliance.startDate}" pattern="yyyy-MM-dd"/>"
					<c:if test="${not empty kennelAlliance.startDate}">onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"</c:if>
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">有效期结束时间：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${kennelAlliance.endDate}" pattern="yyyy-MM-dd"/>"
					<c:if test="${not empty kennelAlliance.endDate}">onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"</c:if>
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>