<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>积分管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/handler/refereeRanking/export");
						$("#searchForm").submit();
						$("#searchForm").attr("action","${ctx}/handler/refereeRanking/list");
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
				
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/handler/refereeRanking/list");
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/refereeRanking/">积分列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="refereeRanking" action="${ctx}/handler/refereeRanking/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>年份：</label>
				<form:select path="year" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${yearList}" var="year">
						<form:option value="${year}" label="${year}年"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('referee_schem_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>季度：</label>
				<form:select path="quarter" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('quarter')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>月份：</label>
				<form:select path="month" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${monthList}" var="month">
						<form:option value="${month}" label="${month}月"/>
					</c:forEach>
				</form:select>
			</li>
			
			<li><label>半年度：</label>
				<form:select path="half" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="上半年"/>
					<form:option value="2" label="下半年"/>
				</form:select>
			</li>
			
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li>
				<shiro:hasPermission name="handler:handlerQualificationCertificate:view"><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>会员号</th>
				<th>会员名</th>
				<th>类型</th>
				<th>年度</th>
				<th>季度</th>
				<th>月度</th>
				<th>半年度</th>
				<th>积分</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="refereeRanking">
			<tr>
				<td> 
					${refereeRanking.serialNum}	
				</td>
				<td>
					${refereeRanking.memberCode}
				</td>
				<td>
					${refereeRanking.memberName}
				</td>
				<td>
					${fns:getDictLabel(refereeRanking.type, 'referee_schem_type', '')}
				</td>
				<td>
					${refereeRanking.year}
				</td>
				<td>
					${fns:getDictLabel(refereeRanking.quarter, 'quarter', '')}
				</td>
				<td>
					${refereeRanking.month}
				</td>
				<td>
					<c:if test="${not empty refereeRanking.half}">
						${refereeRanking.half eq '1' ? '上半年':'下半年'}
					</c:if>
				</td>
				<td>
					${refereeRanking.rankingScore}
				</td>
				<td>
					<a href="${ctx}/handler/refereeRanking/exportInfo?serialNum=${refereeRanking.serialNum}&memberCode=${refereeRanking.memberCode}"> 下载 </a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>