<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>

</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerRegister/gradeView?id=${fns:escapeHtml(handlerRegister.id)}">成绩信息查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerRegister"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.registerCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
			${fns:getDictLabel(handlerRegister.gender, 'user_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.mobile)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
					${fns:getDictLabel(handlerRegister.showLevel, 'groomer_test_level', '')}
			</div>
		</div>
			<div class="control-group">
			<label class="control-label">考试日期：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerRegister.takeCertificateDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">考试号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.testNo)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.referee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">成绩：</label>
			<div class="controls">
			${fns:getDictLabel(handlerRegister.grade, 'handler_grade', '')}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>