<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title> 审查员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handeler/handlerShowReferee/"> 审查员列表</a></li>
		<shiro:hasPermission name="handeler:handlerShowReferee:edit"><li><a href="${ctx}/handeler/handlerShowReferee/form"> 审查员添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShowReferee" action="${ctx}/handeler/handlerShowReferee/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>审查员中文名：</label>
				<form:input path="refereeNameCn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审查员英文名：</label>
				<form:input path="refereeNameEn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>审查员中文名</th>
				<th>审查员英文名</th>
				<th>审查员性别</th>
				<th>审查员国籍</th>
				<%--<th>审查员类型</th>--%>
				<shiro:hasPermission name="handeler:handlerShowReferee:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShowReferee">
			<tr>
				<td><a href="${ctx}/handeler/handlerShowReferee/form?id=${groomerShowReferee.id}">
					${fns:escapeHtml(groomerShowReferee.refereeNameCn)}
				</a></td>
				<td>
					${fns:escapeHtml(groomerShowReferee.refereeNameEn)}
				</td>
				<td>
					${fns:getDictLabel(groomerShowReferee.refereeSex, 'sex', '')}
				</td>
				<td>
					${fns:escapeHtml(groomerShowReferee.refereeCitizenship)}
				</td>
				<%--<td>--%>
					<%--牵犬师--%>
				<%--</td>--%>
				<td>
					<a href="${ctx}/handeler/handlerShowReferee/view?id=${groomerShowReferee.id}">查看</a>
					<shiro:hasPermission name="handeler:handlerShowReferee:edit">
						<a href="${ctx}/handeler/handlerShowReferee/form?id=${groomerShowReferee.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="handeler:handlerShowReferee:delete">
						<a href="${ctx}/handeler/handlerShowReferee/delete?id=${groomerShowReferee.id}" onclick="return confirmx('确认要删除该 审查员吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>