<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容课程管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerCourse/export");
						$("#searchForm").submit();
						$("#searchForm").attr("action","${ctx}/groomer/groomerCourse/");

					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerCourse/">美容课程列表</a></li>
		<li ><a href="${ctx}/groomer/groomerCourse/viewApply">报名信息</a>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerCourse" action="${ctx}/groomer/groomerCourse/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>美容学校：</label>
				<form:input path="schoolId" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>课程类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('course_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>课程级别：</label>
				<form:select path="diplomaLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="master" label="教师级"/>
					<form:options items="${fns:getDictList('course_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>课程编号：</label>
				<form:input path="code" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>上架时间：</label>
				<input name="beginLaunchTime"  type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourse.beginLaunchTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endLaunchTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerCourse.endLaunchTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>课程编号</th>
				<th>课程名称</th>
				<th>课程类型</th>
				<th>课程级别</th>
				<th>美容学校</th>
				<th>课程价格</th>
				<th>课程状态</th>
				<th>操作</th>
				<th>报名</th>

			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerCourse">
			<tr>
				<td>
					${groomerCourse.code}
				</td>
				<td><a href="${ctx}/groomer/groomerCourse/form?id=${groomerCourse.id}">
					${groomerCourse.courseName}
				</a></td>
				<td>
						${fns:getDictLabel(groomerCourse.type, 'course_type', '')}
				</td>
				<td>
					<c:if test="${not empty groomerCourse.diplomaLevel }">
						${fns:getDictLabel(groomerCourse.diplomaLevel, 'course_level', '')}
					</c:if>
					<c:if test="${empty groomerCourse.diplomaLevel }">
						无
					</c:if>
				</td>
				<td>
					${groomerCourse.schoolId}
				</td>
				<td>
					${groomerCourse.price}
				</td>
				<td>
						${fns:getDictLabel(groomerCourse.states, 'course_states', '')}
				</td>
				<td>
					<shiro:hasPermission name="groomer:groomerCourse:review">
						<a href="${ctx}/groomer/groomerCourse/review?id=${groomerCourse.id}">查看</a>
						<c:if test="${groomerCourse.states == 3}">
							<a href="${ctx}/groomer/groomerCourse/offStates?id=${groomerCourse.id}"
							   onclick="return confirmx('确认要下架改课程吗？', this.href)">下架</a>
						</c:if>
					</shiro:hasPermission>
				</td>
				<td>
					<a href="${ctx}/groomer/groomerCourse/viewApply?courseId=${groomerCourse.id}">报名</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>