<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务服务管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            //初始化界面
            let isView = '${isView}';
            if (isView == 1) {
                $('#btnSubmit').hide();
                $('#inputForm input').attr('disabled','true');
                $('#inputForm select').attr('disabled','true');
                $('#inputForm textarea').attr('disabled','true');
                $('#inputForm input').unbind();
                $('#btnCancel').removeAttr('disabled');
            }
            //初始化表单
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/goods/sysBusinessService/">业务服务列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${not empty sysBusinessService.id and isView == 1}">
					<a href="${ctx}/goods/sysBusinessService/viewForm?id=${sysBusinessService.id}">业务服务查看</a>
				</c:when>
				<c:when test="${not empty sysBusinessService.id and isView == 0}">
					<a href="${ctx}/goods/sysBusinessService/editForm?id=${sysBusinessService.id}">业务服务编辑</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/goods/sysBusinessService/editForm">业务分类添加</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="sysBusinessService" action="${ctx}/goods/sysBusinessService/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">业务分类：</label>
			<div class="controls">
				<form:select id="cateId" path="cateId" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${businessCateList}" itemLabel="cateName" itemValue="id" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">服务编号：</label>
			<div class="controls">
				<form:input path="businessCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">服务名称：</label>
			<div class="controls">
				<form:input path="businessName" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<shiro:hasPermission name="goods:sysBusinessService:registerService">
		<div class="control-group">
			<label class="control-label">处理类：</label>
			<div class="controls">
				<form:input path="serviceName" htmlEscape="false" maxlength="50" class="input-xlarge "/>
				<br>
				<span class="help-inline"><font color="red">仅限技术人员修改</font> </span>
			</div>
		</div>
		</shiro:hasPermission>
		<div class="control-group">
			<label class="control-label">财务配置ID：</label>
			<div class="controls">
				<form:input path="financeId" htmlEscape="false" maxlength="50" class="input-xlarge "/>
				</br
				<span class="help-inline"><font color="red">此ID之前用于用友审计，目前应该已废弃,考虑到订单数据完整性故需配置此ID,后续可优化处理</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="goods:sysBusinessService:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>