<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>充值消费明细管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function exportData() {
			var memberCode = $("#memberCode").val();
			var startDate = $("#startDate").val();
			var endDate = $("#endDate").val();
			if(memberCode == "" || memberCode == null || endDate == "" || startDate == "" ){
				$.jBox.alert("会员号、付款起止时间不能为空");
			}else{
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/finance/saPaymentDetailTotal/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			}
		}
		function searchData() {
			var startDate = $("#startDate").val();
			var endDate = $("#endDate").val();
			if( endDate == "" || startDate == "" ){
				$.jBox.alert("付款起止时间不能为空");
			}else{
				$("#searchForm").submit();
			}
		}
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/memberAccount/">会员账户资金收支明细</a></li>
		<li><a href="${ctx}/finance/memberAccount/org">地方俱乐部代办明细</a></li>
		<li><a href="${ctx}/finance/memberAccount/training">美容学校代办明细</a></li>
		<shiro:hasPermission name="finance:memberAccount:recharge"><li><a href="${ctx}/finance/memberAccount/form">会员账户充值</a></li>
			<li><a href="${ctx}/finance/memberAccount/formReserve">会员账户反向充值</a></li>
		</shiro:hasPermission>
		<li class="active"><a href="${ctx}/finance/saPaymentDetailTotal/">充值消费明细列表</a></li>
		<shiro:hasPermission name="finance:saPaymentDetailTotal:edit"><li><a href="${ctx}/finance/saPaymentDetailTotal/form">充值消费明细添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="saPaymentDetailTotal" action="${ctx}/finance/saPaymentDetailTotal/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>付款会员号：</label>
				<form:input path="payMemberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>流水号：</label>
				<form:input path="runningNumber" htmlEscape="false" maxlength="255" class="input-medium "/>
			</li>
			<li><label>回充原单号：</label>
				<form:input path="oldRunningNumber" htmlEscape="false" maxlength="255" class="input-medium "/>
			</li>
			<li><label>部门：</label>
				<sys:treeselect id="office" name="chargingItemOfficeId" value="${saPaymentDetailTotal.chargingItemOfficeId}" labelName="chargingItemOfficeName" labelValue="${saPaymentDetailTotal.chargingItemOfficeName}"  title="部门" url="/sys/office/treeData?type=2" cssClass="input-small" allowClear="true" notAllowSelectParent="true"/>
			</li>
			<li><label>操作人：</label>
				<sys:treeselect id="updateBy" name="updateBy.id" value="${saPaymentDetailTotal.updateBy.id}" labelName="updateBy.name" labelValue="${saPaymentDetailTotal.updateBy.name}" title="用户" url="/sys/office/treeData?type=3" cssClass="input-small" allowClear="true" notAllowSelectParent="true"/>
			</li>
			<li><label>付款时间：</label>
				<input id="startDate" style="width:160px;" name="paymentTimeStart" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate required"
					   value="${paymentTimeStart}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
				<input id="endDate" style="width:160px;" name="paymentTimeEnd" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate required"
					   value="${paymentTimeEnd}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<%--<li><label>完成时间：</label>--%>
				<%--<input id="finishTimeStart" name="finishTimeStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "--%>
					   <%--value="<fmt:formatDate value="${saPaymentDetailTotal.finishTimeStart}" pattern="yyyy-MM-dd "/>"--%>
					   <%--onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>---%>
				<%--<input id="finishTimeEnd" name="finishTimeEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "--%>
					   <%--value="<fmt:formatDate value="${saPaymentDetailTotal.finishTimeEnd}" pattern="yyyy-MM-dd"/>"--%>
					   <%--onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--%>
			<%--</li>--%>
			<li><label>支付方式：</label>
				<form:select path="paymentWay" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>收支类型：</label>
				<form:select id="" path="sourceCharge" class="input-medium">
					<form:option value="" label="全部"/>
					<c:forEach items="${chargingItems}" var="item">
						<form:option value="${item.id}" label="${item.name}" htmlEscape="false"/>
					</c:forEach>
				</form:select>
			</li>
			<li><label>订单状态 ：</label>
				<form:select path="orderStates" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('order_states')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>业务状态 ：</label>
				<form:select path="businessStates" class="input-medium ">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('business_states')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li class="btns"><button id="btnSubmit" type="button" class="btn btn-primary"  onclick="searchData()">查询</button></li>
			<li class="btns"><button id="btnExport" type="button" class="btn btn-primary" onclick="exportData()">导出</button></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水编号</th>
				<th>付款时间</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>付款会员号</th>
				<th>部门</th>
				<th>收支类型</th>
				<th>支付方式</th>
				<th>充值金额</th>
				<th>订单金额</th>
				<%--<th>回充金额</th>--%>
				<th>宠爱王国金额</th>
				<th>宠爱王国收费项目</th>
				<th>平阳金额</th>
				<th>平阳收费项目</th>
				<th>业务状态</th>
				<th>完成时间</th>
				<th>余额</th>
				<th>订单状态 </th>
				<th>回充原单号</th>
				<th>赛事编号</th>
				<th>备注</th>
				<th>操作人</th>
				<%--<th>操作</th>--%>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="saPaymentDetailTotal">
			<tr>
				<td>
					${saPaymentDetailTotal.runningNumber}
				</td>
				<td>
					<fmt:formatDate value="${saPaymentDetailTotal.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${saPaymentDetailTotal.memberCode}
				</td>
				<td>
					${saPaymentDetailTotal.memberName}
				</td>

				<td>
					${saPaymentDetailTotal.payMemberCode}
					<%--<c:if test="${saPaymentDetailTotal.cmember!=null}">${fns:escapeHtml(saPaymentDetailTotal.cmember)}</c:if>--%>
					<%--<c:if test="${saPaymentDetailTotal.cmember==null&&saPaymentDetailTotal.orgmember!=null}">${fns:escapeHtml(saPaymentDetailTotal.orgmember)}</c:if>--%>
					<%--<c:if test="${saPaymentDetailTotal.cmember==null&& saPaymentDetailTotal.orgmember==null }">${fns:escapeHtml(saPaymentDetailTotal.memberCode)}</c:if>--%>
				</td>
				<td>
					${saPaymentDetailTotal.chargingItemOfficeName}
				</td>
				<td>
					${saPaymentDetailTotal.chargingItemName}
				</td>
				<td>
					${fns:getDictLabel(saPaymentDetailTotal.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<c:if test="${saPaymentDetailTotal.chargingItemName=='账号充值'}">
						${fns:escapeHtml(saPaymentDetailTotal.orderPrice)}
					</c:if>
				</td>
				<td>
					<c:if test="${saPaymentDetailTotal.chargingItemName!='账号充值'}">
						${fns:escapeHtml(saPaymentDetailTotal.orderPrice)}
					</c:if>
				</td>
				<%--<td>--%>
					<%--<c:if test="${saPaymentDetailTotal.chargingItemName!='账号充值'&&saPaymentDetailTotal.chargingItemName=='2'}">--%>
						<%--${fns:escapeHtml(saPaymentDetailTotal.orderPrice)}--%>
					<%--</c:if>--%>
				<%--</td>--%>
				<td>
					<c:if test="${saPaymentDetailTotal.type == 'cab'}">
						${saPaymentDetailTotal.paymentMoney}
					</c:if>
				</td>
				<td>
					<c:if test="${saPaymentDetailTotal.type == 'cab'}">
						${saPaymentDetailTotal.cabName}
					</c:if>
				</td>
				<td>
					<c:if test="${saPaymentDetailTotal.type == 'cku'}">
						${saPaymentDetailTotal.paymentMoney}
					</c:if>
				</td>
				<td>
					<c:if test="${saPaymentDetailTotal.type == 'cku'}">
						${saPaymentDetailTotal.ckuName}
					</c:if>
				</td>
				<td>
					${fns:getDictLabel(saPaymentDetailTotal.businessStates, 'business_states', '')}
				</td>
				<td>
					<fmt:formatDate value="${saPaymentDetailTotal.finishTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${saPaymentDetailTotal.accountBalance}
				</td>
				<td>
					${fns:getDictLabel(saPaymentDetailTotal.orderStates, 'order_states', '')}
				</td>
				<td>
					${saPaymentDetailTotal.oldRunningNumber}
				</td>
				<td>
					${saPaymentDetailTotal.showCode}
				</td>
				<td>
					${saPaymentDetailTotal.remarks}
				</td>
				<td>
					${fns:escapeHtml(saPaymentDetailTotal.updateBy.name)}
				</td>
				<%--<td>--%>
					<%--<a href="${ctx}/finance/paymentOrder/form?orderCode=${saPaymentDetailTotal.runningNumber}">详情</a>--%>
				<%--</td>--%>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>