<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>纯种犬鉴定申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
				    var haddleWay = $('#haddleWay').val();
					if(haddleWay == "1"){
						var province = $('#province').val();
						var hospitalCode = $('#hospitalCode').val();
						if(province == ''  || hospitalCode == ''){
							alert("请选择合作机构");
							return false;
						}
						
					}
											
 				    $.post('${ctx}/newdogchip/dogChip/saveOrg',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("修改成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("修改失败,错误信息："+data.msg);
 						} 
 				    });
 				    
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			var haddleWay = '${dogChip.haddleWay}';
			var province = '${dogChip.province}';
			var hospitalCode = '${dogChip.hospitalCode}';
			if(haddleWay == '1'){
				$.post('${ctx}/sys/org/getOrg', {
					province: province
				}, function(data) {
					$('#hospitalCode').empty();
					$('#hospitalCode').append("<option value =''>选择合作机构</option>");
					$.each(data, function(i,val) {
						if(val.id == hospitalCode){
							$('#hospitalCode').append("<option selected = 'selected'  value ='"+val.id+"'>"+val.name+"</option>");
						}else{
							$('#hospitalCode').append("<option value ='"+val.id+"'>"+val.name+"</option>");
						}
						
					});
					$('#hospitalCode').trigger("change");
				});
			} else {
				$('#province').attr("disabled","true");
				$('#hospitalCode').attr("disabled","true");
			}


			$('.haddle-way').change(function(){
				var data = $(this).val();
				if('1' == data){
					$('#province').removeAttr("disabled");
					$('#hospitalCode').removeAttr("disabled");

					$('#province').empty();
					$('#province').append("<option value =''>选择地区</option>");
					var array = new Array();
				    <c:forEach items="${provinceList}" var="item" varStatus="status" >
				        array.push("${item}");
				    </c:forEach>
				    for(var i=0;i<array.length;i++){
				    	$('#province').append("<option value ='"+array[i]+"'>"+array[i]+"</option>");
				    }
				    $('#province').trigger("change");
					
				}else{
					$('#hospitalCode').empty();
					$('#hospitalCode').append("<option value =''>选择合作机构</option>");
					$('#hospitalCode').trigger("change");

					$('#province').empty();
					$('#province').append("<option value =''>选择地区</option>");
					$('#province').trigger("change");
					
					$('#province').attr("disabled","true");
					$('#hospitalCode').attr("disabled","true");
				}
			})
		});
		
		function closeLayer(){
			parent.layer.closeAll();
		}

		
		function getOrgByProvince(){
			var province = $("#province").val();
			$.post('${ctx}/sys/org/getOrg', {
				province: province
			}, function(data) {
				$('#hospitalCode').empty();
				$('#hospitalCode').append("<option value =''>选择合作机构</option>");
				$.each(data, function(i,val) {
					$('#hospitalCode').append("<option value ='"+val.id+"'>"+val.name+"</option>");
				});
				$('#hospitalCode').trigger("change");
			});
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogChip" class="form-horizontal">
	<form:hidden path="id"/>
	<form:hidden path="oldHaddleWay" /> 
	
	<div class="control-group">
		<label class="control-label">出生纸编号：</label>
		<div class="controls">
			${fns:escapeHtml(dogChip.birthCode)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬主人：</label>
		<div class="controls">
			${fns:escapeHtml(dogChip.dogBirthCertificate.tempUserName)}
		</div>
	</div>
	
	<div class="control-group">
		<label class="control-label">申请日期：</label>
		<div class="controls">
			<fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
		</div>
	</div>
	
	<div class="control-group"> 
		<label class="control-label">办理类型：</label>
		<form:select id="haddleWay" path="haddleWay" class="input-medium haddle-way" >
			<form:option value="0" label="自主办理"/>
			<form:option value="1" label="合作机构"/>
		</form:select>
	</div>
	
	<div class="control-group"> 
		<label class="control-label">合作机构：</label>
		<form:select path="province" class="input-medium" onchange="getOrgByProvince()">
			<form:option value="" label="选择地区"/>
			<form:options items="${provinceList}" itemLabel="name" itemValue="name" htmlEscape="false"/>
		</form:select>
	</div>
	
	
	<div class="control-group"> 
		<label class="control-label">	</label>
		<form:select path="hospitalCode" class="input-xlarge">
		</form:select>
	</div>
	
	<div class="control-group">
		<label class="control-label">处理状态：</label>
		<div class="controls">
			${fns:getDictLabel(dogChip.processState, 'proccess_state', '')}
		</div>
	</div>
	
	<div class="control-group" style="text-align: center;">
		<c:if test="${dogChip.processState eq '0'}">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		</c:if>
		
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>