<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>登记卡变更</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		</script>		
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>

<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/birthcertificate/dogBirthCertificate/transferList">登记卡管理</a></li>
		<li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/transferForm?id=${fns:escapeHtml(dogBirthCertificateTransfer.id)}">登记卡变更</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="obj" action="${ctx}/birthcertificate/dogBirthCertificate/transferEdit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">登记卡编号：</label>
			<div class="controls">
				<input id="birthCode" name="birthCode" type="text" readonly="readonly" value="${obj.birthCode}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<input id="idNo" name="idNo" type="text" readonly="readonly" value="${obj.idNo}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文犬名：</label>
			<div class="controls">
				<input id="dogEnName" name="dogEnName" type="text" readonly="readonly" value="${obj.dogEnName}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input id="dogGender" name="dogGender" type="text" readonly="readonly" value="${fns:getDictLabels(obj.dogGender, 'dog_gender', '')}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
         <div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="dogBirth" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${obj.dogBirth}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
        
		<div class="control-group">
			<label class="control-label">种类：</label>
			<div class="controls">
				<input id="dogBreed" name="dogBreed" type="text" readonly="readonly" value="${obj.dogBreed}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
        
        <div class="control-group">
			<label class="control-label">繁殖人：</label>
			<div class="controls">
				<input id="transferorMemberName" name="transferorMemberName" type="text" readonly="readonly" value="${obj.transferorMemberName}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
        <div class="control-group">
			<label class="control-label">繁殖人会员号：</label>
			<div class="controls">
				<input id="transferorMemberCode" name="transferorMemberCode" type="text" readonly="readonly" value="${obj.transferorMemberCode}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
       	<div class="control-group">
			<label class="control-label">新犬主：</label>
			<div class="controls">
				<input id="receiverMemberName" name="receiverMemberName" type="text" readonly="readonly" value="${obj.receiverMemberName}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
		 <div class="control-group">
			<label class="control-label">新犬主会员号：</label>
			<div class="controls">
				<input id="receiverMemberCode" name="receiverMemberCode" type="text" readonly="readonly" value="${obj.receiverMemberCode}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
         <div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${obj.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">审核状态 ：</label>
			<div class="controls">
				 <form:select path="businessStatus"  class="input-xlarge ">
					<form:option value="" label=""/>
					<form:option value="1" label="待审核"  selected="${obj.businessStatus=='2'?'selected':''}" />
					<form:option value="1" label="未通过"  selected="${obj.businessStatus=='1'?'selected':''}" />
					<form:option value="0" label="通过" selected="${obj.businessStatus=='0'?'selected':''}"  />
				</form:select>
			</div>
		</div>
			
	
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remark" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge"/>
			</div>
		</div>
		
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>