<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>培训场馆管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handlervenue/handlerVenue/">培训场馆列表</a></li>
		<shiro:hasPermission name="handlervenue:handlerVenue:edit"><li><a href="${ctx}/handlervenue/handlerVenue/form">培训场馆添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerVenue" action="${ctx}/handlervenue/handlerVenue/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>修改时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="handlervenue:handlerVenue:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerVenue">
			<tr>
				<td><a href="${ctx}/handlervenue/handlerVenue/form?id=${handlerVenue.id}">
					<fmt:formatDate value="${handlerVenue.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</a></td>
				<td>
					${handlerVenue.remarks}
				</td>
				<shiro:hasPermission name="handlervenue:handlerVenue:edit"><td>
    				<a href="${ctx}/handlervenue/handlerVenue/form?id=${handlerVenue.id}">修改</a>
					<a href="${ctx}/handlervenue/handlerVenue/delete?id=${handlerVenue.id}" onclick="return confirmx('确认要删除该培训场馆吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>