<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!-- 使用说明， 通过module决定要传的文件的对应的模块。 successCallback是个js的方法名，是回调函数，可以传出文件信息和服务器的反馈信息 -->
<%@ attribute name="module" type="java.lang.String" required="true" description="文件上传之后的目录，会影响物理文件存储" %>
<%@ attribute name="hideUploadedState" type="java.lang.Boolean" required="false" description="是否隐藏上传结果" %>
<%@ attribute name="fileNumLimit" type="java.lang.String" required="false" description="限制文件的上传的个数" %>
<%@ attribute name="fileSizeLimit" type="java.lang.String" required="false" description="限制文件的上传的总大小" %>
<%@ attribute name="fileSingleSizeLimit" type="java.lang.String" required="false" description="单一的文件大小的限制" %>
<%@ attribute name="uploadedReset" type="java.lang.Boolean" required="false" description="上传文件后重置上传组件" %>
<%@ attribute name="successCallback" type="java.lang.String" required="false" description="文件上传成功的回调方法，有俩个参数(file,response),对应文件信息和服务器的反馈"%>
<script type="text/javascript" src="${ctxStatic }/webuploader/webuploader.js"></script>
<link rel="stylesheet" href="${ctxStatic }/webuploader/webuploader.css"/>
<div id="uploader" >
    <!--用来存放文件信息-->
    <div id="thelist" class="uploader-list"></div>
    <div class="btns">
        <div id="picker" class="fileBtn">选择文件</div>
        <button id="ctlBtn" class="btn btn-primary">
        	<span>上传<img src="${ctxStatic}/img/upload.png" class="ctlBtn-icon-right" /></span>
        </button>
    </div>
</div>
<style>
	.btns{
		display: flex;
		align-item: center
	}
	#ctlBtn{
		width: 80px;
		height: 40px;
		margin-left:10px;
	}
	.fileBtn{
		display: inline-block;
    	vertical-align: middle;
	}
	.uploaded{
		color:#5cb85c;
		font-weight: 900;
	}
	.rmFileQueued{
		margin-left:10px;
		font-size:12px;
		color:#ce4844;
		cursor:pointer;
	}
</style>
<script type="text/javascript">
var fileuploader = null;
jQuery(function() {
	var state = 'pending';
	fileuploader = WebUploader.create({
	    // swf文件路径
	    swf: '${ctxStatic}/webuploader/Uploader.swf',
	    // 文件接收服务端。
	    server: '${fns:getOssEndpoint()}',
	    // 选择文件的按钮。可选。
	    // 内部根据当前运行是创建，可能是input元素，也可能是flash.
	    pick: '#picker',
	    duplicate:false,
	    //文件的数量的限制
	  	<c:if test="${not empty fileNumLimit}">
	    fileNumLimit: ${fileNumLimit},
	 	</c:if>
	    //文件总大小的限制
	  	<c:if test="${fileSizeLimit}">
    	fileSizeLimit: ${fileSizeLimit},
	    </c:if>
	  	<c:if test="${fileSingleSizeLimit}">
	    //单一文件的大小的限制
	    fileSingleSizeLimit: ${fileSingleSizeLimit},
	    </c:if>
	    // 不压缩image, 默认如果是jpeg，文件上传前会压缩一把再上传！
	    resize: false
	});
	fileuploader.on('uploadBeforeSend', function (obj, data, headers) {
		$.ajax({  
	      	type : "POST",  
        	url : "${ctx}/sys/file/signature",  
	        timeout : 10000,
	        data : {"module":"${module}","fileName":obj.file.name},
	        dataType:"JSON",
	        success : function(result) {
	        	$("#"+ obj.file.id + "_url").val("${fns:getOssEndpoint()}/" + result.dir);
	            data = $.extend(data,{
                    'key' : result.dir,//这里最好在后台处理好
                    'policy': result.policy,
                    'OSSAccessKeyId': result.accessid, 
                    'success_action_status' : '200', //让服务端返回200,不然，默认会返回204
                    //'callback' : result.callback,
                    'signature': result.signature,
                    'Content-Disposition':"attachment;filename="+obj.file.name
                });
	        },  
	        error : function(XMLHttpRequest, textStatus, errorThrown) {  
	            alert("ajax error");  
	        },  
	        async : false 
		});
		//headers['Access-Control-Allow-Origin'] = "*";  
	});
	
	//当有文件被添加进队列的时候
	fileuploader.on('filesQueued', function( files ) {
		for(var idx in files){
			var file = files[idx];
			$("#thelist").append( '<div id="' + file.id + '" class="item">' +
		        '<h4 class="info">' + file.name + '<span fileId="'+file.id+'" class="rmFileQueued" bind="false" title="删除">X</span></h4>' +
		        '<p class="state">等待上传...</p>' +
		        '<input id="' + file.id + '_url" name="WU_FILE" type="hidden" disabled="disabled"/>' +
		    '</div>' );
		}
		
	    $("#thelist .rmFileQueued[bind='false']").click(function(obj){
	    	fileuploader.removeFile($(this).attr("fileId"),true);
	    	$(this).parent().parent().remove();
		});
	    $("#thelist .rmFileQueued").attr("bind","true");
	});
	
	//文件上传的实时进度条
	fileuploader.on('uploadProgress', function( file, percentage ) {
	    var $li = $('#'+file.id );
	    var $percent = $li.find('.progress .progress-bar');
	    // 避免重复创建
	    if (!$percent.length ) {
	        $percent = $('<div class="progress progress-striped active">' +
	          '<div class="progress-bar" role="progressbar" style="width: 0%">' +
	          '</div>' +
	        '</div>').appendTo($li).find('.progress-bar');
	    }
	    $li.find('p.state').text('上传中');
	    $percent.css( 'width', percentage * 100 + '%' );
	});
	
    fileuploader.onError = function( code ) {
    	if(code == "Q_EXCEED_NUM_LIMIT"){
    		alert("上传文件数量已超出数量最大限制！");
    	}else if(code == "Q_EXCEED_SIZE_LIMIT"){
    		alert("上传文件数量已超出大小限制");
    	}else if(code == "Q_TYPE_DENIED"){
    		alert("文件类型错误，请选择正确的文件上传！");
    	}else if(code = "F_DUPLICATE"){
        	alert("文件已经被添加了，不能重复添加文件");
        }else{
        	alert("上传出错");
        }
    };
	
	//上传成功
	fileuploader.on('uploadSuccess', function( file,response ) {
	    $("#"+ file.id).find('p.state').text('已上传').addClass("uploaded");
	    $("#"+ file.id + "_url").removeAttr("disabled");
	    if("${hideUploadedState}" == "true"){
	    	$("#"+ file.id).fadeOut();
	    }
	    <c:if test="${not empty successCallback}">
		    if(typeof ${successCallback} === "function"){
		    	response.fileUrl = $("#"+ file.id + "_url").val();
		    	${successCallback}(file,response);
		    }
	    </c:if>
	});
	
	//上传失败
	fileuploader.on('uploadError', function( file ) {
	    $( '#'+file.id ).find('p.state').text('上传出错');
	});
	
	//不管成功失败，完成上传
	fileuploader.on('uploadComplete', function( file ) {
	    $( '#'+file.id ).find('.progress').fadeOut();
	    <c:if test="${not empty uploadedReset && uploadedReset}">
	    	fileuploader.reset();
	    </c:if>
	});
	
	$("#ctlBtn").on( 'click', function() {
	    if ( state === 'uploading' ) {
	        fileuploader.stop();
	    } else {
	        fileuploader.upload();
	    }
	    $("#ctlBtn").blur();
	    return false;
	});
			
});
</script>
