/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.breeder.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.dao.StudDogDao;
import com.cku.oa.breeder.entity.StudDog;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ImgUtil;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;

/**
 * @description: 种公业务
 * @author: laiguanglong
 * @date: 2017/10/16 10:43
 */
@Service
@Transactional(readOnly = true)
public class RestStudDogServiceV2 {

    @Autowired
    private StudDogDao studDogDao;
    @Autowired
    private DogDao dogDao;
    @Autowired
    private StudDogService studDogService;
    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private KennelService kennelService;

    @Transactional(readOnly = false)
    public RESTResponse get(String id, HttpServletRequest request) {
        StudDog studDog = studDogDao.get(id);
        if (studDog == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
        }
        Dog dog = dogDao.get(studDog.getDogId());
        JSONObject data = new JSONObject();
        //犬只呼名
        data.put("nickname", getString(dog.getNickname()));
        //配种次数
        data.put("dogNewbornCount", getString(studDog.getDogNewbornCount()));
        //城市
        data.put("city", getString(studDog.getCity()));
        Member member = memberService.getByMemberCode(dog.getMemberCode());
        Kennel kennel = kennelService.getKennelByMemberCode(dog.getMemberCode());
        //犬种和年龄
        data.put("dogBreed", getString(dogTypeService.getBreedCnName(dog.getDogBreed())));
        data.put("age", getString(studDogService.getAge(dog.getBirthdate())));
        //犬英文名
        data.put("nameEn", getString(dog.getNameEn()));
        //犬舍名和价格
        String kennelName = "";
        if (kennel != null) {
            kennelName = kennel.getName();
        }
        data.put("kennelName", getString(kennelName));
        //犬主电话
        data.put("mobile", getString(member.getMobile()));
        data.put("memberName", getString(member.getName()));
        data.put("memberGender", getString(member.getGender()));
        data.put("pedigreeCertifiedCode", getString(dog.getPedigreeCertifiedCode()));
        //id
        data.put("id", studDog.getId());
        //标签
        JSONArray label = new JSONArray();
        if (StringUtils.isNotBlank(studDog.getLabel())) {
            for (String s : studDog.getLabel().split(",")) {
                label.add(DictUtils.getDictLabel(s, "stud_dog_label", ""));
            }
        }
        if (StringUtils.isNotBlank(studDog.getOtherLabel())) {
            for (String s : studDog.getOtherLabel().split(",")) {
                label.add(DictUtils.getDictLabel(s, "stud_dog_label", ""));
            }
        }
        data.put("label", label);
        data.put("price", getString(getInt(studDog.getPrice())));
        //是否可上门配种
        data.put("doorToDoorFlag", getString(studDog.getDoorToDoorFlag()));
        //犬主推荐
        data.put("recommendInfo", getString(studDog.getRecommendInfo()));
        //风采展示
        JSONArray img = new JSONArray();
        if (StringUtils.isNotBlank(studDog.getCoverImgId())) {
            img.add(getString(ImgUtil.getImgUrl(request, studDog.getCoverImgId())));
        }
        if (StringUtils.isNotBlank(studDog.getOtherImgId())) {
            for (String otherImgId : studDog.getOtherImgId().split(",")) {
                if (StringUtils.isNotBlank(otherImgId)) {
                    img.add(getString(ImgUtil.getImgUrl(request, otherImgId)));
                }
            }
        }
        data.put("img", img);
        //更新信息
        studDogService.dogChangeInfo(studDog, member);
        studDog.preUpdate();
        studDogDao.update(studDog);
        return new RESTResponse("data", data);
    }

    public RESTResponse getOtherInfo(String id) {
        StudDog studDog = studDogDao.get(id);
        if (studDog == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
        }
        Dog dog = dogDao.get(studDog.getDogId());
        JSONObject data = studDogService.studDogOtherInfo(dog);
        return new RESTResponse("data", data);
    }

    public String getInt(String price) {
        Double priceDouble = Double.parseDouble(price);
        return priceDouble.intValue() + "";
    }

    private String getString(String str) {
        return str == null ? "" : str;
    }
}