package com.cku.restful.v1.sys.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentPayLogService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.model.Unifiedorder;
import com.cku.restful.v1.sys.model.WXPayResult;
import com.cku.restful.v1.sys.utils.HttpXmlUtils;
import com.cku.restful.v1.sys.utils.JdomParseXmlUtils;
import com.cku.restful.v1.sys.utils.ParseXMLUtils;
import com.cku.restful.v1.sys.utils.RandCharsUtils;
import com.cku.restful.v1.sys.utils.WXSignUtils;
import com.cku.restful.v1.sys.utils.WeixinConfigUtils;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.config.Global;

/**
 *
 * <p>
 * Title:CabWeixinPayController
 * </p>
 * <p>
 * Description: 宠爱王国微信支付
 * </p>
 * <p>
 * Company:
 * </p>
 * 
 * @author zhuoHeng
 * @date 2016年12月22日 下午2:06:04
 */
@Controller
@RequestMapping(value = "/api/v1/open/cabWxPay")
public class MobileWeChatPayController extends BaseRestController {

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private ShopOrderService shopOrderService;
	@Autowired
	private RestShowApplyService restShowApplyService;
	@Autowired
	private PaymentPayLogService paymentPayLogService;
	private Logger logger = LoggerFactory.getLogger(WeixinPayController.class);

	/**
	 *
	 * @Description：获取微信预支付id
	 * @author: zhuoHeng
	 * @version: 2016年12月22日 下午1:59:59
	 * @throws IOException
	 */
	@RequestMapping("/getPrepayId")
	@ResponseBody
	@SuppressWarnings("all")
	public void getPrepayId(HttpServletRequest request, HttpServletResponse response) throws IOException {

		// 判断订单是否存在，是否为未付款
		String totalPrice = "";
		String memberName = "";
		String title = "";
		String orderId = request.getParameter("orderId");
		String ip = request.getRemoteAddr();
		String path = request.getContextPath();
		String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path;
		if (request.getHeader("x-forwarded-for") == null) {
			ip = request.getRemoteAddr();
		} else {
			ip = request.getHeader("x-forwarded-for");
		}
		PaymentOrder order = paymentOrderService.get(orderId);
		// 如果订单已删除。报错提示
		if ("1".equals(order.getDelFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已删除，请勿支付");
		}
		// 抢购订单必须使用余额支付
		if ("1".equals(order.getIsBuying())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "抢购订单只可用余额支付!");
		}
		if (order != null && order.getPaymentState().equals("1")) {
			totalPrice = order.getTotalPrice();
			memberName = order.getMemberName();
			title = "CKU业务扣费";
			// 支付宝、微信支付不允许支付包含赛事报名的订单
			if (restShowApplyService.isShowApplyOrder(order)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单包含赛事报名项，请用余额支付");
			}
		} else {
			// 判断是否是商城订单
			ShopOrder sOrder = shopOrderService.get(orderId);
			if (sOrder != null && sOrder.getPaymentState().equals("1")) {
				totalPrice = sOrder.getPrice();
				memberName = sOrder.getMemberName();
				title = "CKU商城扣费";
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单验证失败");
			}
		}

		WeixinConfigUtils config = new WeixinConfigUtils();
		// 参数组
		String appid = config.appid;
		String mch_id = config.mch_id;
		String nonce_str = RandCharsUtils.getRandomString(16);
		String body = "CKU业务订单支付";
		String attach = "备用参数，先留着，后面会有用的";
		String out_trade_no = orderId;
		// TODO 调整订单金额为真实订单金额
		int total_fee = new BigDecimal(totalPrice).multiply(new BigDecimal("100")).intValue();// 单位是分
		String environment = Global.getConfig("environment");
		if ("dev".equals(environment)) {
			total_fee = 1;
		}

		String spbill_create_ip = ip;
		String time_start = RandCharsUtils.timeStart();
		String time_expire = RandCharsUtils.timeExpire();
		String notify_url = basePath + config.notify_url;
		String trade_type = "APP";

		// 参数：开始生成签名
		SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
		parameters.put("appid", appid);
		parameters.put("mch_id", mch_id);
		parameters.put("nonce_str", nonce_str);
		parameters.put("body", body);
		parameters.put("attach", attach);
		parameters.put("out_trade_no", out_trade_no);
		parameters.put("total_fee", total_fee);
		parameters.put("time_start", time_start);
		parameters.put("time_expire", time_expire);
		parameters.put("notify_url", notify_url);
		parameters.put("trade_type", trade_type);
		parameters.put("spbill_create_ip", spbill_create_ip);
		// 构造签名
		String sign = WXSignUtils.createSign("UTF-8", parameters);

		// xml构造对象
		Unifiedorder unifiedorder = new Unifiedorder();
		unifiedorder.setAppid(appid);
		unifiedorder.setMch_id(mch_id);
		unifiedorder.setNonce_str(nonce_str);
		unifiedorder.setSign(sign);
		unifiedorder.setBody(body);
		unifiedorder.setAttach(attach);
		unifiedorder.setOut_trade_no(out_trade_no);
		unifiedorder.setTotal_fee(total_fee);
		unifiedorder.setSpbill_create_ip(spbill_create_ip);
		unifiedorder.setTime_start(time_start);
		unifiedorder.setTime_expire(time_expire);
		unifiedorder.setNotify_url(notify_url);
		unifiedorder.setTrade_type(trade_type);

		// 构造xml参数
		String xmlInfo = HttpXmlUtils.xmlInfo(unifiedorder);
		logger.debug("xmlInfo" + xmlInfo);

		String wxUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
		String method = "POST";
		String weixinPost = HttpXmlUtils.httpsRequest(wxUrl, method, xmlInfo).toString();

		logger.debug(weixinPost);
		// 增加支付日志
		paymentPayLogService.savePayLog(order.getId(), "24");

		Map<String, String> map = ParseXMLUtils.jdomParseXml(weixinPost);
		SortedMap<Object, Object> sortedMap = new TreeMap<Object, Object>();
		sortedMap.put("appid", appid);
		sortedMap.put("partnerid", mch_id);
		sortedMap.put("prepayid", map.get("prepay_id"));
		sortedMap.put("package", "Sign=WXPay");
		sortedMap.put("noncestr", nonce_str);
		sortedMap.put("timestamp", new Date().getTime() / 1000);

		// 二次构造签名
		String sign2 = WXSignUtils.createSign("UTF-8", sortedMap);
		sortedMap.put("sign", sign2);

		RESTResponse result = new RESTResponse("data", sortedMap);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 宠爱王国微信支付回调
	 * 
	 * @param request
	 */
	@RequestMapping(value = "/notifyUrlWeixin")
	public void notifyWeixinPayment(HttpServletRequest request, HttpServletResponse response) {
		try {
			BufferedReader reader = request.getReader();
			String line = "";
			StringBuffer inputString = new StringBuffer();

			PrintWriter writer = response.getWriter();
			while ((line = reader.readLine()) != null) {
				inputString.append(line);
			}
			if (reader != null) {
				reader.close();
			}
			logger.info("----[微信回调]接收到的报文---" + inputString.toString());
			if (!StringUtils.isEmpty(inputString.toString())) {
				// 增加支付日志
				WXPayResult wxPayResult = JdomParseXmlUtils.getWXPayResult(inputString.toString());
				// 保存回调的支付日志
				paymentPayLogService.updatePayInfo(wxPayResult.getOut_trade_no(), wxPayResult.getTransaction_id(),
						inputString.toString());
				if ("SUCCESS".equalsIgnoreCase(wxPayResult.getReturn_code())) {
					/*
					 * SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
					 * parameters.put("appid", wxPayResult.getAppid()); parameters.put("attach",
					 * wxPayResult.getAttach()); parameters.put("bank_type",
					 * wxPayResult.getBank_type()); parameters.put("cash_fee",
					 * wxPayResult.getCash_fee()); parameters.put("fee_type",
					 * wxPayResult.getFee_type()); parameters.put("is_subscribe",
					 * wxPayResult.getIs_subscribe()); parameters.put("mch_id",
					 * wxPayResult.getMch_id()); parameters.put("nonce_str",
					 * wxPayResult.getNonce_str()); parameters.put("openid",
					 * wxPayResult.getOpenid()); parameters.put("out_trade_no",
					 * wxPayResult.getOut_trade_no()); parameters.put("result_code",
					 * wxPayResult.getResult_code()); parameters.put("return_code",
					 * wxPayResult.getReturn_code()); parameters.put("time_end",
					 * wxPayResult.getTime_end()); parameters.put("total_fee",
					 * wxPayResult.getTotal_fee()); parameters.put("trade_type",
					 * wxPayResult.getTrade_type()); parameters.put("transaction_id",
					 * wxPayResult.getTransaction_id()); //反校验签名 String sign =
					 * WXSignUtils.createSign("UTF-8", parameters);
					 */
					boolean result = WXSignUtils.isWechatSign(WXSignUtils.dom4jXMLParse(inputString.toString()));
					String orderId = wxPayResult.getOut_trade_no();
					try {
						if (result) {
							// 修改订单的状态
							PaymentOrder order = paymentOrderService.get(orderId);
							if (order != null && order.getPaymentState().equals("1")
									&& !StringUtils.isEmpty(order.getOrderCode())) {
								// 修改支付方式
								order.setPaymentWay("24");// 24代表微信支付
								order.setTransactionId(wxPayResult.getTransaction_id());
								// 会员端支付后处理逻辑
								long current = System.currentTimeMillis();
								logger.info("处理支付回调业务处理 Start===============" + current);
								// 会员端支付后处理逻辑
								restOrderService.afterPay(order);
								logger.info("处理支付回调业务处理 End===============" + (System.currentTimeMillis() - current));
								// 修改支付日志支付状态
								paymentPayLogService.updatePayState(orderId, "2", null);
							} else if (order != null && order.getPaymentState().equals("2")
									&& !StringUtils.isEmpty(order.getOrderCode())) {
								logger.info("用户支付成功，订单已经处理过");
							} else {
								logger.error("用户支付成功，但是处理失败，没有找到待处理订单");
								// 修改支付日志支付状态
								paymentPayLogService.updatePayState(orderId, "3", "用户支付成功，但是处理失败，没有找到待处理订单");
							}
							writer.write(HttpXmlUtils.backWeixin("SUCCESS", "OK"));
						} else {
							writer.write(HttpXmlUtils.backWeixin("FAIL", "签名失败"));
							logger.error("---------微信支付验证签名失败----------");
							// 修改支付日志支付状态
							paymentPayLogService.updatePayState(orderId, "3", "验证签名失败");
						}
					} catch (Exception e) {
						// 修改支付日志支付状态
						paymentPayLogService.updatePayState(orderId, "3", ExceptionUtil.printStackTrace(e));
						logger.error("----微信支付处理失败---", e);
					}
				} else {
					writer.write(HttpXmlUtils.backWeixin("FAIL", wxPayResult.getReturn_msg()));
					// 修改支付日志支付状态
					paymentPayLogService.updatePayState(wxPayResult.getOut_trade_no(), "3",
							"返回码错误：" + wxPayResult.getReturn_msg());
					logger.error("---------微信支付返回Fail----------" + wxPayResult.getReturn_msg());
				}
				if (writer != null) {
					writer.close();
				}
			} else {
				writer.write(HttpXmlUtils.backWeixin("FAIL", "未获取到微信返回的结果"));
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
