package com.cku.restful.v1.open.request;

import com.cku.core.BasePageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author yuanshuai
 * @date 2023/8/14 11:23
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class DogNoseMockAddRequest implements Serializable {
	private static final long serialVersionUID = -1427074418416360621L;

	@ApiModelProperty("血统证书号")
	private String pedigreeCertified;

	@ApiModelProperty("芯片号")
	private String chipCode;

	@ApiModelProperty("犬只英文名")
	private String nameEn;

	@ApiModelProperty("犬种")
	private String dogBreed;

	@ApiModelProperty("鼻纹编号")
	@NotEmpty
	private String noseCode;
}
