package com.cku.restful.v1.open;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ListResultDto;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
//import com.cku.core.CaCheCode;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.restful.v1.dog.model.RestDog;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 为犬舍评选系统二期新增犬舍犬只查询功能Controller
 *
 * @author lintao
 * @version 2019-08-16
 */

@Controller
@RequestMapping(value = "/api/v1/open/dog")
public class OpenDogController extends BaseRestController {
    @Autowired
    private DogService dogService;
    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private DogNoseService dogNoseService;
    
    

    /**
     * @Description： 查询犬舍名下所有犬只，犬龄大于12个月
     * @author: lintao
     * @date: 2019/8/16 16:00
     */
    @RequestMapping(value = "/getDogList", method = RequestMethod.GET)
    @ResponseBody
    public void getDogList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        //获得参数
        String memberCode = request.getParameter("memberCode");
        String dogGender = request.getParameter("dogGender");
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");

        Character useDogAgeFlag = '1';

        //校验参数
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                    "pageNo和pageSize必须都为数字");
        }

        Dog dogInput = new Dog();

        // 设置分页参数
        Page<Dog> page = new Page<Dog>();
        page.setPageNo(pageNoInt);
        page.setPageSize(pageSizeInt);

        // 设置查询条件
        dogInput.setMemberCode(memberCode);
        dogInput.setGender(dogGender);
        dogInput.setPage(page);
        dogInput.setUseDogAgeFlag(useDogAgeFlag);

        // 查询数据集
        Page<Dog> pageResult = dogService.findPage(new Page<Dog>(request, response), dogInput);

        //组装返回对象
        List<Dog> dogList = pageResult.getList();
        List<RestDog> list = new ArrayList<RestDog>();
        for (Dog dog : dogList) {
            RestDog vo = new RestDog();
            BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
            if (StringUtils.isNotBlank(dog.getDogBreed())) {
                DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
                if (dogType != null) {
                    vo.setDogBreedName(dogType.getBreedCnName());
                }
            }
            list.add(vo);
        }
        long count = page.getCount();
        RESTResponse result = new RESTResponse("list", new PageBeanResult<RestDog>(list, count));
        ServletUtils.writeResponse(response, result);
    }
    
    
    @RequestMapping(value = "/getNoseCodes", method = RequestMethod.GET)
    @ResponseBody
    public ListResultDto<String>  getNoseCodes(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
    	//获得参数
        String num = request.getParameter("num");
        List<String> list = new ArrayList<>();
        for(int i=0;i<Integer.valueOf(num);i++) {
        	list.add( dogNoseService.getNextNoseCode());
        }
       
        return ListResultDto.success(list);
    }

}