package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.ListResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.restful.v1.dog.model.RequestDogDnaBloodUpdateOrg;
import com.cku.restful.v1.dog.request.RestDogDnaBindSamplingRequest;
import com.cku.restful.v1.dog.service.RestDogDnaBloodService;
import com.cku.restful.v1.dog.vo.DogDnaArchiveUnboundSampling;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Validated
@RestController
@RequestMapping("/api/v1/dog/dnablood")
@Api(tags = "手机App-繁育-DNA管理-张向")
public class RestDogDnaBloodController extends BaseRestController {

	@Autowired
	private RestDogDnaBloodService restDogDnaBloodService;

	@GetMapping("/list")
	@ApiOperation(value = "已申请/未申请列表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "当前页", paramType = "query"),
			@ApiImplicitParam(name = "pageSize", value = "总页数", paramType = "query"),
			@ApiImplicitParam(name = "current", value = "当亲位置1已申请 0 为申请", paramType = "query"),
			@ApiImplicitParam(name = "pedigreeCertified", value = "血统证书号", required = false, paramType = "query"),
			@ApiImplicitParam(name = "token", value = "token", paramType = "query") })
	public void list(HttpServletRequest request, HttpServletResponse response) throws Exception {
		RESTResponse result = restDogDnaBloodService.list(request);
		ServletUtils.writeResponse(response, result);
	}

	@PutMapping("/editOrganizationName")
	@ApiOperation(value = "修改合作机构")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", paramType = "query") })
	public void editOrganizationName(@RequestBody RequestDogDnaBloodUpdateOrg org, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogDnaBloodService.editOrganizationName(org);
		ServletUtils.writeResponse(response, result);
	}

	@GetMapping("/valid/refund/{id}")
	@ApiOperation(value = "校验是否退款")
	public ResultDto<Boolean> validRefund(@PathVariable("id") String id, HttpServletResponse response)
			throws IOException {
		if (restDogDnaBloodService.validRefund(id)) {
			return ResultDto.error(ZAErrorCode.ZA_ERC_PARAM_ERROR, "已申请退款的单据，无法绑定采样包");
		}
		return ResultDto.success(Boolean.FALSE);

	}
	
	@GetMapping("/valid/bindSampling/{id}")
	@ApiOperation(value = "绑定采样包前验证")
	public ResultDto<Boolean> validBindSampling(@PathVariable("id") String id, HttpServletResponse response) throws Exception {
		if (restDogDnaBloodService.validRefund(id)) {
			return ResultDto.error(ZAErrorCode.ZA_ERC_PARAM_ERROR, "已申请退款的单据，无法绑定采样包");
		}
		//验证是否需要父母犬主同意
		restDogDnaBloodService.validBindSampling(id);

		return ResultDto.success(Boolean.TRUE);
	}

	@PostMapping("/bind/sampling")
	@ApiOperation(value = "采样包绑定")
	public ResultDto<Boolean> bindSampling(@Valid @RequestBody RestDogDnaBindSamplingRequest request,
			HttpServletResponse response) throws IOException {
		return restDogDnaBloodService.bindSampling(request);
	}

	@GetMapping("/unbound/sampling")
	@ApiOperation(value = "未绑定采样包记录")
	public ListResultDto<DogDnaArchiveUnboundSampling> unboundSampling(HttpServletResponse response)
			throws IOException {
		return restDogDnaBloodService.unboundSampling();
	}

}
