/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.oa.dog.service.DogService;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import net.sf.json.JSONObject;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/cku/v1/dog")
public class CkuDogController extends BaseRestController {

	@Autowired
	private RestDogService restDogService;
	@Autowired
	private DogService dogService;
	/**
	 *
	 * @description: CKU官网根据血统证书号或芯片号进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午5:26:13
	 */
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getByKey(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: CKU官网近亲查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午2:09:19
	 */
	@RequestMapping(value = "/bloodline", method = RequestMethod.GET)
	@ResponseBody
	public void bloodline(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.bloodline(request);
		if (result.getData() != null && result.getData().get("data") != null) {
			restDogService.desensitizeBloodline((JSONObject) result.getData().get("data"));
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 宠爱王国估值信息查询
	 * @author: Jack Xu
	 * @date: 2016年11月17日 下午11:00:00
	 */
	@RequestMapping(value = "/evaluate", method = RequestMethod.GET)
	@ResponseBody
	public void evaluate(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.evaluate(request);

		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 淘宠宝犬只信息查询(证书号/芯片查询)
	 * @Author chaixueteng
	 * @2017年10月12日下午4:04:53
	 */
	@RequestMapping(value = "getClubDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getClubDogByKey(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getClubDogByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: 宠爱王国保险查询犬只信息
	 * @author: cuihuaiyu
	 * @date: 2018年3月22日
	 */
	@RequestMapping(value = "/getByInsIdentificationFlag", method = RequestMethod.GET)
	@ResponseBody
	public void getByInsIdentificationFlag(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByInsIdentificationFlag(request);
		ServletUtils.writeResponse(response, result);
	}
	/**
	 *
	 * @description: 宠爱王国保险添加犬只时查询犬只信息
	 * @author: wangjie
	 * @date: 2018年5月9日
	 */
	@RequestMapping(value = "/getByInsIdentificationFlagWhenInsert", method = RequestMethod.GET)
	@ResponseBody
	public void getByInsIdentificationFlagWhenInsert(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByInsIdentificationFlagWhenInsert(request);
		ServletUtils.writeResponse(response, result);
	}
}