package com.cku.restful.v1.dog.vo.response;

import com.cku.oa.dog.enums.ParenthoodTypeEnum;
import com.cku.restful.v1.dog.vo.GeneticDiseaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 纯血犬基因检测报告response
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
@ApiModel("纯血犬基因检测报告")
public class DogGeneReportResponse implements Serializable {

	private static final long serialVersionUID = -5017052404471806330L;

	@ApiModelProperty("犬只ID")
	private String id;

	@ApiModelProperty("血统证书号")
	private String pedigreeCertifiedCode;

	@ApiModelProperty("芯片号")
	private String identificationFlag;

	@ApiModelProperty("英文姓名")
	private String nameEn;

	@ApiModelProperty("公母")
	private String gender;

	@ApiModelProperty("出生日期")
	private String birthdate;

	@ApiModelProperty("采样包编号")
	private String samplingCode;

	@ApiModelProperty("犬主人")
	private String dogOwner;

	@ApiModelProperty("会员号")
	private String memberCode;

	@ApiModelProperty("亲子关系(1:未鉴定,2:父亲已鉴定，3:母亲已鉴定,4:已鉴定)")
	private ParenthoodTypeEnum parenthoodType;

	@ApiModelProperty("DNA登记编号")
	private String dnaCode;

	@ApiModelProperty("基因编码")
	private String geneCode;

	@ApiModelProperty("遗传疾病")
	private GeneticDiseaseVo geneticDisease;

	@ApiModelProperty("签发")
	private String issueDate;

}
