package com.cku.restful.v1.dog.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.BasePageRequest;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogDnaParentsCompareAudit;
import com.cku.oa.dog.enums.DogDnaParentsCompareAuditReviewStateEnum;
import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.dog.vo.DogDnaParentsCompareAuditVO;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedApplyAuditRequest;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedAuditDetailResp;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedAuditPageResp;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class RestGoldCertifiedAuditService {

	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;

	@Autowired
	private SMSRemindService smsRemindService;

	public Page<GoldCertifiedAuditPageResp> findPage(BasePageRequest request) {
		Page<GoldCertifiedAuditPageResp> page = new Page<>(request);
		// 当前是犬主 双亲对比的状态正常 未审核的
		DogDnaParentsCompareAuditVO dogDnaParentsCompareAuditVO = new DogDnaParentsCompareAuditVO();
		List<DogDnaParentsCompareAuditVO> list = dogDnaParentsCompareAuditService
				.findPageFC(new Page<DogDnaParentsCompareAudit>(request), dogDnaParentsCompareAuditVO);

		List<GoldCertifiedAuditPageResp> listr = list.stream().map(a -> {
			GoldCertifiedAuditPageResp resp = new GoldCertifiedAuditPageResp();
			BeanUtils.copyProperties(a, resp);
			resp.setPedigreeCertifiedCode(a.getPedigreeCertified());
			return resp;
		}).collect(Collectors.toList());
		page.setList(listr);
		page.setCount(dogDnaParentsCompareAuditVO.getPage().getCount());
		return page;
	}
	
	public GoldCertifiedAuditDetailResp detail(String id) {
		return dogDnaParentsCompareAuditService.detail(id);
	}

	@Transactional(readOnly = false)
	public Boolean sendVerifyCode(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		smsRemindService.sendVerifyCode(request, member.getSafeMobile(), false,
				SMSRemindService.TYPE_SMS_GOLD_CERTIFIED_APPLY_AUDIT);
		return Boolean.TRUE;
	}

	@Transactional(readOnly = false)
	public Boolean audit(GoldCertifiedApplyAuditRequest request) throws Exception {
		Member member = UserUtils.getLoginMember();
		// 验证码 只有同意才需要验证码
		if (StringUtils.equals(request.getReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
			if (StringUtils.isBlank(request.getSmsCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "短信验证码不能为空");
			}
			if (!smsRemindService.checkVerifyCode(member.getSafeMobile(), request.getSmsCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码错误，请重试");
			}
		}
		// 状态过滤：未退款 存在
		DogDnaParentsCompareAuditVO vo = dogDnaParentsCompareAuditService.getByIdFC(request.getId());
		if (Objects.isNull(vo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到审核记录");
		}
		DogDnaParentsCompareAudit dogDnaParentsCompareAudit = new DogDnaParentsCompareAudit();
		dogDnaParentsCompareAudit.setId(request.getId());
		if (StringUtils.equals(vo.getFdogPedigreeCertified(), request.getPedigreeCertifiedCode())) {
			// 审核父犬
			if (!StringUtils.equals(vo.getFdogMemberCode(), member.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬主不符合");
			}
			if (StringUtils.equals(vo.getFdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬主已同意不能修改");
			}
			if (StringUtils.equals(vo.getFdogReviewState(), request.getReviewState())) {
				// 与库中状态相同不能操作
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核状态异常");
			}
			dogDnaParentsCompareAudit.setFdogMemberCode(member.getMemberCode());
			dogDnaParentsCompareAudit.setFdogReviewUserId(member.getUserId());
			dogDnaParentsCompareAudit.setFdogReviewState(request.getReviewState());
			dogDnaParentsCompareAudit.setFdogReviewRemarks(request.getReviewRemarks());
			dogDnaParentsCompareAudit.setFdogReviewTime(new Date());
			dogDnaParentsCompareAudit.setFdogMemberName(member.getName());

		} else if (StringUtils.equals(vo.getMdogPedigreeCertified(), request.getPedigreeCertifiedCode())) {
			// 审核母犬
			if (!StringUtils.equals(vo.getMdogMemberCode(), member.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬主不符合");
			}
			if (StringUtils.equals(vo.getMdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬主已同意不能修改");
			}
			if (StringUtils.equals(vo.getMdogReviewState(), request.getReviewState())) {
				// 与库中状态相同不能操作
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核状态异常");
			}
			dogDnaParentsCompareAudit.setMdogMemberCode(member.getMemberCode());
			dogDnaParentsCompareAudit.setMdogReviewUserId(member.getUserId());
			dogDnaParentsCompareAudit.setMdogReviewState(request.getReviewState());
			dogDnaParentsCompareAudit.setMdogReviewRemarks(request.getReviewRemarks());
			dogDnaParentsCompareAudit.setMdogReviewTime(new Date());
			dogDnaParentsCompareAudit.setMdogMemberName(member.getName());

		}else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核证书号有误！");
		}
		dogDnaParentsCompareAuditService.updateAuditById(dogDnaParentsCompareAudit);

		return Boolean.TRUE;

	}

}