/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.buying.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.buying.service.RestAdvertisementService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 抢购产品Entity
 * @author 柴雪腾
 * @version 2017-11-20
 */
@Controller
@RequestMapping(value = "/api/v1/scarebuying")
public class RestAdvertisementController extends BaseRestController {
	
	@Autowired 
	public RestAdvertisementService restAdvertisementService;
	
	
	/**
	 * 获取广告抢购列表
	 * @Author chaixueteng
	 * @2017年11月20日下午3:01:55
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restAdvertisementService.getList(request);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 点击购买进入购买页面
	 * @Author chaixueteng
	 * @2017年11月21日上午9:58:43
	 */
	@RequestMapping(value = "/advertisement/{pageItem}", method = RequestMethod.GET)
	@ResponseBody
	public void getDogNewborn(@PathVariable("pageItem") String pageItem,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restAdvertisementService.get(pageItem);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 根据犬种获取剩余数量
	 * @Author chaixueteng
	 * @2017年11月22日下午2:08:24
	 */
	@RequestMapping(value = "/getByDogType", method = RequestMethod.GET)
	@ResponseBody
	public void getByDogType(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		String version = request.getParameter("version");
		String dogType = request.getParameter("dogType");
		RESTResponse result = restAdvertisementService.getByDogType(id, version, dogType);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 确认购买
	 * @Author chaixueteng
	 * @2017年11月22日下午2:14:45
	 */
	@RequestMapping(value = "/buying", method = RequestMethod.POST)
	@ResponseBody
	public void postDogNewborn(@RequestBody String json,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restAdvertisementService.post(json);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 点击期数进入购买列表
	 * @Author chaixueteng
	 * @2017年11月21日上午9:58:43
	 */
	@RequestMapping(value = "/advertisement/version/{version}", method = RequestMethod.GET)
	@ResponseBody
	public void getByVersion(@PathVariable("version") String version,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restAdvertisementService.getByVersion(version);
		ServletUtils.writeResponse(response, result);
	}
}