package com.cku.partner.open.club.web;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.dog.entity.DogNoseResult;
import com.cku.oa.dog.service.DogNoseResultService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.vo.DogNoseInfoResponse;
import com.cku.oa.dog.vo.MatchChipNoResponseVo;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.restful.v1.dog.vo.DogNoseResultAddRecordVo;
import com.cku.restful.v1.dog.vo.DogNoseResultResponse;
import com.cku.restful.v1.dog.vo.NoseMatchVo;
import com.thinkgem.jeesite.modules.sys.entity.User;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Controller
@RequestMapping(value = "/partner/open/dognoseresult")
public class RestDogNoseResultController {

	@Autowired
	private DogNoseResultService dogNoseResultService;

	@Autowired
	private AppHospitalService appHospitalService;

	@Autowired
	private DogService dogService;

	@ApiOperation(value = "查询犬只信息", tags = { "鼻纹识别-zxy" })
	@RequestMapping(value = "/findDogInfo/{chipNo}", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<DogNoseInfoResponse> findDogInfo(
			@ApiParam(name = "chipNo", value = "chipNo") @PathVariable String chipNo, HttpServletResponse response) {
		return dogService.findDogInfo(chipNo);
	}

	@ApiOperation(value = "1:N匹配芯片号", tags = { "鼻纹识别-zxy" })
	@RequestMapping(value = "/matchChipNo", method = RequestMethod.POST)
	@ResponseBody
	public ListResultDto<MatchChipNoResponseVo> matchChipNo(@Valid @RequestBody NoseMatchVo vo, HttpServletRequest request,
			HttpServletResponse response) {
		return ListResultDto.success(dogNoseResultService.matchChipNo(vo));
	}

	@ApiOperation(value = "添加鼻纹识别记录", tags = { "鼻纹识别-zxy" })
	@RequestMapping(value = "/addRecord", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<DogNoseResultResponse> addRecord(@Valid @RequestBody DogNoseResultAddRecordVo vo,
			HttpServletRequest request, HttpServletResponse response) {
		User user = appHospitalService.loginUser();

		DogNoseResult dogNoseResult = new DogNoseResult();
		dogNoseResult.setClubCode(user.getLoginName());
		dogNoseResult.setNoseResult(vo.getNoseResult());
		dogNoseResult.setDeviceModel(vo.getDeviceModel());
		dogNoseResult.setDeviceType(vo.getDeviceType());
		dogNoseResult.setDogChip(vo.getDogChip());
		dogNoseResult.setDogNose(vo.getDogNose());
		dogNoseResult.setCreateDate(new Date());
		dogNoseResult.setNoseResult(vo.getNoseResult());
		dogNoseResult.setNoseResultInfo(vo.getNoseResultInfo());
		dogNoseResult.setNoseType(vo.getNoseType());
		dogNoseResult.setSuccessSort(vo.getSuccessSort());
		dogNoseResultService.save(dogNoseResult);
		return ResultDto.success(new DogNoseResultResponse(Boolean.TRUE));
		
	}

}
