package com.cku.partner.open.club.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.List;

/**
 *user chaixueteng
 *2016年10月13日
 */
@Service
@Transactional(readOnly = true)
public class AppHospitalService {
//	@Autowired
//	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private UserDao userDao;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogChipService dogChipService;
	/**
	* @Description:
	* @author: zhangxiang
	* @date: 2020/7/10 10:42
	*/
	public JSONObject searchByDogNose(String birthCode, String snCode) {
		JSONObject jo = new JSONObject();
		//Map<String,String> map=new HashMap<String,String>();
		//鼻纹采集采集状态
		jo.put("dogNoseState","0");
		//根据登记卡/芯片号查询
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
		if (dogBirthCertificate==null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡未申请!");
		}else{
			//查询
			int flag = 0;
			if(snCode.equals(dogBirthCertificate.getSnCode())){
				flag+=1;
			}
			if(snCode.equals(dogBirthCertificate.getIdentificationFlag())){
				flag+=1;
			}
			if(flag<1){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡编号与识别码/芯片号不匹配，请核对后重新输入!");
			}
			DogNose param = new DogNose();
			param.setDogBirthCertificateId(dogBirthCertificate.getId());
			//判断是否已经鼻纹采集
			DogNose dogNose = dogNoseService.getByParam(param);
			if(dogNose!=null){
				jo.put("dogNoseState","1");
			}
			//主装返回信息
			jo.put("birthCerRegCode",dogBirthCertificate.getBirthCerRegCode());
			DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
			jo.put("dogBreed",dogType == null ? "" : dogType.getBreedCnName());
			jo.put("dogEnName",dogBirthCertificate.getDogEnName());
			jo.put("dogGender",dogBirthCertificate.getDogGender());
			jo.put("dogBirthday",new SimpleDateFormat("yyyy-MM-dd").format(dogBirthCertificate.getDogBirthday()));
		}
		return jo;


		//return map;
	}
	//获取当前俱乐部
	public Org loginOrg(){
		User user = this.loginUser();
		Org org = new Org();
		org.setUser(user);
		List<Org> orgs = orgService.findList(org);
		if (orgs.size() == 1) {
			if (orgs.get(0).getEndDate().getTime() < System.currentTimeMillis()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您登陆的帐号已经过期，请联系CKU处理");
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
		}
		return orgs.get(0);
	}
	//获取当前登陆用户
	public User loginUser(){
		PartnerLoginUserInfo loginPartner = UserUtils.getLoginPartner();
		if(loginPartner.getId()==null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无俱乐部身份，请重新登陆！");
		}
		User user = userDao.get(loginPartner.getUserId());
		if(user==null || user.getId()==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无俱乐部身份，请重新登陆！");
		}
		return user;

	}
	//获取当前登陆会员
	public Member loginMember(){
		Org org = this.loginOrg();
		Member member = memberService.getByMemberCode(org.getMemberCode());
		if(member==null || member.getId()==null){
//			throw new ZAException(-1,"会员号无效！");
		}
		return member;
	}

	@Transactional(readOnly = false)
	public RESTResponse addDogNose(String json) {
		this.loginMember();
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("id") || jo.getString("id") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (!jo.containsKey("noseId") || jo.getString("noseId") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "noseId为空");
		}
		if (dogDao.get(jo.getString("id")) == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
		}
//		if (!jo.containsKey("memberCode") || jo.getString("memberCode") == null) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "memberCode为空");
//		}
//		Member m = memberService.getByMemberCode(jo.getString("memberCode"));
//		if (m == null) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号不正确");
//		}
		String flag = dogNoseService.saveNoseIdTOOrg(jo.getString("noseId"), null, jo.getString("id"), "-1");
		if (flag == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "鼻纹标识与库中信息重复！");
		return new RESTResponse();
	}

	@Transactional(rollbackFor = Exception.class)
	public RESTResponse addDogNoseByBirth(String json) {
		//this.loginMember();
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("birthCerRegCode") || jo.getString("birthCerRegCode") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡号为空");
		}
		if (!jo.containsKey("noseId") || jo.getString("noseId") == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "noseId为空");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
				.getByBirthCerRegCode(jo.getString("birthCerRegCode"));

		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡号不正确");
		}

//		if (!jo.containsKey("memberCode") || jo.getString("memberCode") == null) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "memberCode为空");
//		}
//		Member m = memberService.getByMemberCode(jo.getString("memberCode"));
//		if (m == null) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号不正确");
//		}

		String flag = dogNoseService.saveNoseIdTOOrg(jo.getString("noseId"), dogBirthCertificate.getId(), null , "");
		if (flag == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "鼻纹标识与库中信息重复！");
		}

//		DogChip dogChip = dogChipService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
//		if (dogChip != null) {
//			dogChipService.createBirthCode(dogChip.getId());
//		}
		return new RESTResponse();
	}

}
