package com.cku.partner.club.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping(value="/partner/dogSampling")
public class ClubDogSamplingController extends BaseController{
	
	@Autowired
	public SamplingService samplingService;
	

	@RequestMapping(value = "samplingCodeCheck")
	@ResponseBody
	public String samplingCodeCheck(HttpServletRequest request, HttpServletResponse response) {
		String samplingCode = request.getParameter("samplingCode");
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		
		try {
			samplingService.checkSamplingCode(samplingCode,org.getMemberCode());
		} catch (Exception e) {
			return "{\"rc\":-1,\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

}