/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao.user;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.report.vo.ReportMemberVO;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.sys.model.RestMember;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 用户会员信息表DAO接口
 * 
 * @author fanhuibin
 * @version 2016-07-13
 */
@MyBatisDao
public interface MemberDao extends CrudDao<Member> {

	/**
	 * 会员消息提醒
	 * 
	 * @param member
	 * @return
	 */
	List<Member> getList(int days);

	/**
	 * 美容师会员消息提醒
	 * 
	 * @Author chaixueteng
	 * @2016年9月27日下午2:10:14
	 */
	List<Member> getGroomerMemeberList(int days);

	Map findeOne(@Param("membercode") String membercode, @Param("startTime") Date startTime);

	int listCount(Member member);

	List<Member> findGroomerList(Member Member);
	
	List<Member> findGroomerCertificateList(Member Member);

	/**
	 * 会员与网站帐号绑定
	 * 
	 * @param member
	 * @return
	 */
	int updateBind(Member member);

	/**
	 * 会员扣费
	 * 
	 * @param memberCode
	 * @param changeVal
	 * @return
	 */
	int memberCharge(@Param("memberCode") String memberCode, @Param("changeVal") String changeVal);

	/**
	 * 会员充值
	 * 
	 * @param memberCode
	 * @param changeVal
	 * @return
	 */
	int memberRecharge(@Param("memberCode") String memberCode, @Param("changeVal") String changeVal,
			@Param("paymentTime") Date paymentTime);

	/**
	 * 新增会员余额变动记录
	 */
	int insertSysAccountBalanceChange(@Param("memberCode") String memberCode,
			@Param("runningNumber") String runningNumber, @Param("beforeChange") String beforeChange,
			@Param("changeAmount") String changeAmount);

	/**
	 * 查询会员
	 * 
	 * @param memberCode
	 * @return
	 */
	Member getByMemberCode(@Param("memberCode") String memberCode);

	/**
	 * 查询会员集合
	 * 
	 * @param memberCodes
	 * @return
	 */
	List<Member> getByMemberCodes(@Param("memberCodes") Set<String> memberCodes);

	Member getByUserId(@Param("userId") String userId);

	List<Member> findByMobile(@Param("mobile") String mobile);

	/**
	 * 同步证件照
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午7:09:29
	 */
	void synImage(@Param("memberCode") String memberCode, @Param("avatar") String avatar);

	/**
	 * 更新美容师会员信息
	 * 
	 * @Author chaixueteng
	 * @2016年8月20日上午11:15:10
	 */
	void updateGroomerMember(Member member);
	
	void updateGroomerMemberClub(Member member);

	/**
	 * 更新美容师截止日期
	 * 
	 * @Author chaixueteng
	 * @2016年8月31日下午7:25:15
	 */
	void updateGroomer(Member member);

	/**
	 * 申领资格证书 更改美容会员类型
	 * 
	 * @Author chaixueteng
	 * @2016年9月1日下午7:05:59
	 */
	void updateMember(Member newMember);

	/**
	 *
	 * @description: 更新犬舍联盟套餐类型和犬舍联盟有效截至时间为本年最后一天
	 * @author: laiguanglong
	 * @date: 2016年9月6日 上午11:24:38
	 */
	int updateKennelAlliance(@Param("memberCode") String memberCode, @Param("kuFlag") String kuFlag);

	/**
	 *
	 * @Description：根据会员号/手机号获取会员信息（CKU官网使用） @author: zhuoHeng
	 * @version: 2016年9月23日 下午7:00:45
	 */
	List<RestMember> getByMobile(@Param("mobile") String mobile);

	/**
	 * 身份证号查询会员
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日上午10:41:09
	 */
	Member getByCardNo(@Param("cardNo") String cardNo, @Param("memberSite") String memberSite);

	/**
	 * 校验emali,手机号,证件号重复验证
	 * 
	 * @Author chaixueteng
	 * @2016年10月11日下午2:07:38
	 */
	List<Member> check(@Param("param") String param, @Param("val") String val, @Param("memberSite") String memberSite);

	/**
	 * 俱乐部可以删除未缴费的会员
	 * 
	 * @Author chaixueteng
	 * @2016年10月11日下午3:45:40
	 */
	void deleteEnd(Member member);

	/**
	 * 会员打印状态修改
	 * 
	 * @Author chaixueteng
	 * @2016年11月1日下午3:07:05
	 */
	void restPrint(Member member);

	/**
	 *
	 * @Description：根据会员号对会员截止时间进行更改
	 * @author: zhuoHeng
	 * @version: 2016年10月31日 下午4:34:33
	 */
	int memberEndDatecharge(@Param("memberCode") String memberCode, @Param("endDate") Date endDate,
			@Param("memberType") String memberType, @Param("memberCardType") String memberCardType);

	/**
	 * 首页显示未审核的数量
	 * 
	 * @Author chaixueteng
	 * @2016年11月11日下午4:41:35
	 */
	int getAuditCount(Member member);

	/**
	 *
	 * @description: 更新会员类型
	 * @author: laiguanglong
	 * @date: 2016年11月16日 下午2:27:42
	 */
	void updateMemberType(@Param("memberCode") String memberCode, @Param("memberType") String memberType,
			@Param("memberCardType") String memberCardType);

	void updateRegisterFlag(@Param("memberCode") String memberCode, @Param("registerFlag") String registerFlag);

	/**
	 *
	 * @description: 根据身份证查询有效会员数
	 * @author: laiguanglong
	 * @date: 2016年11月22日 下午5:05:06
	 */
	int countByCardNo(Member member);

	/**
	 * 根据淘宠会员合同编号查询有效会员数
	 * 
	 * @param member
	 * @return
	 */
	int countByContractCode(Member member);

	/**
	 *
	 * @description: 获取过期会员，基础会员，专业会员过期一个月内的，一个收费项的
	 * @author: laiguanglong
	 * @date: 2016年11月22日 下午6:17:47
	 */
	List<Member> getExpireMemberOneMonthIn();

	/**
	 *
	 * @description: 获取过期会员，专业会员过期一个月以上的，两个收费项
	 * @author: laiguanglong
	 * @date: 2016年11月22日 下午6:17:47
	 */
	List<Member> getExpireMemberOneMonthOut();

	/**
	 *
	 * @Description：更改个人证件照
	 * @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:11:43
	 */
	void updateAvatar(@Param("avatar") String avatar, @Param("id") String id);

	// 获取10天后过期会员
	List<Member> getTenDayExpireMember();

	// 获取5天后过期会员
	List<Member> getFiveDayExpireMember();

	// 校验身份证是否在黑名单中
	int countOnCardNoBlackList(@Param("cardNo") String cardNo);

	/**
	 * @Description： 修改绑定的安全手机
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/21 10:58
	 */
	int updateMemberSafeMobile(Member member);
	
	int updateMemberAllMobile(Member member);

	int updateMemberEndDate(@Param("memberCode") String memberCode, @Param("memberEndDate") String memberEndDate);
	
	int updateMemberCardTypeAndEndDate(@Param("memberCode") String memberCode,@Param("memberCardType") String memberCardType, @Param("memberEndDate") String memberEndDate);
	
	int updateMemberCardType(@Param("memberCode") String memberCode,@Param("memberCardType") String memberCardType);

	/**
	 * @Description： 修改会员实名认证标识
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/21 10:58
	 */
	int updateMemberAuthentication(Member member);

	/**
	 * @Description： 修改会员身份证信息
	 * 
	 * @author: chaixueteng
	 * @date: 2017/12/21 10:58
	 */
	int updateCardNo(Member member);

	/**
	 * @description: 保存会员头像历史记录
	 * @author: laiguanglong
	 * @date: 2018/1/17 11:08
	 */
	int saveMemberAvatarHistory(Member member);

	void updateAccountBalance(@Param("memberCode") String memberCode,
			@Param("accountBalance") BigDecimal accountBalance);

	void updateRegistrant(@Param("memberCode") String memberCode, @Param("registrant") String registrant,
			@Param("clubName") String clubName);

	Member findMemberAndKennelByUserId(@Param("userId") String userId);

	/**
	 * @Description： 根据会员号获取会员犬舍信息
	 * 
	 * @author: yuanshuai
	 * @date: 2019/12/12 10:47
	 */
	Member findMemberAndKennelByMemberCode(@Param("memberCode") String memberCode);

	Member findMemberAndKennelByMemberId(@Param("memberId") String memberId);

	Member singleMember(@Param("memberCode") String memberCode, @Param("registrant") String registrant);

	/**
	 * @Description： 修改会员英文名
	 * 
	 * @author: yuanshuai
	 * @date: 2020/5/19 14:11
	 */
	int updateMemberNameEn(@Param("memberCode") String memberCode, @Param("nameEn") String nameEn);

	int updateUserId(@Param("userId") String userId, @Param("memberCode") String memberCode,
			@Param("mobile") String mobile);

	/**
	 * 查询会员
	 */
	List<Member> getByMemberCodeAMobile(@Param("memberCode") String memberCode);

	int updateDogNoseEdit(@Param("memberCode") String memberCode,
			@Param("dogNoseRepeatedDetection") String dogNoseRepeatedDetection,
			@Param("dogNoseLivenessDetection") String dogNoseLivenessDetection);

	int restoreMemberDogNoseDetection();

	int updateEndDateById(@Param("id") String id, @Param("endDate") String endDate);

	int updateGroomerEndDateById(@Param("id") String id, @Param("endDate") String endDate);
	
	Member findByMemberSiteAndCardNo(@Param("memberSite") String memberSite, @Param("cardNo") String cardNo);
	
	int invalidMemberByMemberCode(@Param("memberCode") String memberCode);
	
	String getLoginNameByUserId(@Param("userId") String userId);
	
	int reviseMemberCardType();
	
	List<ReportMemberVO> findReportMemberList(ReportMemberVO reportMemberVO);
	
	List<ReportMemberVO> findReportMemberListFExport(ReportMemberVO reportMemberVO);
	
	List<ReportMemberVO> findExportReportMemberList(ReportMemberVO reportMemberVO);
	
	int updateCabUserFlag(@Param("mobile") String mobile);
	
	int updateUserFlag(@Param("userId") String userId);

	List<Member> findMemberListByRegistrant(Member member);
	
}