/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.code;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容资格证书生成Entity
 * @author 柴雪腾
 * @version 2016-12-12
 */
public class SysCodeGroomer extends DataEntity<SysCodeGroomer> {
	
	private static final long serialVersionUID = 1L;
	private String year;		// 年份
	private String code;		// 基数
	private String level;		// 级别
	
	public SysCodeGroomer() {
		super();
	}

	public SysCodeGroomer(String id){
		super(id);
	}

	@Length(min=0, max=255, message="年份长度必须介于 0 和 255 之间")
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}
	
	@Length(min=0, max=255, message="基数长度必须介于 0 和 255 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=0, max=255, message="级别长度必须介于 0 和 255 之间")
	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}
	
}