package com.cku.oa.showRefereeDelegate.entity;


import com.cku.oa.groomerRefereeDelegate.entity.GroomerRefereeDelegateLog;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 赛事信息
 *
 * @author yuanshuai
 * @date 2021/1/29 11:19
 */
public class Show {

	/**
	 * 赛事编号
	 */
	@ExcelField(title = "犬展编号", align = 2, sort = 1)
	private String code;
	/**
	 * 赛事场次
	 */
	@ExcelField(title = "犬展场次", align = 2, sort = 7)
	private Integer count;
	/**
	 * 大区
	 */
	private ShowRegionEnum region;

	/**
	 * 大区字符串
	 */
	@ExcelField(title = "所属片区", align = 2, sort = 2)
	private String regionStr;
	/**
	 * 赛事开始日期
	 */
	@ExcelField(title = "犬展开始日期", align = 2, sort = 5)
	private Date startDate;
	/**
	 * 赛事结束日期
	 */
	@ExcelField(title = "犬展结束日期", align = 2, sort = 6)
	private Date endDate;
	/**
	 * 随机排序值
	 */
	private int sort;

	/**
	 * 城市
	 */
	@ExcelField(title = "城市", align = 2, sort = 4)
	private String city;

	/**
	 * 省份
	 */
	@ExcelField(title = "省份", align = 2, sort = 3)
	private String province;

	/**
	 * 裁判列表
	 */
	private List<Referee> refereeList;

	public Show() {
	}

	public Show(ShowRefereeDelegateLog delegateLog) {
		this.code = delegateLog.getMainShowId();
		this.count = delegateLog.getCount();
		this.region = ShowRegionEnum.getShowRegionByCode(Integer.valueOf(delegateLog.getRegion()));
		this.province = delegateLog.getProvince();
		this.city = delegateLog.getCity();
		this.startDate = delegateLog.getStartDate();
		this.endDate = delegateLog.getEndDate();
		this.refereeList = Lists.newArrayList();
		Arrays.stream(delegateLog.getReferees().split(",")).forEach(refereeName -> {
			Referee referee = new Referee();
			referee.setName(refereeName);
			refereeList.add(referee);
		});
	}

	public Show(GroomerRefereeDelegateLog delegateLog) {
		this.code = delegateLog.getMainShowId();
		this.count = delegateLog.getCount();
		this.region = ShowRegionEnum.getShowRegionByCode(Integer.valueOf(delegateLog.getRegion()));
		this.province = delegateLog.getProvince();
		this.city = delegateLog.getCity();
		this.startDate = delegateLog.getStartDate();
		this.endDate = delegateLog.getEndDate();
		this.refereeList = Lists.newArrayList();
		Arrays.stream(delegateLog.getReferees().split(",")).forEach(refereeName -> {
			Referee referee = new Referee();
			referee.setName(refereeName);
			refereeList.add(referee);
		});
	}

	public void init() {
		this.setSort(Double.valueOf(Math.random() * 100 + 1).intValue());
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}

	public ShowRegionEnum getRegion() {
		return region;
	}

	public void setRegion(ShowRegionEnum region) {
		this.region = region;
	}

	public String getRegionStr() {
		return regionStr;
	}

	public void setRegionStr(String regionStr) {
		this.regionStr = regionStr;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public int getSort() {
		return sort;
	}

	public void setSort(int sort) {
		this.sort = sort;
	}

	public List<Referee> getRefereeList() {
		return refereeList;
	}

	public void setRefereeList(List<Referee> refereeList) {
		this.refereeList = refereeList;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}
}
