package com.cku.oa.showRefereeDelegate.entity;


import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 赛事裁判
 *
 * @author yuanshuai
 * @date 2021/1/29 11:22
 */
public class Referee {
	/**
	 * 编号
	 */
	private String code;
	/**
	 * 名称
	 */
	@ExcelField(title = "裁判名称", align = 2, sort = 1)
	private String name;
	/**
	 * 级别字符串
	 */
	@ExcelField(title = "裁判级别", align = 2, sort = 2)
	private String levelStr;
	/**
	 * 级别字符串
	 */
	private RefereeLevelEnum level;
	/**
	 * 请假开始日期
	 */
	private Date leaveStartDate;
	/**
	 * 请假结束日期
	 */
	private Date leaveEndDate;
	/**
	 * 禁赛开始日期
	 */
	private Date banStartDate;
	/**
	 * 禁赛结束日期
	 */
	private Date banEndDate;
	/**
	 * 权重
	 */
	private int weight;
	/**
	 * 随机排序值
	 */
	private int sort;
	/**
	 * 执裁次数
	 * 根据裁判等级和比赛场次计算
	 */
	@ExcelField(title = "执裁次数", align = 2, sort = 3)
	private Integer joinCount;
	/**
	 * 已委派场次
	 */
	private int delegateCount;
	/**
	 * 已执裁大区
	 */
	private Map<ShowRegionEnum,Long> existRegion;
	/**
	 * 已执裁大区
	 */
	private Map<String,Long> existCity;
	/**
	 * 已执裁日期
	 */
	private List<Date> existDate;
	/**
	 * 补偿数量
	 */
	private int compensation;

	/**
	 * 执裁赛事(逗号分隔)
	 */
	private String shows;

	/**
	 * 请假时间（导入用）
	 */
	@ExcelField(title = "请假时间", align = 2, sort = 4)
	private String leaveStr;

	/**
	 * 裁判组不同期（用于判断裁判归属，同组裁判不能同周执裁）
	 */
	private String group;

	/**
	 * 新进审查员
	 */
	@ExcelField(title = "新进审查员", align = 2, sort = 5)
	private String newFlag;

	public void init() {
		this.setSort(Double.valueOf(Math.random() * 100 + 1).intValue());
		this.setWeight(100);
	}

	/**
	 * 随机排序值
	 */
	public void resetSort() {
		this.setSort(Double.valueOf(Math.random() * 100 + 1).intValue());
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		return this.name.equals(((Referee) o).name);
	}

	@Override
	public int hashCode() {
		return Objects.hash(code, name, levelStr, level, leaveStartDate, leaveEndDate, banStartDate, banEndDate, weight, sort, joinCount, delegateCount, existRegion, existDate, compensation, shows);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public RefereeLevelEnum getLevel() {
		return level;
	}

	public void setLevel(RefereeLevelEnum level) {
		this.level = level;
	}

	public String getLevelStr() {
		return levelStr;
	}

	public void setLevelStr(String levelStr) {
		this.levelStr = levelStr;
	}

	public Date getLeaveStartDate() {
		return leaveStartDate;
	}

	public void setLeaveStartDate(Date leaveStartDate) {
		this.leaveStartDate = leaveStartDate;
	}

	public Date getLeaveEndDate() {
		return leaveEndDate;
	}

	public void setLeaveEndDate(Date leaveEndDate) {
		this.leaveEndDate = leaveEndDate;
	}

	public Date getBanStartDate() {
		return banStartDate;
	}

	public void setBanStartDate(Date banStartDate) {
		this.banStartDate = banStartDate;
	}

	public Date getBanEndDate() {
		return banEndDate;
	}

	public void setBanEndDate(Date banEndDate) {
		this.banEndDate = banEndDate;
	}

	public int getWeight() {
		return weight;
	}

	public void setWeight(int weight) {
		this.weight = weight;
	}

	public int getSort() {
		return sort;
	}

	public void setSort(int sort) {
		this.sort = sort;
	}

	public Integer getJoinCount() {
		return joinCount;
	}

	public void setJoinCount(Integer joinCount) {
		this.joinCount = joinCount;
	}

	public int getDelegateCount() {
		return delegateCount;
	}

	public void setDelegateCount(int delegateCount) {
		this.delegateCount = delegateCount;
	}

	public Map<ShowRegionEnum, Long> getExistRegion() {
		return existRegion;
	}

	public void setExistRegion(Map<ShowRegionEnum, Long> existRegion) {
		this.existRegion = existRegion;
	}

	public Map<String, Long> getExistCity() {
		return existCity;
	}

	public void setExistCity(Map<String, Long> existCity) {
		this.existCity = existCity;
	}

	public List<Date> getExistDate() {
		return existDate;
	}

	public void setExistDate(List<Date> existDate) {
		this.existDate = existDate;
	}

	public int getCompensation() {
		return compensation;
	}

	public void setCompensation(int compensation) {
		this.compensation = compensation;
	}

	public String getShows() {
		return shows;
	}

	public void setShows(String shows) {
		this.shows = shows;
	}

	public String getLeaveStr() {
		return leaveStr;
	}

	public void setLeaveStr(String leaveStr) {
		this.leaveStr = leaveStr;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getNewFlag() {
		return newFlag;
	}

	public void setNewFlag(String newFlag) {
		this.newFlag = newFlag;
	}
}
