/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.web;

import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.service.DogAppraisalService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 赛场犬只鉴定表Controller
 *
 * @author lgl
 * @version 2016-08-09
 */
@Controller
@RequestMapping(value = "${adminPath}/apply/dogAppraisal")
public class ShowDogAppraisalController extends BaseController {

    @Autowired
    private DogAppraisalService dogAppraisalService;

    private final static String AUTHORITY_PRDFIX = "apply:dogAppraisal:";


    @ModelAttribute
    public DogAppraisal get(@RequestParam(required = false) String id) {
        DogAppraisal entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogAppraisalService.get(id);
        }
        if (entity == null) {
            entity = new DogAppraisal();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogAppraisal dogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogAppraisal> page = dogAppraisalService.findShowDogAppraisalPage(new Page<DogAppraisal>(request, response), dogAppraisal);
        model.addAttribute("page", page);
        return "oa/show/dogappraisal/dogAppraisalList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX+"print")
    @RequestMapping(value = "printList")
    public String printList(String showCodePrefix, Model model) {
        return dogAppraisalService.printList(showCodePrefix,model);
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "printOne")
    public String printOne(String id, Model model) {
        return dogAppraisalService.printOne(id, model);
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "print")
    @RequestMapping(value = "checkShowCode")
    @ResponseBody
    public Object checkShowCode(String showCodePrefix) {
        return dogAppraisalService.checkShowCode(showCodePrefix);
    }

}