package com.cku.oa.show.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.entity.ShowVenue;
import com.cku.oa.show.dao.ShowVenueDao;

/**
 * 赛事场馆Service
 * @author 柴雪腾
 * @version 2017-08-02
 */
@Service
@Transactional(readOnly = true)
public class ShowVenueService extends CrudService<ShowVenueDao, ShowVenue> {

	public ShowVenue get(String id) {
		return super.get(id);
	}
	
	public List<ShowVenue> findList(ShowVenue showVenue) {
		return super.findList(showVenue);
	}
	
	public Page<ShowVenue> findPage(Page<ShowVenue> page, ShowVenue showVenue) {
		return super.findPage(page, showVenue);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowVenue showVenue) {
		if (StringUtils.isNotBlank(showVenue.getVenueInfo())) {
			showVenue.setVenueInfo(StringEscapeUtils.unescapeHtml4(showVenue.getVenueInfo()));
		}
		super.save(showVenue);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowVenue showVenue) {
		super.delete(showVenue);
	}

	/**
	 * 查找所有赛事场馆
	 * @Author chaixueteng
	 * @2017年8月2日下午5:38:23
	 */
	public List<ShowVenue> findAllList() {
		return dao.findAllList(new ShowVenue());
	}
	
}