/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import org.hibernate.validator.constraints.Length;
import com.fasterxml.jackson.annotation.JsonBackReference;

import com.thinkgem.jeesite.common.persistence.TreeEntity;

/**
 * 商品类别Entity
 * @author lyy
 * @version 2016-08-11
 */
public class ShopGoodsClass extends TreeEntity<ShopGoodsClass> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 类别名称
	private String shortName;		//类别名称缩写
	private ShopGoodsClass parent;		// 父类主键
	private String parentIds;		// parent_ids
	private Integer sort;		// sort
	
	public ShopGoodsClass() {
		super();
	}

	public ShopGoodsClass(String id){
		super(id);
	}

	@Length(min=0, max=100, message="类别名称长度必须介于 0 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	@Length(min=0, max=50, message="类别缩写长度必须介于 0 和 50 之间")
	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	@JsonBackReference
	public ShopGoodsClass getParent() {
		return parent;
	}

	public void setParent(ShopGoodsClass parent) {
		this.parent = parent;
	}
	
	@Length(min=0, max=255, message="parent_ids长度必须介于 0 和 255 之间")
	public String getParentIds() {
		return parentIds;
	}

	public void setParentIds(String parentIds) {
		this.parentIds = parentIds;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getParentId() {
		return parent != null && parent.getId() != null ? parent.getId() : "0";
	}
}