package com.cku.oa.sfexpress.utils;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import com.cku.oa.sfexpress.entity.ExpressOrderRequest;
import com.cku.oa.sfexpress.entity.ExpressPushResponse;

public class XMLUtils {

	/**
	 * 对象转xml字符串
	 */
	public static String beanConvertXml(Object obj,Class<?> load) throws JAXBException {

		StringWriter sw = new StringWriter();
		JAXBContext jAXBContext = JAXBContext.newInstance(load);
		Marshaller marshaller = jAXBContext.createMarshaller();
		marshaller.setProperty("jaxb.encoding", "UTF-8");
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
		marshaller.marshal(obj, sw);
		
		return sw.toString();
	}

	/**
	 * xml字符串转对象
	 * 
	 * @return
	 * @throws JAXBException
	 */
	public static Object xmlConvertBean(Class clazz, String xmlStr) throws JAXBException {
		JAXBContext context = JAXBContext.newInstance(clazz);
		Unmarshaller unmarshaller = context.createUnmarshaller();
		StringReader sr = new StringReader(xmlStr);
		return unmarshaller.unmarshal(sr);
	}
}
