/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.report.entity;

import java.math.BigDecimal;
import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.report.vo.ReportMemberAreaVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 会员统计报表Entity
 * @author Sunny
 * @version 2022-04-15
 */
public class ReportMemberArea extends DataEntity<ReportMemberArea> {
	
	private static final long serialVersionUID = 1L;
	private String periodYear;		// 年份
	private String periodType;		// 周期类型：1：月,3：季度,6：半年,12：年
	private String periodNo;		// 周期数字
	private String officeName;		// 大区名称
	private String province;		// 省份
	private String cardType;		// 会员类型
	private BigDecimal validTotal;		// 有效数
	private BigDecimal renewalTotal;		// 续费数
	private BigDecimal addedTotal;		// 新增数
	private BigDecimal keepTotal;		// 留存数
	private BigDecimal lossTotal;		// 流失数
	private Date createTime;		// create_time
	private Date updateTime;		// update_time
	private String ruleVersion;		// 规则版本
	
	/**
	 * 冗余字段
	 */
	private String validGroup;
	private String addedGroup;
	private String lossGroup;
	private String renewalGroup;
	private String keepGroup;
	
	private String periodNo1;
	private String periodNo3;
	private String periodNo6;
	private String periodNo12;
	
	private ReportMemberAreaVo reportVo;
	
	public ReportMemberArea() {
		super();
	}

	public ReportMemberArea(String id){
		super(id);
	}

	@Length(min=1, max=10, message="年份长度必须介于 1 和 10 之间")
	public String getPeriodYear() {
		return periodYear;
	}

	public void setPeriodYear(String periodYear) {
		this.periodYear = periodYear;
	}
	
	@Length(min=1, max=10, message="周期类型：1：月,3：季度,6：半年,12：年长度必须介于 1 和 10 之间")
	public String getPeriodType() {
		return periodType;
	}

	public void setPeriodType(String periodType) {
		this.periodType = periodType;
	}
	
	@Length(min=1, max=10, message="周期数字长度必须介于 1 和 10 之间")
	public String getPeriodNo() {
		return periodNo;
	}

	public void setPeriodNo(String periodNo) {
		this.periodNo = periodNo;
	}
	
	@Length(min=0, max=32, message="大区名称长度必须介于 0 和 32 之间")
	public String getOfficeName() {
		return officeName;
	}

	public void setOfficeName(String officeName) {
		this.officeName = officeName;
	}
	
	@Length(min=0, max=64, message="省份长度必须介于 0 和 64 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}
	
	@Length(min=0, max=10, message="会员类型长度必须介于 0 和 10 之间")
	public String getCardType() {
		return cardType;
	}

	public void setCardType(String cardType) {
		this.cardType = cardType;
	}
	
	@Length(min=0, max=11, message="有效数长度必须介于 0 和 11 之间")
	public BigDecimal getValidTotal() {
		return validTotal;
	}

	public void setValidTotal(BigDecimal validTotal) {
		this.validTotal = validTotal;
	}
	
	@Length(min=0, max=11, message="续费数长度必须介于 0 和 11 之间")
	public BigDecimal getRenewalTotal() {
		return renewalTotal;
	}

	public void setRenewalTotal(BigDecimal renewalTotal) {
		this.renewalTotal = renewalTotal;
	}
	
	@Length(min=0, max=11, message="新增数长度必须介于 0 和 11 之间")
	public BigDecimal getAddedTotal() {
		return addedTotal;
	}

	public void setAddedTotal(BigDecimal addedTotal) {
		this.addedTotal = addedTotal;
	}
	
	@Length(min=0, max=11, message="留存数长度必须介于 0 和 11 之间")
	public BigDecimal getKeepTotal() {
		return keepTotal;
	}

	public void setKeepTotal(BigDecimal keepTotal) {
		this.keepTotal = keepTotal;
	}
	
	@Length(min=0, max=11, message="流失数长度必须介于 0 和 11 之间")
	public BigDecimal getLossTotal() {
		return lossTotal;
	}

	public void setLossTotal(BigDecimal lossTotal) {
		this.lossTotal = lossTotal;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
	
	@Length(min=1, max=20, message="规则版本长度必须介于 1 和 20 之间")
	public String getRuleVersion() {
		return ruleVersion;
	}

	public void setRuleVersion(String ruleVersion) {
		this.ruleVersion = ruleVersion;
	}

	public String getValidGroup() {
		return validGroup;
	}

	public void setValidGroup(String validGroup) {
		this.validGroup = validGroup;
	}

	public String getAddedGroup() {
		return addedGroup;
	}

	public void setAddedGroup(String addedGroup) {
		this.addedGroup = addedGroup;
	}

	public String getLossGroup() {
		return lossGroup;
	}

	public void setLossGroup(String lossGroup) {
		this.lossGroup = lossGroup;
	}

	public String getRenewalGroup() {
		return renewalGroup;
	}

	public void setRenewalGroup(String renewalGroup) {
		this.renewalGroup = renewalGroup;
	}

	public String getKeepGroup() {
		return keepGroup;
	}

	public void setKeepGroup(String keepGroup) {
		this.keepGroup = keepGroup;
	}

	public ReportMemberAreaVo getReportVo() {
		return reportVo;
	}

	public void setReportVo(ReportMemberAreaVo reportVo) {
		this.reportVo = reportVo;
	}

	public String getPeriodNo1() {
		return periodNo1;
	}

	public void setPeriodNo1(String periodNo1) {
		this.periodNo1 = periodNo1;
	}

	public String getPeriodNo3() {
		return periodNo3;
	}

	public void setPeriodNo3(String periodNo3) {
		this.periodNo3 = periodNo3;
	}

	public String getPeriodNo6() {
		return periodNo6;
	}

	public void setPeriodNo6(String periodNo6) {
		this.periodNo6 = periodNo6;
	}

	public String getPeriodNo12() {
		return periodNo12;
	}

	public void setPeriodNo12(String periodNo12) {
		this.periodNo12 = periodNo12;
	}
	
}