package com.cku.oa.org.vo;

import com.thinkgem.jeesite.common.persistence.Page;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 俱乐部采样包分组列表
 *
 * @author yuanshuai
 * @date 2023/5/28 15:47
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel
public class OrgSamplingGroupVo implements Serializable {

	// 俱乐部id
	private String orgId;
	// 俱乐部名称
	private String orgName;
	// 批次号
	private String batchNum;
	// 采样包数量
	private Integer num;
	//流程状态（0待邮寄，1已邮寄，2已送检，3检测成功，4检测失败，5已注销）
	private Integer flowState;
	// 采样包数量
	private Date postDate;
	//分页
	private Page<OrgSamplingGroupVo> page;
	//地址
	private String address;
	
}
