package com.cku.oa.notice.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.codehaus.plexus.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.notice.dao.NoticeDao;
import com.cku.oa.notice.entity.SysNode;
import com.cku.oa.notice.entity.SysSort;
import com.cku.oa.notice.vo.NoticeVO;
import com.cku.oa.notice.vo.SimpleNoticeVO;
import com.cku.oa.notice.vo.SimpleSortVO;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;

@Service
@Transactional(readOnly = true)
public class NoticeService {

	@Autowired
	private NoticeDao noticeDao;

	public RESTResponse getTitleList(HttpServletRequest request) {
		int num = 5;
		if (StringUtils.isNotBlank(request.getParameter("num"))) {
			num = Integer.valueOf(request.getParameter("num"));
		}
		List<SimpleNoticeVO> resultList = Lists.newArrayList();
		List<SysNode> list = noticeDao.getNewTitles(num, null);
		for (SysNode node : list) {
			SimpleNoticeVO vo = new SimpleNoticeVO();
			BeanUtils.copyProperties(node, vo);
			resultList.add(vo);
		}

		return new RESTResponse("data", resultList);
	}

	public RESTResponse getNoticeDetail(String id) {
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不能为空");
		}
		SysNode node = noticeDao.get(id);
		if (node == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
		}
		NoticeVO vo = new NoticeVO();
		BeanUtils.copyProperties(node, vo);
		return new RESTResponse("data", vo);
	}

	public RESTResponse getTitleListBySameSort(String id) {
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不能为空");
		}
		SysNode node = noticeDao.get(id);
		if (node == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确");
		}
		List<SimpleNoticeVO> resultList = Lists.newArrayList();
		if (StringUtils.isNotBlank(node.getSortId())) {
			SysNode param = new SysNode();
			param.setSortId(node.getSortId());
			param.setId(id);
			List<SysNode> list = noticeDao.getNewTitles(5, param);
			for (SysNode n : list) {
				SimpleNoticeVO vo = new SimpleNoticeVO();
				BeanUtils.copyProperties(n, vo);
				resultList.add(vo);
			}
		}

		return new RESTResponse("data", resultList);
	}

	public RESTResponse getSorts() {
		List<SimpleSortVO> resultList = Lists.newArrayList();
		List<SysSort> list = noticeDao.getSorts();
		for (SysSort n : list) {
			SimpleSortVO vo = new SimpleSortVO();
			BeanUtils.copyProperties(n, vo);
			resultList.add(vo);
		}
		return new RESTResponse("data", resultList);
	}

	public RESTResponse getTitleListBySortId(String sortId, HttpServletRequest request, HttpServletResponse response) {
		int pageNo = 1;
		int pageSize = 20;
		if (StringUtils.isNotBlank(request.getParameter("pageSize"))
				&& StringUtils.isNumeric(request.getParameter("pageSize"))) {
			pageSize = Integer.parseInt(request.getParameter("pageSize"));
		}
		if (StringUtils.isNotBlank(request.getParameter("pageNo"))
				&& StringUtils.isNumeric(request.getParameter("pageNo"))) {
			pageNo = Integer.parseInt(request.getParameter("pageNo"));
		}
		Page<SysNode> page = new Page<SysNode>(pageNo, pageSize);
		SysNode sysnode = new SysNode();
		sysnode.setSortId(sortId);
		sysnode.setPage(page);
		page.setList(noticeDao.findList(sysnode));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<SysNode>(0));
		}
		List<SimpleNoticeVO> list = page.getList().stream().map(a -> {
			SimpleNoticeVO vo = new SimpleNoticeVO();
			BeanUtils.copyProperties(a, vo);
			return vo;
		}).collect(Collectors.toList());
		return new RESTResponse("data", new PageBeanResult<SimpleNoticeVO>(list, page.getCount()));
	}

}
