/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬舍名称变更Entity
 * @author zhuguanjin
 * @version 2016-08-15
 */
public class KennelRename extends DataEntity<KennelRename> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String kennelCode;		// 犬舍编号
	private String originalNameCn;		// 原始犬舍中文名
	private String originalNameEn;		// 原始犬舍英文名
	private String newNameCn;		// 新犬舍中文名
	private String newNameEn;		// 新犬舍中文名
	private String fciKennel;		// fci犬舍名
	private String fciKennelBackup;		// 备用fci犬舍名
	private String paymentMoney;		// 付款的金额
	private String operator;        //操作人
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// payment_time
	private String processState;		// process_state
	private Date processTime;		// 流程变更的时间
	private String runningNumber;		// 流水号
	private String reviewRemarks;		// 审核的意见
	private Member member;			//会员
	private Date beginDate;			//筛选条件中的起始日期
	private Date endDate;			//筛选条件中的终止日期
	private Kennel kennel;          //犬舍
	private String paymentMemberCode;		// 付款会员号
	private String paymentChargingItemId;		//收费项id，用于设置price
	private String medalFlag;
	
	public KennelRename() {
		super();
	}

	public KennelRename(String id){
		super(id);
	}

	public KennelRename(String runningNumber,String paymentChargingItemId,String paymentMemberCode){
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}
	
	@Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=50, message="犬舍编号长度必须介于 0 和 50 之间")
	public String getKennelCode() {
		return kennelCode;
	}

	public void setKennelCode(String kennelCode) {
		this.kennelCode = kennelCode;
	}
	
	@Length(min=0, max=100, message="原始犬舍中文名长度必须介于 0 和 100 之间")
	public String getOriginalNameCn() {
		return originalNameCn;
	}

	public void setOriginalNameCn(String originalNameCn) {
		this.originalNameCn = originalNameCn;
	}
	
	@Length(min=0, max=100, message="原始犬舍英文名长度必须介于 0 和 100 之间")
	public String getOriginalNameEn() {
		return originalNameEn;
	}

	public void setOriginalNameEn(String originalNameEn) {
		this.originalNameEn = originalNameEn;
	}
	
	@Length(min=0, max=100, message="新犬舍中文名长度必须介于 0 和 100 之间")
	public String getNewNameCn() {
		return newNameCn;
	}

	public void setNewNameCn(String newNameCn) {
		this.newNameCn = newNameCn;
	}
	
	@Length(min=0, max=100, message="新犬舍中文名长度必须介于 0 和 100 之间")
	public String getNewNameEn() {
		return newNameEn;
	}

	public void setNewNameEn(String newNameEn) {
		this.newNameEn = newNameEn;
	}
	
	@Length(min=0, max=100, message="fci犬舍名长度必须介于 0 和 100 之间")
	public String getFciKennel() {
		return fciKennel;
	}

	public void setFciKennel(String fciKennel) {
		this.fciKennel = fciKennel;
	}
	
	@Length(min=0, max=100, message="备用fci犬舍名长度必须介于 0 和 100 之间")
	public String getFciKennelBackup() {
		return fciKennelBackup;
	}

	public void setFciKennelBackup(String fciKennelBackup) {
		this.fciKennelBackup = fciKennelBackup;
	}
	
	public String getPaymentMoney() {
		return paymentMoney;
	}

	public void setPaymentMoney(String paymentMoney) {
		this.paymentMoney = paymentMoney;
	}
	
	@Length(min=0, max=500, message="操作人长度必须介于 0 和 500 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@Length(min=0, max=20, message="process_state长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}
	
	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Kennel getKennel() {
		return kennel;
	}

	public void setKennel(Kennel kennel) {
		this.kennel = kennel;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getMedalFlag() {
		return medalFlag;
	}

	public void setMedalFlag(String medalFlag) {
		this.medalFlag = medalFlag;
	}
	
	
}