package com.cku.oa.groomer.web;

import com.alibaba.fastjson.JSON;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.enums.DogCategorysEnum;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * FCI美容资格证书Controller
 * @author hjx
 * @version 2024-12-04
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/fciGroomerQualificationCertificate")
public class FciGroomerQualificationCertificateController extends BaseController {

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	@Autowired
	private GroomerShowRefereeService showRefereeService;

	@ModelAttribute
	public FciGroomerQualificationCertificate get(@RequestParam(required=false) String id) {
		FciGroomerQualificationCertificate entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = fciGroomerQualificationCertificateService.get(id);
		}
		if (entity == null){
			entity = new FciGroomerQualificationCertificate();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:view")
	@RequestMapping(value = {"list", ""})
	public String list(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {

		Page<FciGroomerQualificationCertificate> page = fciGroomerQualificationCertificateService.findPage(new Page<>(request, response), fciGroomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/fciGroomerQualificationCertificateList";
	}

	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, Model model) {
		model.addAttribute("isView", 1);
		model.addAttribute("fciGroomerQualificationCertificate", fciGroomerQualificationCertificate);
		return "oa/groomer/fciGroomerQualificationCertificateView";
	}

	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:edit")
	@RequestMapping(value = "editForm")
	public String editForm(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, Model model) {
		logger.info("----------------fciGroomerQualificationCertificate--------------- :{}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificate));
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate1 = get(fciGroomerQualificationCertificate.getId());

		logger.info("----------------fciGroomerQualificationCertificate1--------------- :{}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificate1));
		List<String> showRefereeList = showRefereeService.findAllShowRefereeNameEn();
		List<String> dogCateGoryNames = DogCategorysEnum.getByCategoryName();
		model.addAttribute("dogCateGoryNames", dogCateGoryNames);
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("isView", 0);
		model.addAttribute("fciGroomerQualificationCertificate", fciGroomerQualificationCertificate);
		logger.info("----------------fciGroomerQualificationCertificate--------------- :{}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificate));
		return "oa/groomer/fciGroomerQualificationCertificateForm";
	}

	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:edit")
	@RequestMapping(value = "save")
	public String save(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, RedirectAttributes redirectAttributes) {
		try {
			restBeanValidator(fciGroomerQualificationCertificate);
			fciGroomerQualificationCertificateService.save(fciGroomerQualificationCertificate);
		} catch (ZAException e) {
			e.printStackTrace();
			return  "保存Fci美容资格证书失败";
		}
		addMessage(redirectAttributes, "保存美容师资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/fciGroomerQualificationCertificate/list/?repage";
	}
	
	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:del")
	@RequestMapping(value = "delete")
	public String delete(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, RedirectAttributes redirectAttributes) {
		fciGroomerQualificationCertificateService.delete(fciGroomerQualificationCertificate);
		addMessage(redirectAttributes, "删除Fci美容资格证书成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/fciGroomerQualificationCertificate/?repage";
	}

	/**
	 * Fci美容资格证书打印
	 * @Author chaixueteng
	 * @2016年8月23日上午10:54:38
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:export")
	@RequestMapping(value = "/print")
	public String printFciShowQgc(String id,Model model){
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.printFci(id);
		model.addAttribute("fciGroomerQualificationCertificate", fciGroomerQualificationCertificate);
		return "oa/groomer/fciGroomerQualificationCertificatePrintNew";

	}

	/**
	 * Fci资格证书导出(搜索维度)
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:export")
	@RequestMapping(value = "export")
	public String export(FciGroomerQualificationCertificate fciGroomerQualificationCertificate,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			fciGroomerQualificationCertificateService.export(fciGroomerQualificationCertificate,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出资格证书失败！失败信息："+e.getMessage());
		}
		return null;
	}

	/**
	 * 批量提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:edit")
	@RequestMapping(value = "batchReminder")
	public String reminder(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		String ids = request.getParameter("ids");
		fciGroomerQualificationCertificateService.batchrReminder(ids);
		addMessage(redirectAttributes, "提醒成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/fciGroomerQualificationCertificate/list/?repage";
	}

	/**
	 * 单个提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("groomer:fciGroomerQualificationCertificate:edit")
	@RequestMapping(value = "reminderOne")
	public String fciReminderOne(String id,HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		fciGroomerQualificationCertificateService.ficReminder(id);
		addMessage(redirectAttributes, "提醒成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/list/?repage";
	}

}