package com.cku.oa.groomer.service;
import com.cku.oa.groomer.dao.*;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;

import java.util.Date;

import com.alibaba.fastjson.JSON;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;

import com.alibaba.fastjson.JSONObject;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.common.ResultEnum;
import com.cku.oa.common.ResultVoUtil;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.enums.*;
import com.cku.oa.groomer.request.CommitWrittenExamDetailRequest;
import com.cku.oa.groomer.request.CommitWrittenExamRequest;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.cku.oa.sys.util.DateUtils;
import com.thinkgem.jeesite.common.utils.JedisUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import net.sf.json.JSONArray;

import static com.cku.restful.v1.groomer.service.RestGroomerRegisterService.*;

/**
 * 美容师报名表Service
 *
 * @author cxt
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class GroomerRegisterService extends CrudService<GroomerRegisterDao, GroomerRegister> {

	@Autowired
	public RemindService remindService;
	/**
	 * 验证Bean实例对象
	 */
	@Autowired
	protected Validator validator;
	@Autowired
	public GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	public GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	public GroomerShowDao groomerShowDao;
	@Autowired
	public MemberService memberService;
	
	@Autowired
	public GroomerShowRefereeService showRefereeService;
	
	@Autowired
	public GroomerShowBreedsService groomerShowBreedsService;
	
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	
	@Autowired
	private PaymentCartDao paymentCartDao;

	@Autowired
	private GroomerExamQuestionBankService groomerExamQuestionBankService;

	@Autowired
	private GroomerExamQuestionsService groomerExamQuestionsService;

	@Autowired
	private GroomerExamQuestionsOptionsService groomerExamQuestionsOptionsService;

	@Autowired
	private GroomerWrittenExamInfoService groomerWrittenExamInfoService;

	@Autowired
	private GroomerRegisterDao groomerRegisterDao;

	@Autowired
	private GroomerWrittenExamInfoDao groomerWrittenExamInfoDao;

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	@Autowired
	private FciGroomerQualificationCertificateDao fciGroomerQualificationCertificateDao;

	public GroomerRegister get(String id) {
		return super.get(id);
	}

	public List<GroomerRegister> findList(GroomerRegister groomerRegister) {
		return super.findList(groomerRegister);
	}

	public Page<GroomerRegister> findPage(Page<GroomerRegister> page, GroomerRegister groomerRegister) {
		return super.findPage(page, groomerRegister);
	}

	/**
	 * @Description： 领取资格证书（成绩为通过且同级别只显示一条）
	 * @author: zhangxiang
	 * @date: 2018/12/26 14:16
	 */
	public Page<GroomerRegister> findListWrite(Page<GroomerRegister> page, GroomerRegister groomerRegister) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		groomerRegister.setPage(page);
		page.setList(dao.findListWrite(groomerRegister));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<>(0));
		}
		return page;
	}

	@Transactional(readOnly = false)
	public void save(GroomerRegister groomerRegister) {
		super.save(groomerRegister);
	}


	@Transactional(readOnly = false)
	public void saveImg(GroomerRegister groomerRegister) {
		if (groomerRegister.getIsNewRecord()) {
			groomerRegister.preInsert();
			dao.insert(groomerRegister);
		} else {
			groomerRegister.preUpdate();
			groomerRegister.setReviewState("0");
			dao.update(groomerRegister);
			memberService.synImage(groomerRegister.getMemberCode(), groomerRegister.getAvatar());
		}
	}


	public List<GroomerRegister> findListByMember(List<Member> memberList, String showCode) {
		return dao.findListByMember(memberList, showCode);
	}


	@Transactional(readOnly = false)
	public void delete(GroomerRegister groomerRegister) {
		super.delete(groomerRegister);
	}

	// 返回活动已结束需要录入成绩的页面
	public Page<GroomerRegister> findGradePage(Page<GroomerRegister> page, GroomerRegister groomerRegister) {
		groomerRegister.setPage(page);
		page.setList(dao.findGradePage(groomerRegister));
		return page;
	}

	@Transactional(readOnly = false)
	public void mobileSaveBatch(GroomerRegister groomerRegister) {
		String codes = groomerRegister.getMemberCodesStr().endsWith(",")
				? groomerRegister.getMemberCodesStr().substring(0, groomerRegister.getMemberCodesStr().length() - 1)
				: groomerRegister.getMemberCodesStr();
		groomerRegister.setMemberCodes(Arrays.asList(codes.split(",")));
		/*if (CollectionUtils.isEmpty(groomerRegister.getMemberCodes())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无报名会员，请检查重试!");
		}*/
		GroomerShow groomerShow = groomerShowDao.getShowType(groomerRegister.getShowCode());

		//派多格资格证书校验美容会员是否为有效会员(非CKU会员)
		if (Objects.equals(groomerShow.getShowCategory(), "6")) {
			List<String> memberCodeList = new ArrayList<>();
			for (String memberCode : groomerRegister.getMemberCodes()) {
				Member byMemberCode = memberService.getByMemberCode(memberCode);
				if (byMemberCode.getGroomerEndDate() == null || byMemberCode.getGroomerEndDate().getTime() < new Date().getTime()) {
					memberCodeList.add(memberCode);
				}
			}
			if (CollectionUtils.isNotEmpty(memberCodeList)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员：" + memberCodeList + "不是美容会员,无法报名派多格活动!");
			}
		} /*else if (Objects.equals(groomerShow.getShowCategory(), "8")) {伴侣猫只能在OA后台进行报名
			List<String> memberCodeList = new ArrayList<>();
			for (String memberCode : groomerRegister.getMemberCodes()) {
				Member byMemberCode = memberService.getByMemberCode(memberCode);
				if (byMemberCode.getGroomerEndDate() == null || byMemberCode.getGroomerEndDate().getTime() < new Date().getTime()) {
					memberCodeList.add(memberCode);
				}
			}
			if (CollectionUtils.isNotEmpty(memberCodeList)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员：" + memberCodeList + "不是美容会员,无法报名派多格活动!");
			}
			List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao
					.batchFindCertificatePayList(groomerRegister.getMemberCodes(), groomerRegister.getShowLevel(), "8");

		}*/
		for (String memberCode : groomerRegister.getMemberCodes()) {
			//构建报名信息
			Member member = memberService.getByMemberCode(memberCode);
			groomerRegister.setMemberCode(memberCode);
			groomerRegister.setMobile(member.getMobile());
			groomerRegister.setGender(member.getGender());
			groomerRegister.setName(member.getName());
			groomerRegister.setAvatar(member.getAvatar());
			//参数校验
			validateBusiness(groomerRegister, groomerShow, "org");
			//保存报名信息
			saveRegisterInfo(groomerRegister, groomerShow);
			//发送提醒短信和通知
			sendRemindInfo(groomerRegister, groomerShow, false, true);
		}
	}

	/**
	 * 学校报名
	 * @author yuanshuai
	 * @date 2021/12/23 18:48
	 */
	@Transactional(readOnly = false)
	public void mobileSaveBySchool(GroomerRegister groomerRegister) {
		GroomerShow groomerShow = groomerShowDao.getShowType(groomerRegister.getShowCode());
		validateBusiness(groomerRegister, groomerShow, "org");
		saveRegisterInfo(groomerRegister, groomerShow);
		memberService.synImage(groomerRegister.getMemberCode(), groomerRegister.getAvatar());
		//发送提醒短信和通知
		sendRemindInfo(groomerRegister, groomerShow, false, true);
	}

	/**
	 * 后台报名
	 * @author yuanshuai
	 * @date 2021/12/23 18:48
	 */
	@Transactional(readOnly = false)
	public void mobileSave(GroomerRegister groomerRegister) {
		GroomerShow groomerShow = groomerShowDao.getShowType(groomerRegister.getShowCode());
		validateBusiness(groomerRegister, groomerShow, "oa");
		saveRegisterInfo(groomerRegister, groomerShow);
		//发送提醒短信和通知
		sendRemindInfo(groomerRegister, groomerShow,true, true);
	}

	private void saveRegisterInfo(GroomerRegister groomerRegister, GroomerShow groomerShow) {
		groomerRegister.preInsert();
		// 生成报名序号
		groomerRegister.setRegisterCode(SysCodeUtil.getGroomActivitySignCode("BM"));
		//获取金额和收费项
		PaymentChargingItem item = buildItemAndPrice(groomerRegister, groomerShow);
		groomerRegister.setPaymentChargingItemId(item.getId());
		groomerRegister.setFee(item.getPrice());
		// 初始化参数
		groomerRegister.setLeaveCancel("0");
		groomerRegister.setShowLeave("0");
		groomerRegister.setGrade(null);
		groomerRegister.setReviewState("0");
		groomerRegister.setProccessState("0");
		groomerRegister.setPaymentState("1");
		groomerRegister.setEligibility(Boolean.TRUE);
		//保存报名信息
		dao.insert(groomerRegister);
	}

	/**
	 * 发送提醒短信和通知
	 *
	 * @author yuanshuai
	 * @date 2021/12/23 17:13
	 */
	private void sendRemindInfo(GroomerRegister groomerRegister, GroomerShow show, boolean payInfo, boolean applyInfo) {
		Date date = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年M月d日 H时:m分钟");
		//此消息已取消
		if (payInfo) {
			remindService.addRemind(
					"您已于" + simpleDateFormat.format(date) + "报名了" + show.getShowName()
							+ "，请务必于当日24时前完成缴费和证件照片提交，过期报名无效。", groomerRegister.getMemberCode());
		}
		if (applyInfo) {
			remindService.addMemberRemind("您已于" + simpleDateFormat.format(date) + "报名了"
					+ show.getShowName() + "。", groomerRegister.getMemberCode());
		}
	}

	/**
	 * 通过报名和赛事信息获取收费项
	 *
	 * @author yuanshuai
	 * @date 2021/12/23 17:10
	 */
	private PaymentChargingItem buildItemAndPrice(GroomerRegister groomerRegister, GroomerShow show) {
		String shortName = null;
		String showPrice = null;

		if ("1".equals(show.getShowCategory())) {
			if ("exam".equals(show.getShowType())) {
				// 考试
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_EXAM;
				String showLevel = groomerRegister.getShowLevel();
				if ("MASTER".equals(showLevel)) {
					showPrice = GROOMER_MASTER;
				} else if (!"none".equals(showLevel)) {
					showPrice = GROOMER_ABC;
				}
			} else if ("cathedra".equals(show.getShowType())) {
				// 讲座
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_MATCH;
			} else {
				// 比赛
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_MATCHS;
			}
		} else if ("2".equals(show.getShowCategory())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_INTER;
		} else if ("3".equals(show.getShowCategory())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_PET;
		} else if ("4".equals(show.getShowCategory())) {
			if ("exam".equals(show.getShowType())) {
				// 考试
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_EXAM;
			} else if ("match".equals(show.getShowType())) {
				//比赛
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MATCH;
			}
		} else if ("6".equals(show.getShowCategory())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_PET;
		} else if ("7".equals(show.getShowCategory())) {
			shortName = GROOMER_REGISTER_FCI_FEE;
		} else if ("8".equals(show.getShowCategory())) { //伴侣猫洗护资格认证
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MATCH;
			String showLevel = groomerRegister.getShowLevel();
			if ("MASTER".equals(showLevel)) {
				showPrice = GROOMER_CAT_NURSE_MASTER;
			} else if (!"none".equals(showLevel)) {
				showPrice = GROOMER_CAT_NURSE_PRIMARY_LEVEL;
			}
		}
		if (StringUtils.isBlank(shortName)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "报名信息有误，请重试");
		}
		//获取收费项
		PaymentChargingItem item = paymentChargingItemService.getByShortName(shortName);
		//设置收费项和金额
		item.setPrice(StringUtils.isBlank(showPrice) ? show.getFee() : showPrice);
		return item;
	}

	/**
	 * 电话报名tt
	 *
	 * @Author chaixueteng
	 * @2016年7月14日下午5:43:04
	 */
	@Transactional(readOnly = false)
	public void mobileTTSave(GroomerRegister groomerRegister) {
		// 重复报名校验
		GroomerRegister example = new GroomerRegister();
		example.setMemberCode(groomerRegister.getMemberCode());
		example.setShowCode(groomerRegister.getShowCode());
		if (dao.findList(example).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"会员" + groomerRegister.getMemberCode() + "已报名活动" + groomerRegister.getShowCode());
		}
		groomerRegister.preInsert();
		String teamMemberCode = groomerRegister.getTeamMemberCode();
		String memberCode = groomerRegister.getMemberCode();
		Member member = memberService.getByMemberCode(memberCode);
		String[] split = teamMemberCode.split(",");
		for (int i = 0; i < split.length; i++) {
			Member je = memberService.getByMemberCode(split[i]);
			if (!MemberUtil.isActiveMember(je)) {
				throw new ZAException(-1, je + "此会员无效！");
			}
		}
		// 生成报名序号
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "队长会员无效！");
		}
		String registerCode = SysCodeUtil.getGroomActivitySignCode("BM");
		String showCode = groomerRegister.getShowCode();
		groomerRegister.setPaymentChargingItemId("41");
		groomerRegister.setRegisterCode(registerCode);
		// 设置默认值
		groomerRegister.setLeaveCancel("0");
		groomerRegister.setShowLeave("0");
		groomerRegister.setGrade(null);
		groomerRegister.setReviewState("0");
		groomerRegister.setProccessState("0");
		groomerRegister.setPaymentState("1");
		GroomerShow show = groomerShowDao.getShowType(showCode);
		//派多格资格证书校验美容会员是否为有效会员(非CKU会员)
		if (Objects.equals(show.getShowCategory(), "6")) {
			Member byMemberCode = memberService.getByMemberCode(groomerRegister.getMemberCode());
			if (byMemberCode.getGroomerEndDate() == null || byMemberCode.getGroomerEndDate().getTime() < new Date().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有有效的美容会员才可以报名派多格活动!");
			}
		}
		dao.insert(groomerRegister);
		Date date = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年M月d日 H时:m分钟");
		remindService.addRemind(
				"您已于" + simpleDateFormat.format(date) + "报名了" + show.getShowName() + "，请务必于当日24时前完成缴费和证件照片提交，过期报名无效。",
				groomerRegister.getMemberCode());
		remindService.addMemberRemind("您已于" + simpleDateFormat.format(date) + "报名了" + show.getShowName() + "。",
				groomerRegister.getMemberCode());
		String[] split2 = teamMemberCode.split(",");
		for (int i = 0; i < split2.length; i++) {
			Member je = memberService.getByMemberCode(split2[i]);
			remindService.addMemberRemind("您已于" + simpleDateFormat.format(date) + "报名了" + show.getShowName() + "。",
					je.getMemberCode());
		}
	}

	/**
	 * 根据会员号查询信息(oa端 不校验有效无效)
	 *
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月19日下午5:51:10
	 */
	public Map<String, Object> getMemberMessage(String memberCode, String showCode) throws ZAException {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		Member member = memberService.getByMemberCode(memberCode);
		GroomerShow show = groomerShowDao.getShowType(showCode);
		logger.info("111111111 show : {}", JSONObjectUtils.toJsonString(show));
		String showType = show.getShowType();
		String showLevel = show.getTestLevel();
		String showCategory = show.getShowCategory();

		Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.DATE, -1); // 日期减1
		Date date = ca.getTime();
		Date groomerEndDate = member.getGroomerEndDate();
		if (showCategory.equals("1")) {
			if ("exam".equals(showType)) {// 考试
				boolean b = false;
				String level = autoSelectLevel(member);
				String[] str = showLevel.split(",");
				for (String string : str) {
					if (string.equals(level)) {
						map.put("showLevel", level);
						b = true;
						/*
						 * if(!"C".equals(level.trim())){ String groomerType = member.getGroomerType();
						 * if (StringUtils.isBlank(groomerType)||!"formal".equals(groomerType)) { throw
						 * new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您不是美容师正式会员!"); } }
						 */
					}
				}
				if (!b) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师级别不符合活动所需的级别!");
				}
			} else if ("match".equals(showType)) {// 比赛
				GroomerQualificationCertificate gqc = groomerQualificationCertificateService.getLevel(memberCode);
				String level;
				if (gqc == null) {
					level = "none";
				} else {
					level = gqc.getLevelEn();
				}
				List<String> strings = Arrays.asList(showLevel.split(","));
				if (strings.contains(level)) {
					map.put("showLevel", level);
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "级别不符!");
				}
			} else {// 公开课 讲座
				map.put("showLevel", "none");
			}
		} else if ("7".equals(showCategory)) {//Fci活动
			if ("match".equals(showType)) {// 大赛
				boolean b = false;
				String level = autoFciSelectLevel(member);
				logger.info("Fci活动报名选择级别 level : {}", level);
				String[] str = showLevel.split(",");
				logger.info("Fci活动报名选择级别 str : {}", JSONObjectUtils.toJsonString(str));
				for (String string : str) {
					if (string.equals(level)) {
						map.put("showLevel", level);
						b = true;
						if (!"C".equals(level.trim())) {
							String groomerType = member.getGroomerType();
							if (StringUtils.isBlank(groomerType) || !"formal".equals(groomerType)) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您不是美容师正式会员!");
							}
							if (groomerEndDate == null || groomerEndDate.getTime() < date.getTime()) {
								throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师会员已过期，请先续费!");
							}
						}
					}
				}
				if (!b) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师级别不符合活动所需的级别!");
				}
			}
		}
		String schoolNameCn = dao.getSchoolNameCn(memberCode);
		map.put("schoolNameCn", schoolNameCn);
		return map;
	}

	/**
	 * 根据会员号查询信息(会员中心 带会员有效无效校验)
	 *
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月19日下午5:51:10
	 */
	public Map<String, Object> getMemberMessageByWeb(String memberCode, String showCode) throws ZAException {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		Member member = memberService.getByMemberCode(memberCode);
		GroomerShow show = groomerShowDao.getShowType(showCode);
		String showType = show.getShowType();
		String showLevel = show.getTestLevel();
		if (StringUtils.isBlank(showCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动信息异常,赛事编号为空！");
		}
		String[] codeType = showCode.split("-");
		map.put("isShowModel", false);
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(-1, "会员无效！");
		} else {
			map.put("showCategory", show.getShowCategory());

			Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
			ca.setTime(new Date()); // 设置时间为当前时间
			ca.add(Calendar.DATE, -1); // 日期减1
			Date date = ca.getTime();
			Date groomerEndDate = member.getGroomerEndDate();

			if ("1".equals(show.getShowCategory())) {
				if ("exam".equals(showType)) {// 考试
					boolean b = false;
					String level = autoSelectLevel(member);
					String[] str = showLevel.split(",");
					for (String string : str) {
						if (string.equals(level)) {
							map.put("showLevel", level);
							b = true;
							if (!"C".equals(level.trim())) {
								String groomerType = member.getGroomerType();
								if (StringUtils.isBlank(groomerType) || !"formal".equals(groomerType)) {
									throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您不是美容师正式会员!");
								}
								if (groomerEndDate == null || groomerEndDate.getTime() < date.getTime()) {
									throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师会员已过期，请先续费!");
								}
							}
						}
					}
					if (!b) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师级别不符合活动所需的级别!");
					}
				} else if ("match".equals(showType)) {// 比赛
					GroomerQualificationCertificate gqc = groomerQualificationCertificateService.getLevel(memberCode);
					String level;
					if (gqc == null) {
						level = "none";
					} else {
						level = gqc.getLevelEn();
					}
					List<String> strings = Arrays.asList(showLevel.split(","));
					if (strings.contains(level)) {
						map.put("showLevel", level);
					} else {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "级别不符!");
					}
				} else {// 公开课 讲座
					map.put("showLevel", "none");
				}
			}
			// 国际宠物美容师 宠物造型师&国际宠物美容师不允许报名团体赛、讲座
			if (!"1".equals(show.getShowCategory())) {
				if ("team".equals(showType)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "团体赛暂不支持报名!");
				}
				if ("cathedra".equals(showType)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "讲座暂不支持报名!");
				}
			}
			if ("2".equals(show.getShowCategory())) {
				map.put("showTypeSpare", new String[]{"国际宠物美容师"});
				map.put("showLevel", "国际宠物美容师");
				map.put("isShowModel", true);
			} else if ("3".equals(show.getShowCategory())) {
				String[] testLevel = show.getTestLevel().split(",");
				if (testLevel.length == 2) {
					map.put("showTypeSpare", new String[]{"国际宠物美容师", "宠物造型师&国际宠物美容师"});
					map.put("showLevel", "宠物造型师&国际宠物美容师");
					map.put("isShowModel", true);
				} else {
					if (show.getTestLevel().contains("宠物造型师")) {
						map.put("showTypeSpare", new String[]{"宠物造型师&国际宠物美容师"});
						map.put("showLevel", "宠物造型师&国际宠物美容师");
					} else {
						map.put("showTypeSpare", new String[]{"国际宠物美容师"});
						map.put("showLevel", "国际宠物美容师");
						map.put("isShowModel", true);
					}
				}
			} else if ("4".equals(show.getShowCategory())) {
				if (!(member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date())
						|| member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date()))) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的会员已过期，请先续费!");
				}
				map.put("showLevel", show.getTestLevel());
			} else if ("7".equals(show.getShowCategory())) {//Fci活动
				if ("match".equals(showType)) {// 大赛
					boolean b = false;
					String level = autoFciSelectLevel(member);
					String[] str = showLevel.split(",");
					for (String string : str) {
						if (string.equals(level)) {
							map.put("showLevel", level);
							b = true;
							if (!"C".equals(level.trim())) {
								String groomerType = member.getGroomerType();
								if (StringUtils.isBlank(groomerType) || !"formal".equals(groomerType)) {
									throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您不是美容师正式会员!");
								}
								if (groomerEndDate == null || groomerEndDate.getTime() < date.getTime()) {
									throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师会员已过期，请先续费!");
								}
							}
						}
					}
					if (!b) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的美容师级别不符合活动所需的级别!");
					}
				}
			} else if ("8".equals(show.getShowCategory())) {
				map.put("showLevel", show.getTestLevel());
			}
		}

		String schoolNameCn = dao.getSchoolNameCn(memberCode);
		map.put("schoolNameCn", schoolNameCn);
		return map;

	}

	/**
	 * 保存成绩,生成资格证书
	 *
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月22日下午4:52:07 boolean flag :true 成绩录入 false 录入笔试成绩
	 */
	@Transactional(readOnly = false)
	public void saveGrade(GroomerRegister gr, boolean flag) throws ZAException {
		logger.info("GroomerRegisterService.saveGrade param : {}", JSONObjectUtils.toJsonString(gr));
		String showCode = gr.getShowCode();
		String referee = gr.getReferee();
		GroomerShow show = groomerShowDao.getShowType(showCode);
		Date takeCertificateDate = gr.getTakeCertificateDate();
		String grade = gr.getGrade();
		String gradeWrite = gr.getGradeWrite();
		String id = gr.getId();
		String[] str = showCode.split("-");
		if (grade != null) {
			if (flag == true) {
				if ((Objects.equals(show.getShowType(), "exam") && str[2].trim().equals("ZG"))) {
					if (Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.PASSED.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.EXCELLENT.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.EXTREMELY_EXCELLENT.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.BEST_OVERALL.getCode())) {
						if (StringUtils.isBlank(gr.getGradeWrite())) {
							gr.setGradeWrite(GradeWrittenEnum.TO_BE_EXAM.code());
						}
					} else {
						gr.setGradeWrite(GradeWrittenEnum.FAIL.code());}
				} else if ((Objects.equals(show.getShowType(), "match") &&
						(str[2].trim().equals("JY") || str[2].trim().equals("ZHRY")
								|| str[2].trim().equals("CQ") || str[2].trim().equals("CQTZ")))) {
					//大赛级别的后缀位 精英 中华荣耀 传奇的赛事编号也可以通过考试
					if (Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.PASSED.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.BE_PROMOTED.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.FIRST.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.SECOND.getCode())
							|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.THIRD.getCode())) {
						if (StringUtils.isBlank(gr.getGradeWrite())) {
							gr.setGradeWrite(GradeWrittenEnum.TO_BE_EXAM.code());
						}
					} else {
						gr.setGradeWrite(GradeWrittenEnum.FAIL.code());}
				}
				dao.inputGrade(gr);
				if (Objects.equals(show.getShowCategory(), "6")
						&& Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.PASSED.getCode())) {
					this.groomerQualificationCertificateApplyForPDG(gr, show);
				}
				if (Objects.equals(show.getShowCategory(), "7")) {
					this.fciGroomerQualificationCertificateApplyForFci(gr, show);
				}
			}
			// 成绩、笔事成绩必须通过，才可发证书
			if (StringUtils.isNotBlank(gradeWrite) && "1".equals(gradeWrite)) {
				// 资格认证考试
				if ("1".equals(show.getShowCategory())) {
					if (str[2].trim().equals("ZG")) {
						// 考试通过才会有资格证书
						this.groomerQualificationCertificateApplyForZG(gr, show);
					} else if (str[2].trim().equals("JY")) {// 精英 第一二三 晋级(入围) 都是A级资格证书
						if ("8".equals(grade) || "9".equals(grade) || "10".equals(grade) || "2".equals(grade)
								|| "11".equals(grade)) {
							GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
							gqc.setCertificateType("1");
							gqc.preInsert();
							gqc.setCertificateCode(null);
							gqc.setRegisterId(id);
							gqc.setMemberCode(gr.getMemberCode());
							gqc.setCorsage(null);
							gqc.setPrintState("0");
							gqc.setReviewState("0");
							gqc.setPaymentState("1");
							gqc.setProccessState("0");
							gqc.setTakeCertificateDate(takeCertificateDate);
							gqc.setReviewer(referee);
							gqc.setLevelEn("A");
							gqc.setLevelCn("A");
							gqc.setIsFree("1");
							gqc.setCertificateSource("1");
							if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "1")
									.size() <= 0) {
								groomerQualificationCertificateService.saveCertificate(gqc);
							}
							groomerQualificationCertificate(gr.getMemberCode(), gqc, id);
							remindService.addMemberRemind(
									"恭喜您通过" + show.getShowName()
											+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
									gr.getMemberCode());
							// 领取美容师资格证书并生成国际宠物美容师证书
							/*save(id, gr, takeCertificateDate, referee);*/
						} else if ("0".equals(grade) || "1".equals(grade)) { // 存在同级别证书 则作废第一次证书
							List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
									.eqCertificate(gr.getMemberCode(), "A", "1");
							if (list.size() > 0) {// 存在同级别证书 则作废
								for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
									groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
									groomerQualificationCertificateDao
											.deleteCertificate(groomerQualificationCertificate);
								}
							}
						}
					} else if (str[2].trim().equals("CQ") || str[2].trim().equals("CQTZ")) {
						if ("8".equals(grade) || "9".equals(grade) || "10".equals(grade) || "2".equals(grade)
								|| "11".equals(grade)) {
							String level = gr.getShowLevel();
							if (!"A".equals(level.trim())) {
								GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
								gqc.setCertificateType("1");
								gqc.preInsert();
								gqc.setCertificateCode(null);
								gqc.setRegisterId(id);
								gqc.setMemberCode(gr.getMemberCode());
								gqc.setCorsage(null);
								gqc.setPrintState("0");
								gqc.setReviewState("0");
								gqc.setPaymentState("1");
								gqc.setProccessState("0");
								gqc.setTakeCertificateDate(takeCertificateDate);
								gqc.setReviewer(referee);
								gqc.setIsFree("1");
								if ("B".equals(level.trim())) {
									gqc.setLevelEn("A");
									gqc.setLevelCn("A");
								} else if ("C".equals(level.trim())) {
									gqc.setLevelEn("B");
									gqc.setLevelCn("B");
								}
								gqc.setCertificateSource("1");
								groomerQualificationCertificateService.saveCertificate(gqc);
								groomerQualificationCertificate(gr.getMemberCode(), gqc, id);
								remindService.addMemberRemind(
										"恭喜您通过" + show.getShowName()
												+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
										gr.getMemberCode());
								// 领取美容师资格证书并生成国际宠物美容师证书
								/*save(id, gr, takeCertificateDate, referee);*/
							}
						} else if ("0".equals(grade) || "1".equals(grade)) {
							String level = gr.getShowLevel();
							if (!"A".equals(level.trim())) {
								if ("B".equals(level.trim())) {
									List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
											.eqCertificate(gr.getMemberCode(), "A", "1");
									if (list.size() > 0) {// 存在同级别证书 则作废
										for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
											groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
											groomerQualificationCertificateDao
													.deleteCertificate(groomerQualificationCertificate);
										}
									}
								}
							} else if ("C".equals(level.trim())) {
								List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
										.eqCertificate(gr.getMemberCode(), "B", "1");
								if (list.size() > 0) {// 存在同级别证书 则作废
									for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
										groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
										groomerQualificationCertificateDao
												.deleteCertificate(groomerQualificationCertificate);
									}
								}
							}
						}
					} else if (str[2].trim().equals("ZHRY")) {
						// 考试通过才会有资格证书
						this.groomerQualificationCertificateApplyForZHRY(gr, show);
					}
				} else if("4".equals(show.getShowCategory())) {
					// 洗护师
					if(!"0".equals(grade) && !"1".equals(grade)) {
						GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
						gqc.setCertificateType("4");
						gqc.setPaper("0");
						gqc.preInsert();
						gqc.setCertificateCode(null);
						gqc.setRegisterId(id);
						gqc.setMemberCode(gr.getMemberCode());
						gqc.setCorsage(null);
						gqc.setPrintState("0");
						gqc.setReviewState("0");
						gqc.setPaymentState("1");
						gqc.setProccessState("0");
						gqc.setTakeCertificateDate(takeCertificateDate);
						gqc.setReviewer(referee);
						gqc.setIsFree("1");
						String level = gr.getShowLevel();
						gqc.setLevelEn(level);
						Dict dict =  DictUtils.getDict(level, "groomer_nurse_level", null);
						gqc.setLevelCn(dict.getValue());
						gqc.setCertificateSource("1");
						if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "4")
								.size() <= 0) {
							groomerQualificationCertificateService.saveCertificate(gqc);
						}
						groomerQualificationCertificate(gr.getMemberCode(), gqc, id);
						
						remindService.addRemind(
								"恭喜您通过" + show.getShowName()
										+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"恭喜您通过" + show.getShowName()
										+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());
					}
					if("0".equals(grade)) {
						remindService.addRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
					}
					
				} else if("6".equals(show.getShowCategory())) {
					//派多格就算录入笔试成绩也什么都不做
				} else if("7".equals(show.getShowCategory())) {
					//FCI活动就算录入笔试成绩也什么都不做
				}  else if("8".equals(show.getShowCategory())) {
					// 伴侣猫洗护师
					if(!"0".equals(grade) && !"1".equals(grade)) {
						GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
						gqc.setCertificateType("8");
						gqc.setPaper("0");
						gqc.preInsert();
						gqc.setCertificateCode(null);
						gqc.setRegisterId(id);
						gqc.setMemberCode(gr.getMemberCode());
						gqc.setCorsage(null);
						gqc.setPrintState("0");
						gqc.setReviewState("0");
						gqc.setPaymentState("1");
						gqc.setProccessState("0");
						gqc.setTakeCertificateDate(takeCertificateDate);
						gqc.setReviewer(referee);
						gqc.setIsFree("1");
						String level = gr.getShowLevel();
						gqc.setLevelEn(level);
						Dict dict =  DictUtils.getDict(level, "groomer_cat_nurse_level", null);
						gqc.setLevelCn(dict.getLabel());
						gqc.setCertificateSource("1");
						if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "8")
								.size() <= 0) {
							groomerQualificationCertificateService.saveCertificate(gqc);
						}
						//groomerQualificationCertificate(gr.getMemberCode(), gqc, id);

						remindService.addRemind(
								"恭喜您通过" + show.getShowName()
										+ "，获得申领伴侣猫洗护资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"恭喜您通过" + show.getShowName()
										+ "，获得申领伴侣猫洗护资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());
					}
					if("0".equals(grade)) {
						remindService.addRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
					}

				} else {
					if (!"0".equals(grade) && !"1".equals(grade)) {
						if ("宠物造型师&国际宠物美容师".equals(gr.getShowLevel()) && !gr.getShowDogBreed().contains("模型")) {
							GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
							gqc.setCertificateType("3");
							gqc.preInsert();
							gqc.setCertificateCode(null);
							gqc.setRegisterId(id);
							gqc.setMemberCode(gr.getMemberCode());
							gqc.setCorsage(null);
							gqc.setPrintState("0");
							gqc.setReviewState("0");
							gqc.setPaymentState("1");
							gqc.setProccessState("0");
							gqc.setTakeCertificateDate(takeCertificateDate);
							gqc.setReviewer(referee);
							String level = gr.getShowLevel();
							gqc.setIsFree("1");
							gqc.setCertificateSource("1");
							if ("13".equals(grade)) {
								gqc.setLevelEn("金牌宠物造型师");
								gqc.setLevelCn("金牌宠物造型师");
							} else {
								gqc.setLevelEn("宠物造型师");
								gqc.setLevelCn("宠物造型师");
							}
							// 判断是否已经发放，已发放过同类型不在发放
							if (groomerQualificationCertificateDao
									.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "3").size() <= 0) {
								groomerQualificationCertificateService.saveCertificate(gqc);
							}
						}
						/*GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
						gqc.setCertificateType("2");
						gqc.preInsert();
						gqc.setCertificateCode(null);
						gqc.setRegisterId(id);
						gqc.setMemberCode(gr.getMemberCode());
						gqc.setCorsage(null);
						gqc.setPrintState("0");
						gqc.setReviewState("0");
						gqc.setPaymentState("1");
						gqc.setProccessState("0");
						gqc.setTakeCertificateDate(takeCertificateDate);
						gqc.setReviewer(referee);
						gqc.setIsFree("1");
						String level = gr.getShowLevel();
						gqc.setLevelEn("国际宠物美容师");
						gqc.setLevelCn("国际宠物美容师");
						gqc.setCertificateSource("1");
						// 判断是否已经发放，已发放过同类型不在发放
						if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn())
								.size() <= 0) {
							groomerQualificationCertificateService.saveCertificate(gqc);
						}

						// 获取申领CKU美容资格证书的资质，并查询该会员同级别考试（条件：上一次考试成绩未通过，笔试成绩通过，同级别会员）
						// groomerQualificationCertificate(gr.getMemberCode(), gqc, id);
						remindService.addRemind(
								"恭喜您通过" + show.getShowName() + "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"恭喜您通过" + show.getShowName() + "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
								gr.getMemberCode());*/
					} else {// 未通过
						remindService.addRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
						remindService.addMemberRemind(
								"感谢您此次参加" + show.getShowName()
										+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
								gr.getMemberCode());
						List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
								.eqCertificate(gr.getMemberCode(), gr.getShowLevel(), show.getShowCategory());
						if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废
							for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
								groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
								groomerQualificationCertificateDao.deleteCertificate(groomerQualificationCertificate);
							}
						}
					}
				}
			}
		}
	}

	public void save(String id, GroomerRegister gr, Date takeCertificateDate, String referee) {
		// 判断是否已经发放，已发放过同类型不在发放
		if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), "国际高级宠物美容师", "2").size() <= 0) {
			GroomerQualificationCertificate gqc1 = new GroomerQualificationCertificate();
			gqc1.setCertificateType("2");
			gqc1.preInsert();
			gqc1.setCertificateCode(null);
			gqc1.setRegisterId(id);
			gqc1.setMemberCode(gr.getMemberCode());
			gqc1.setCorsage(null);
			gqc1.setPrintState("0");
			gqc1.setReviewState("0");
			gqc1.setPaymentState("1");
			gqc1.setProccessState("0");
			gqc1.setTakeCertificateDate(takeCertificateDate);
			gqc1.setReviewer(referee);
			gqc1.setLevelEn("国际高级宠物美容师");
			gqc1.setLevelCn("国际高级宠物美容师");
			gqc1.setIsFree("0");
			gqc1.setCertificateSource("1");
			groomerQualificationCertificateService.saveCertificate(gqc1);
		}

	}

	// 获取申领CKU美容资格证书的资质，并查询该会员同级别考试（条件：上一次考试成绩未通过，笔试成绩通过，同级别会员）
	public void groomerQualificationCertificate(String memberCode, GroomerQualificationCertificate gqc,
												String registerId) {
		GroomerRegister groomerRegisterWhere = new GroomerRegister();
		groomerRegisterWhere.setMemberCode(memberCode);
		groomerRegisterWhere.setShowLevel(gqc.getLevelEn());
		List<GroomerRegister> list = findList(groomerRegisterWhere);
		for (GroomerRegister li : list) {
			if (StringUtils.isNotBlank(li.getGrade()) && li.getGrade().equals("0")
					&& StringUtils.isNotBlank(li.getGradeWrite()) && li.getGradeWrite().equals("1")) {
				GroomerRegister groomerRegister = get(registerId);
				if (groomerRegister != null) {
					groomerRegister.setGradeWrite("1");
					super.save(groomerRegister);
				}
			}
		}
	}

	/**
	 * 获取会员的参赛级别
	 *
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月25日下午3:49:27
	 */
	public String autoSelectLevel(Member member) throws ZAException {
		String memberCode = member.getMemberCode();
		// Date birthday = member.getBirthday();
		GroomerQualificationCertificate gqc = groomerQualificationCertificateService.getLevel(memberCode);
		if (gqc == null) {
			return "C";
		} else {
			String level = gqc.getLevelEn();
			if ("国际宠物美容师".equals(level) || "国际高级宠物美容师".equals(level) || "宠物造型师".equals(level)) {
				return "C";
			}
			// Date issueDate = gqc.getIssueDate();
			// Calendar curr = Calendar.getInstance();
			// 实现报名自动选择美容师上一级的赛事
			if (level.equals("C")) {// C--B
				/*
				 * if (b) { curr.set(Calendar.MONTH,curr.get(Calendar.MONTH)-6); Date
				 * date=curr.getTime(); if (issueDate.after(date)) { throw new
				 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "持有证书时间不足半年!"); } }
				 */
				return "B";
			} else if (level.equals("B")) {// B-->A
				/*
				 * if (b) { curr.set(Calendar.YEAR,curr.get(Calendar.YEAR)-1); Date
				 * date=curr.getTime(); if (issueDate.after(date)) { throw nesw
				 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "持有证书时间不足一年!"); } }
				 */
				return "A";
			} else if (level.equals("A")) {// A-->教师
				/*
				 * if (b) {//会员中心校验五年 oa不校验 int age = AgeUtil.getAge(birthday); if (age<30) {
				 * throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年龄不满30周岁!"); }
				 * curr.set(Calendar.YEAR,curr.get(Calendar.YEAR)-5); Date date=curr.getTime();
				 * if (issueDate.after(date)) { throw new
				 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "持有证书时间不足5年!"); } }
				 */
				return "MASTER";
			}
			return level;
		}
	}

	/**
	 * 成绩导入
	 *
	 * @throws Exception
	 * @Author chaixueteng
	 * @2016年7月26日上午10:32:18
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importShows(MultipartFile file) throws Exception {
		try {
			ImportExcel ei = new ImportExcel(file, 0, 0);
			List<GroomerRegister> list = ei.getDataList(GroomerRegister.class);
			for (GroomerRegister gr : list) {
				if (StringUtils.isBlank(gr.getId().trim())) {
					continue;
				}
				GroomerRegister groomerRegister = super.get(gr.getId().trim());
				if (!gr.getMemberCode().equals(groomerRegister.getMemberCode())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id与会员号不对应!请仔细核对 -->" + gr.getMemberCode());
				}
				String grade = gr.getGrade().trim();
				gr.setGrade(DictUtils.getDictValue(grade, "Grade", null));
				String refereeNameEn = showRefereeService.findRefereeNameEn(gr.getReferee().trim());
				if (StringUtils.isBlank(refereeNameEn)) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该" + gr.getReferee() +"审查员不存在,请检查后再试！");
				}
				gr.setReferee(refereeNameEn);
				// 处理活动类别
				gr.setShowCategory(DictUtils.getDictValue(gr.getShowCategory(), "groomer_show_category", ""));
				GroomerRegister groomerRegisterResult = this.get(gr.getId());
				if (Objects.isNull(groomerRegisterResult)) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该" + gr.getId() +"id不存在，请检查！");
				}
				BeanUtil.merge(groomerRegisterResult, gr);
				saveGrade(groomerRegisterResult, true);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception(e);
		}

	}

	/**
	 * 赛事退费
	 *
	 * @Author chaixueteng
	 * @2016年8月2日下午4:50:39
	 */
	@Transactional(readOnly = false)
	public void updateLeaveFlag(GroomerRegister groomerRegister) {
		groomerRegister.preUpdate();
		dao.updateLeaveFlag(groomerRegister);

	}

	/**
	 * 复选框回显
	 *
	 * @Author chaixueteng
	 * @2016年8月2日下午4:51:15
	 */
	public String getRegisterMessage(String id) {
		GroomerRegister gr = dao.get(id);
		String showDogBreed = gr.getShowDogBreed();
		String[] dog = showDogBreed.split(",");
		return JSONArray.fromObject(dog).toString();
	}

	/**
	 * 报名信息导出
	 *
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年8月4日下午2:03:14
	 */
	public void export(GroomerRegister groomerRegister, HttpServletResponse response) throws IOException {
		List<GroomerRegister> grList = dao.getRegisterList(groomerRegister);
		for (GroomerRegister gr : grList) {
			// gr.setGender("male".equals(gr.getGender())?"男":"女");
			// gr.setPaymentState("2".equals(gr.getPaymentState())?"已缴费":"未缴费");
			// gr.setDelFlag("0".equals(gr.getDelFlag())?"未删":"已删");
			gr.setMobile(gr.getMember() == null ? "" : gr.getMember().getMobile());
			gr.setShowDogBreed(
					StringUtils.isEmpty(gr.getShowDogBreed()) ? "" : gr.getShowDogBreed().replaceAll(",", ""));
			gr.setSchoolNameCn(
					StringUtils.isEmpty(gr.getSchoolNameCn()) ? "" : gr.getSchoolNameCn().replaceAll(",", ""));
			if("4".equals(gr.getShowCategory())) {
				gr.setShowLevel(DictUtils.getDictLabel(gr.getShowLevel(), "groomer_nurse_level", ""));
			} else if ("8".equals(gr.getShowCategory())) {
				gr.setShowLevel(DictUtils.getDictLabel(gr.getShowLevel(), "groomer_cat_nurse_level", ""));
			} else {
				gr.setShowLevel(DictUtils.getDictLabel(gr.getShowLevel(), "groomer_test_level", ""));
			}
			
			gr.setGrade(DictUtils.getDictLabel(gr.getGrade(), "Grade", ""));
			gr.setShowCategory(DictUtils.getDictLabel(gr.getShowCategory(), "groomer_show_category", ""));
		}
		new ExportExcel("", GroomerRegister.class, 1).setDataList(grList).write(response, "报名信息表.xlsx").dispose();
	}

	/**
	 * 保存证件照
	 *
	 * @Author chaixueteng
	 * @2016年8月17日下午1:58:51
	 */
	@Transactional(readOnly = false)
	public void saveImage(GroomerRegister groomerRegister) throws Exception {
		try {
			String memberCode = groomerRegister.getMemberCode();
			String state = groomerRegister.getReviewState();
			String remarks = groomerRegister.getReviewRemarks();
			String avatar = groomerRegister.getMember().getAvatar();// 会员中心照片
			if (StringUtils.isBlank(avatar)) {
				throw new ZAException(-1, "请上传正确的证件照");
			}

			String id = groomerRegister.getId();
			GroomerRegister gr = get(id);
			SysContext sysContext = new SysContext(gr.getPaymentState(), gr.getReviewState(), gr.getProccessState());
			GroomerRegister GR = new GroomerRegister(id);
			GR.setAvatar(avatar);
			if ("1".equals(state)) {
				GR.setReviewState("1");
				GR.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext, "报名证件照", gr.getMemberCode(), "groomer_register", gr.getId(),
						gr.getRunningNumber(), (str) -> {

						});
				// 审核通过 同步会员证件照
				// memberService.synImage(memberCode,avatar);
			} else {
				GR.setReviewState("2");
				GR.setReviewTime(new Date());
				GR.setReviewRemarks(remarks);
				sysContext.confirmFail(sysContext, "报名证件照", remarks, gr.getMemberCode(), "groomer_register", gr.getId(),
						gr.getRunningNumber(), (str) -> {

						});
			}
			dao.saveImage(GR);
			GroomerRegister grt = dao.get(id);
			GroomerShow show = groomerShowDao.getShowType(gr.getShowCode());
			String reviewState = grt.getReviewState();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年M月d日");
			if ("1".equals(reviewState)) {
				remindService.addRemind("您参加的" + show.getShowName().trim() + "报名已成功，活动举办日期"
						+ simpleDateFormat.format(show.getStartTime()) + "，请您提前做好准备。", memberCode);
				remindService.addMemberRemind("您参加的" + show.getShowName().trim() + "报名已成功，活动举办日期"
						+ simpleDateFormat.format(show.getStartTime()) + "，请您提前做好准备。", memberCode);
			} else if ("2".equals(reviewState)) {
				remindService.addRemind("您参加的" + show.getShowName().trim() + "报名审核未通过，未通过原因：" + grt.getReviewRemarks(),
						memberCode);
				remindService.addMemberRemind(
						"您参加的" + show.getShowName().trim() + "报名审核未通过，未通过原因：" + grt.getReviewRemarks(), memberCode);
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 得到参加考试的报名数
	 *
	 * @Author chaixueteng
	 * @2016年8月30日下午6:01:07
	 */
	public int getAuditCount() {
		return dao.getRegisterCount();
	}

	/**
	 * 得到参加比赛的报名数
	 *
	 * @Author chaixueteng
	 * @2016年8月30日下午6:01:07
	 */
	public int getMatchAuditCount() {
		return dao.getRegisterMatchCount();
	}

	/**
	 * 重复报名验证
	 *
	 * @Author chaixueteng
	 * @2016年9月6日下午5:38:11
	 */
	public String registerCheck(String memberCode, String showCode) {
		List<GroomerRegister> list = dao.getByRegister(memberCode, showCode);
		if (list.size() > 0) {
			return "{\"rc\":true}";
		} else {
			return "{\"rc\":false}";
		}
	}

	/**
	 * @description: 美容师活动报名业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月19日 上午10:11:23
	 */
	public void validateBusiness(GroomerRegister po, GroomerShow groomerShow, String source) {
		//校验活动截止
		if (!"oa".equals(source)) {
			String showCode = po.getShowCode();
			GroomerShow show = groomerShowDao.getShowType(showCode);
			Date registerEndTime = show.getRegisterEndTime();
			if (registerEndTime.getTime() <= new Date().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动报名已经截止!");
			}

			//伴侣猫资格证书校验美容会员是否为有效会员(非CKU会员)
			if (Objects.equals(groomerShow.getShowCategory(), "8")) {
				Member byMemberCode = memberService.getByMemberCode(po.getMemberCode());
				/*if (byMemberCode.getGroomerEndDate() == null || byMemberCode.getGroomerEndDate().getTime() < new Date().getTime()) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有有效的美容会员才可以报名伴侣猫洗护活动!");
				}*/
				if (!MemberUtil.isActiveMember(byMemberCode)) {
					throw new ZAException(-1, "会员无效！");
				}
			}
		}
		//派多格资格证书校验美容会员是否为有效会员(非CKU会员)
		if (Objects.equals(groomerShow.getShowCategory(), "6")) {
			Member byMemberCode = memberService.getByMemberCode(po.getMemberCode());
			if (byMemberCode.getGroomerEndDate() == null || byMemberCode.getGroomerEndDate().getTime() < new Date().getTime()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有有效的美容会员才可以报名派多格活动!");
			}
		}


		//已有资格证书校验
		if ("org".equals(source)) {
			if ("1".equals(po.getShowCategory())) {
				List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
						.getByMemberCode(po.getMemberCode());
				for (GroomerQualificationCertificate obj : list) {
					if ("A".equals(obj.getLevelEn()) || "B".equals(obj.getLevelEn()) || "C".equals(obj.getLevelEn())
							|| "MASTER".equals(obj.getLevelEn())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
								"该会员已有美容师资格认证记录，无法报名！");
					}
				}
			}
		}
		if ("8".equals(groomerShow.getShowCategory())) {
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.findCertificatePayList(po.getMemberCode(), po.getShowLevel(), "8");
			logger.info("根据条件查询出的数据是 : {}", JSONObjectUtils.toJsonString(list));
			for (GroomerQualificationCertificate obj : list) {
				if (po.getShowLevel().equals(obj.getLevelEn())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
							"该会员已有该级别的伴侣猫认证记录，无法报名！");
				}
			}
		}
		// 校验重复订单
		GroomerRegister example = new GroomerRegister();
		example.setMemberCode(po.getMemberCode());
		example.setShowCode(po.getShowCode());
		if ("app".equals(source)) {
			example.setReviewStateExclud("3");
		}
		List<GroomerRegister> list = findList(example);
		if (!CollectionUtils.isEmpty(list)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员" + po.getMemberCode() + "已报名活动" + po.getShowCode());
		}
		//购物车未提交记录校验
		List<PaymentCart> cartList = paymentCartDao.findListByBusinessId("1046", po.getMemberCode());
		if(cartList!=null&&cartList.size()>0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车有未提交报名，请优先处理！");
		}
		//校验洗护师犬种信息
		if ("4".equals(groomerShow.getShowCategory())) {
			if (StringUtils.isBlank(po.getShowDogBreed()) && StringUtils.isBlank(po.getShowDogBreedExtra())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "参赛犬种为空，请选择参赛犬种后再提交");
			}
			List<String> currentDogBreedList = StringUtils.isBlank(po.getShowDogBreed()) ? null : Arrays.asList(po.getShowDogBreed().split(","));
			List<String> currentExtraDogBreedList = StringUtils.isBlank(po.getShowDogBreedExtra()) ? null : Arrays.asList(po.getShowDogBreedExtra().split(","));

			//获得犬种信息
			List<GroomerShowBreeds> groomerBreedList = groomerShowBreedsService.findList(GroomerShowBreeds.builder().build());
			// 查询会员取得证书的洗护师报名信息
			List<GroomerRegister> registerList = groomerQualificationCertificateDao.findNurseRegisterList(po.getMemberCode());
			//已经报名过的犬种
			List<String> registerBreedList = null;
			// 将所有报名犬种按逗号分隔组成Set（过滤重复）
			if (!CollectionUtils.isEmpty(registerList)) {
				registerBreedList = registerList.stream()
						.flatMap(r -> Arrays.stream(r.getShowDogBreed().split(",")))
						.distinct()
						.collect(Collectors.toList());
			}

			//计算犬种数量
			//初级
			int maxCount = 1;
			int minCount;
			if ("SENIOR".equals(po.getShowLevel())) {
				//高级
				maxCount = 3;
			} else if ("MATCH".equals(po.getShowLevel())) {
				//赛季
				maxCount = 5;
			}
			if (!CollectionUtils.isEmpty(registerBreedList)) {
				List<String> finalRegisterBreedList = registerBreedList;
				long currentLevelCount = groomerBreedList.stream()
						.filter(groomerShowBreeds -> finalRegisterBreedList.stream()
								.anyMatch(s -> s.equals(groomerShowBreeds.getBreedName())))
						.filter(groomerShowBreeds -> groomerShowBreeds.getShowLevels().contains(po.getShowLevel()))
						.count();
				minCount = maxCount - (int) currentLevelCount;
				minCount = minCount <= 0 ? 1 : minCount;
			} else {
				minCount = maxCount;
			}
			//校验犬种数量
			int count = (CollectionUtils.isEmpty(currentDogBreedList) ? 0 : currentDogBreedList.size())
					+ (CollectionUtils.isEmpty(currentExtraDogBreedList) ? 0 : currentExtraDogBreedList.size());
			if (count > maxCount || count < minCount) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛犬种数量有误，该级别应选择大于等于" + minCount +
						"类且小于等于" + maxCount + "类犬种后再提交");
			}

			if(!CollectionUtils.isEmpty(currentDogBreedList)) {
				//校验已经报名犬种是否有重复项
				if (!CollectionUtils.isEmpty(registerBreedList)) {
					List<String> duplicateList = registerBreedList.stream()
							.filter(old -> currentDogBreedList.stream()
									.anyMatch(current -> current.equals(old)))
							.collect(Collectors.toList());
					if (!CollectionUtils.isEmpty(duplicateList)) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, String.join("、", duplicateList)
								+ "已经在其他级别选择过，请重新选择后再提交");
					}
				}

				//校验每个犬种组只能选一个
				if (!CollectionUtils.isEmpty(groomerBreedList)) {
					ArrayList<String> duplicateList = groomerBreedList.stream()
							.filter(groomerShowBreeds -> currentDogBreedList.stream()
									.anyMatch(s -> s.equals(groomerShowBreeds.getBreedName())))
							.map(GroomerShowBreeds::getBreedGroup)
							.filter(StringUtils::isNotBlank)
							.collect(Collectors.collectingAndThen(
									Collectors.groupingBy(Function.identity(), Collectors.counting()),
									map -> {
										map.values().removeIf(size -> size == 1);
										return new ArrayList<>(map.keySet());
									}));
					if (!CollectionUtils.isEmpty(duplicateList)) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, String.join("、", duplicateList)
								+ "组信息有误，同一组只能选择一个犬种，请重新选择后再提交");
					}
				}
			}
		}
		if (StringUtils.isBlank(po.getShowLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请选择参赛级别!");
		}
		if(StringUtils.isBlank(groomerShow.getTestLevel())
				|| !groomerShow.getTestLevel().contains(po.getShowLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该活动没有所选级别!");
		}
	}

	public List<GroomerRegister> getGroomerRegister(String memberCode) {
		List<GroomerRegister> list = dao.getGroomerRegister(memberCode);
		return list;
	}

	/**
	 * @Description：重置美容报名审核状态（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:08:59
	 */
	@Transactional(readOnly = false)
	public void changeReviewState(String id) {
		dao.changeReviewState(id);
	}

	/**
	 * 报名信息上传证件照
	 *
	 * @Author chaixueteng
	 * @2016年12月16日上午10:21:04
	 */
	@Transactional(readOnly = false)
	public void toReImage(GroomerRegister groomerRegister) throws Exception {
		try {
			String memberCode = groomerRegister.getMemberCode();
			String state = groomerRegister.getReviewState();
			String remarks = groomerRegister.getReviewRemarks();
			String avatar = groomerRegister.getAvatar();
			if (StringUtils.isBlank(avatar)) {
				throw new ZAException(-1, "请上传正确的证件照");
			}

			String id = groomerRegister.getId();
			GroomerRegister gr = get(id);
			String showCode = gr.getShowCode();
			SysContext sysContext = new SysContext(gr.getPaymentState(), gr.getReviewState(), gr.getProccessState());
			GroomerRegister GR = new GroomerRegister(id);
			GR.setAvatar(avatar);
			if ("1".equals(state)) {
				GR.setReviewState("1");
				GR.setReviewTime(new Date());
				sysContext.confirmSuccess(sysContext, "报名证件照", gr.getMemberCode(), "groomer_register", gr.getId(),
						gr.getRunningNumber(), (str) -> {

						});
				// 审核通过 同步会员证件照
				memberService.synImage(memberCode, avatar);
			} else {
				GR.setReviewState("2");
				GR.setReviewTime(new Date());
				GR.setReviewRemarks(remarks);
				sysContext.confirmFail(sysContext, "报名证件照", remarks, gr.getMemberCode(), "groomer_register", gr.getId(),
						gr.getRunningNumber(), (str) -> {

						});
			}
			dao.saveImage(GR);
			String reviewState = GR.getReviewState();
			if ("1".equals(reviewState)) {
				remindService.addMemberRemind("您报名的活动编号为:" + showCode + "的参赛证件照审核已成功。", memberCode);
			} else {
				remindService.addMemberRemind("您报名的活动编号为:" + showCode + "的参赛证件照审核未通过。未通过原因:" + GR.getReviewRemarks(),
						memberCode);
			}
		} catch (Exception e) {
			throw new ZAException(-1, "审核失败!");
		}

	}

	/**
	 * 获取考题
	 * @param groomerRegister
	 * @return
	 */
	public GroomerExamQuestionBank getExamQuestions(GroomerRegister groomerRegister){
		GroomerExamQuestionBank groomerExamQuestionBankQuery = new GroomerExamQuestionBank();
		groomerExamQuestionBankQuery.setCosmetologyCertificateLevelId(CosmetologyCertificateLevelEnum.getCode(groomerRegister.getShowLevel()).getCode());
		GroomerExamQuestionBank groomerExamQuestionBank;
		//根据美容级别对应指定考题
		try {
			groomerExamQuestionBank = groomerExamQuestionBankService.getByCosmetologyCertificateLevelId(groomerExamQuestionBankQuery);
			if (Objects.isNull(groomerExamQuestionBank)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "根据美容证书资格级别查询考卷为null");
			}
			List<GroomerExamQuestions> groomerExamQuestions = groomerExamQuestionsService.getByExamPaperId(groomerExamQuestionBank.getExamPaperId());
			if (CollectionUtils.isEmpty(groomerExamQuestions)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "根据美容试卷id查询考题为null");
			}

			List<String> questionIds = groomerExamQuestions.stream().map(GroomerExamQuestions::getQuestionId).collect(Collectors.toList());
			List<GroomerExamQuestionsOptions> groomerExamQuestionsOptions = groomerExamQuestionsOptionsService.queryQuestionsOptionsByQuestionIds(questionIds);
			if (CollectionUtils.isEmpty(groomerExamQuestionsOptions)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "根据美容试卷问题id查询问题选项为null");
			}
			//将选项根据questionId分组
			Map<String, List<GroomerExamQuestionsOptions>> optionsMap = groomerExamQuestionsOptions.stream()
					.collect(Collectors.groupingBy(GroomerExamQuestionsOptions::getQuestionId));
			//将选项放在对应问题的对象里
			//随机考题
			Collections.shuffle(groomerExamQuestions);
			for (GroomerExamQuestions groomerExamQuestion : groomerExamQuestions) {
				groomerExamQuestion.setAnswer(null);
				List<GroomerExamQuestionsOptions> groomerExamQuestionsOptionsValue = optionsMap.get(groomerExamQuestion.getQuestionId());
				//随机选项
				Collections.shuffle(groomerExamQuestionsOptionsValue);
				groomerExamQuestion.setGroomerExamQuestionsOptionsList(groomerExamQuestionsOptionsValue);
			}
			groomerExamQuestionBank.setGroomerExamQuestionsList(groomerExamQuestions);
			return groomerExamQuestionBank;
		} catch (ZAException e) {
			logger.info("getExamQuestions" + e.getMessage());
			return null;
		}
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public Boolean commitWrittenExam(GroomerWrittenExamInfo groomerWrittenExamInfo, CommitWrittenExamRequest commitWrittenExamRequest) {
		//增加redis锁，以会员号，报名id，考试记录id，commitExam为唯一标识
		String rdsKey = groomerWrittenExamInfo.getMemberCode() + Constants.LINE + groomerWrittenExamInfo.getRegisterId()
				+ Constants.LINE + groomerWrittenExamInfo.getId() + Constants.LINE + "commitExam";

		if (JedisUtils.setNx(rdsKey, Constants.STRING_NUM_ONE, Constants.TIME_OUT)) {
			try {
				if (StringUtils.isNotBlank(groomerWrittenExamInfo.getGradeWrite())) {
					logger.info("GroomerRegisterService commitWrittenExam param : {} 成绩以出,重复提交,无需处理！", JSONObjectUtils.toJsonString(groomerWrittenExamInfo));
					return Boolean.TRUE;
				}
				/*Thread.sleep(5000);*/
				GroomerRegister groomerRegister = this.get(groomerWrittenExamInfo.getRegisterId());
				/*logger.info("GroomerRegisterService commitWrittenExam examPaperId : {}", commitWrittenExamRequest.getExamPaperId());*/
				//不区分删除是防止已经开始考试了没提交，否则结果会对不上
				List<GroomerExamQuestions> groomerExamQuestions = groomerExamQuestionsService.getByExamPaperIdAndNoDelFlag(commitWrittenExamRequest.getExamPaperId());
				if (CollectionUtils.isEmpty(groomerExamQuestions)) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "根据美容试卷id查询考题为空");
				}
				//笔试用时
				Long useTimeUnitMinute = (commitWrittenExamRequest.getEndExamTime().getTime()
						- groomerWrittenExamInfo.getStartExamTime().getTime()) / 60000;

				//将考题信息转成key value格式 key-> 题Id | value-> 答案
				Map<String, String> examQuestionsMap = groomerExamQuestions.stream()
						.collect(Collectors.toMap(GroomerExamQuestions::getQuestionId, GroomerExamQuestions::getAnswer));
				List<CommitWrittenExamDetailRequest> commitWrittenExamDetailRequests = commitWrittenExamRequest.getCommitWrittenExamDetailRequests();

				//获取答对多少道题
				Long rightNum = commitWrittenExamDetailRequests.stream().filter(item ->
						examQuestionsMap.get(item.getQuestionId()).equals(item.getSelectOptionId())
				).count();
				//笔试成绩
				int gradeWrite = rightNum.intValue() * Constants.NUM_TWO;
				groomerWrittenExamInfo.setGradeTime(new Date());
				groomerWrittenExamInfo.setExamTime(String.valueOf(useTimeUnitMinute));
				groomerWrittenExamInfo.setAnswerInfo(JSON.toJSONString(commitWrittenExamRequest));
				groomerWrittenExamInfo.setEndExamTime(commitWrittenExamRequest.getEndExamTime());
				groomerWrittenExamInfo.setCommitExamType(commitWrittenExamRequest.getCommitExamType());
				groomerWrittenExamInfo.setLastSelectedTime(commitWrittenExamRequest.getLastSelectedTime());
				groomerWrittenExamInfo.setGradeWrite(String.valueOf(gradeWrite));
				Boolean examPassed = Boolean.FALSE;
				switch (groomerRegister.getShowLevel()) {
					case Constants.A:
						if (gradeWrite >= Constants.NINETY) {
							examPassed = Boolean.TRUE;
						}
						break;
					case Constants.B:
						if (gradeWrite >= Constants.EIGHTY) {
							examPassed = Boolean.TRUE;
						}
						break;
					case Constants.C:
						if (gradeWrite >= Constants.SEVENTY) {
							examPassed = Boolean.TRUE;
						}
						break;
				}
				if (examPassed) {
					groomerWrittenExamInfo.setWrittenExamStatus(Integer.valueOf(GradeWrittenEnum.PASSED.code()));
					groomerRegister.setGradeWrite(GradeWrittenEnum.PASSED.code());
				} else {
					groomerWrittenExamInfo.setWrittenExamStatus(Integer.valueOf(GradeWrittenEnum.FAIL.code()));
					groomerRegister.setGradeWrite(GradeWrittenEnum.FAIL.code());
				}

				//更新信息
				groomerWrittenExamInfoService.updateWrittenExamInfoAndStatus(groomerRegister, groomerWrittenExamInfo);
				GroomerShow show = groomerShowDao.getShowType(groomerRegister.getShowCode());
				String[] str = groomerRegister.getShowCode().split(Constants.LINE);
				// 成绩、笔事成绩必须通过，才可发证书
				if (StringUtils.isNotBlank(groomerRegister.getGradeWrite()) && "1".equals(groomerRegister.getGradeWrite())) {
					// 资格认证考试
					if ("1".equals(show.getShowCategory())) {
						if (str[2].trim().equals("ZG")) {
							// 考试通过才会有资格证书
							this.groomerQualificationCertificateApplyForZG(groomerRegister, show);
						} else if (str[2].trim().equals("JY")) {
							this.groomerQualificationCertificateApplyForJY(groomerRegister, show);
						} else if (str[2].trim().equals("CQ") || str[2].trim().equals("CQTZ")) {
							this.groomerQualificationCertificateApplyForCQ(groomerRegister, show);
						} else if (str[2].trim().equals("ZHRY")) {
							this.groomerQualificationCertificateApplyForZHRY(groomerRegister, show);
						}
					}
				}
				return Boolean.TRUE;
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, e.getMessage());
			} finally {
				JedisUtils.del(rdsKey);
			}
		} else {
			logger.info("The Key is not Free : {}", JSONObjectUtils.toJsonString(rdsKey));
			throw new ZAException(ZAErrorCode.ZA_ERROR, "已在处理，请稍后重试");
		}

	}

	/**
	 * 生成考试记录信息并更新或者插入
	 * @param groomerRegister
	 * @param groomerExamQuestionBank
	 */
	@Transactional(readOnly = false)
	public String generateGroomerWrittenExamInfo(GroomerRegister groomerRegister, GroomerExamQuestionBank groomerExamQuestionBank, Boolean unexamined) {

		GroomerWrittenExamInfo groomerWrittenExamInfo;
		if (unexamined) {
			groomerWrittenExamInfo = new GroomerWrittenExamInfo();
			groomerWrittenExamInfo.setDelFlag(Constants.STRING_ZERO);
			groomerWrittenExamInfo.setCurrentUser(UserUtils.getLoginUser());
			groomerWrittenExamInfo.setShowCode(groomerRegister.getShowCode());
			groomerWrittenExamInfo.setRegisterId(groomerRegister.getId());
			groomerWrittenExamInfo.setPaymentMemberCode(groomerRegister.getPaymentMemberCode());
			groomerWrittenExamInfo.setMemberCode(groomerRegister.getMemberCode());
		} else {
			GroomerWrittenExamInfo groomerWrittenExamInfoQuery = new GroomerWrittenExamInfo();
			groomerWrittenExamInfoQuery.setRegisterId(groomerRegister.getId());
			groomerWrittenExamInfoQuery.setMemberCode(UserUtils.getLoginMember().getMemberCode());
			logger.info("groomerWrittenExamInfoQuery registerId : {}" ,
					JSONObjectUtils.toJsonString(groomerWrittenExamInfoQuery));
			//根据条件查询笔试记录
			groomerWrittenExamInfo = groomerWrittenExamInfoService
					.queryWrittenExamInfoByCondition(groomerWrittenExamInfoQuery);
			logger.info("generateGroomerWrittenExamInfo groomerWrittenExamInfoService.queryWrittenExamInfoByCondition result : {}", JSONObjectUtils.toJsonString(groomerWrittenExamInfo));
			if (Objects.isNull(groomerWrittenExamInfo)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "补考状态下无考试记录信息， 请联系工作人员!");
			}
			if (groomerWrittenExamInfo.getStartExamTime() != null && groomerWrittenExamInfo.getPaymentState().equals(Constants.STRING_NUM_TWO)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "考试已经开始,不能重复考试!");
			}
			if (!Objects.equals(groomerWrittenExamInfo.getPaymentState(), Constants.STRING_NUM_TWO)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "当前美容活动补考费用未支付，请支付!");
			}
		}

		//存信息
		JSONObject currentExamInfoJson = new JSONObject();
		List<ExamPaperInfo> examPaperInfos = new ArrayList<>();
		for (GroomerExamQuestions groomerExamQuestions : groomerExamQuestionBank.getGroomerExamQuestionsList()) {
			//只拿optionId
			List<String> optionIds = groomerExamQuestions.getGroomerExamQuestionsOptionsList().stream()
					.map(GroomerExamQuestionsOptions::getOptionId).collect(Collectors.toList());

			ExamPaperInfo examPaperInfo = new ExamPaperInfo();
			examPaperInfo.setQuestionId(groomerExamQuestions.getQuestionId());
			examPaperInfo.setOptionIds(optionIds);
			examPaperInfos.add(examPaperInfo);
		}
		currentExamInfoJson.put(groomerExamQuestionBank.getExamPaperId(), JSON.toJSONString(examPaperInfos));
		//将明细信息放到当前考卷信息的map中
		groomerWrittenExamInfo.setCurrentExamPaper(currentExamInfoJson.toJSONString());
		groomerWrittenExamInfo.setExamPaperId(groomerExamQuestionBank.getExamPaperId());
		groomerWrittenExamInfo.setStartExamTime(new Date());

		groomerRegister.setEligibility(Boolean.FALSE);
		groomerRegister.setExamNum(groomerRegister.getExamNum() + Constants.NUM_ONE);
		groomerRegister.setReset(Boolean.FALSE);
		groomerRegister.setRemarks("");
		//是补考直接更新该条记录
		logger.info("groomerWrittenExamInfoService.save param : {}", JSONObjectUtils.toJsonString(groomerWrittenExamInfo));
		groomerWrittenExamInfoService.save(groomerWrittenExamInfo);
		groomerExamQuestionBank.setWrittenInfoId(groomerWrittenExamInfo.getId());
		this.save(groomerRegister);

		//计时关闭
		groomerWrittenExamInfoService.sendDelayedMessage( groomerWrittenExamInfo.getId(), groomerExamQuestionBank.getExamDuration());
		return groomerRegister.getId();

	}

	/**
	 * 查询成绩明细
	 * @param groomerRegister
	 * @return
	 */
	public GroomerRegisterVO queryGradeDetails(GroomerRegister groomerRegister){
		GroomerWrittenExamInfo groomerWrittenExamInfo = new GroomerWrittenExamInfo();
		groomerWrittenExamInfo.setMemberCode(groomerRegister.getMemberCode());
		groomerWrittenExamInfo.setRegisterId(groomerRegister.getId());
		List<GroomerWrittenExamInfo> groomerWrittenExamInfos = groomerWrittenExamInfoDao
				.queryWrittenExamInfoByCondition(groomerWrittenExamInfo);
		logger.info("groomerRegisterService groomerWrittenExamInfoDao.queryWrittenExamInfoByCondition result : {}", JSONObjectUtils.toJsonString(groomerWrittenExamInfos));
		GroomerRegisterVO groomerRegisterVO = new GroomerRegisterVO();
		BeanUtils.copyProperties(groomerRegister, groomerRegisterVO);
		if (CollectionUtils.isNotEmpty(groomerWrittenExamInfos)) {
			groomerRegisterVO.setGroomerWrittenExamInfoList(groomerWrittenExamInfos);
		}
		return groomerRegisterVO;
	}

	/**
	 * 重置考试
	 */
	@Transactional
	public void resetExam(GroomerRegister groomerRegister, GroomerWrittenExamInfo groomerWrittenExamInfo){
		String name = UserUtils.getLoginUser().getName();
		String id = UserUtils.getLoginUser().getId();
		String currentDateTime = DateUtils.formatDateToStr(new Date());
		groomerRegister.setEligibility(Boolean.TRUE);
		groomerRegister.setReset(Boolean.TRUE);
		groomerRegister.setGradeWrite(null);
		groomerRegister.setUpdateDate(new Date());
		groomerRegister.setUpdateBy(UserUtils.getLoginUser().getCurrentUser());
		groomerWrittenExamInfo.setRemarks("业务人员 :" + id
				+ Constants.LINE + name + "于" + currentDateTime + "操作, 操作内容为 : 重置考试");
		groomerRegisterDao.update(groomerRegister);
		groomerWrittenExamInfoDao.update(groomerWrittenExamInfo);
	}

	/**
	 * 美容考试资格证书申请 showCode【2】 ZG
	 * @param gr
	 * @param show
	 */
	public void groomerQualificationCertificateApplyForZG(GroomerRegister gr, GroomerShow show){
		// 考试通过才会有资格证书
		if (!"0".equals(gr.getGrade()) && !"1".equals(gr.getGrade())) {
			GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
			gqc.setCertificateType("1");
			gqc.preInsert();
			gqc.setCertificateCode(null);
			gqc.setRegisterId(gr.getId());
			gqc.setMemberCode(gr.getMemberCode());
			gqc.setCorsage(null);
			gqc.setPrintState("0");
			gqc.setReviewState("0");
			gqc.setPaymentState("1");
			gqc.setProccessState("0");
			gqc.setTakeCertificateDate(gr.getTakeCertificateDate());
			gqc.setReviewer(gr.getReferee());
			gqc.setIsFree("1");
			gqc.setCertificateSource("1");
			String level = gr.getShowLevel();
			if (level.trim().equals("教师")) {
				gqc.setLevelCn(level);
				gqc.setLevelEn("MASTER");
			} else if (level.trim().equals("MASTER")) {
				gqc.setLevelEn(level);
				gqc.setLevelCn("教师");
			} else {
				gqc.setLevelEn(level);
				gqc.setLevelCn(level);
			}
			groomerQualificationCertificateService.saveCertificate(gqc);
			groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());
			remindService.addRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			// 领取美容师资格证书并生成国际宠物美容师证书
			/*save(gr.getId(), gr, gr.getTakeCertificateDate(), gr.getReferee());*/
		} else if ("0".equals(gr.getGrade())) {// 未通过
			remindService.addRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel(), "1");
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}
		} else if ("1".equals(gr.getGrade())) {
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel(), "1");
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废第一次证书
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}
		}
	}

	/**
	 * 美容考试资格证书申请 showCode【2】 JY
	 * @param gr
	 * @param show
	 */
	public void groomerQualificationCertificateApplyForJY(GroomerRegister gr, GroomerShow show){
		if ("8".equals(gr.getGrade()) || "9".equals(gr.getGrade()) || "10".equals(gr.getGrade()) || "2".equals(gr.getGrade())
				|| "11".equals(gr.getGrade())) {
			GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
			gqc.setCertificateType("1");
			gqc.preInsert();
			gqc.setCertificateCode(null);
			gqc.setRegisterId(gr.getId());
			gqc.setMemberCode(gr.getMemberCode());
			gqc.setCorsage(null);
			gqc.setPrintState("0");
			gqc.setReviewState("0");
			gqc.setPaymentState("1");
			gqc.setProccessState("0");
			gqc.setTakeCertificateDate(gr.getTakeCertificateDate());
			gqc.setReviewer(gr.getReferee());
			gqc.setLevelEn("A");
			gqc.setLevelCn("A");
			gqc.setIsFree("1");
			gqc.setCertificateSource("1");
			if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "1")
					.size() <= 0) {
				groomerQualificationCertificateService.saveCertificate(gqc);
			}
			groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());
			remindService.addMemberRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			// 领取美容师资格证书并生成国际宠物美容师证书
			/*save(id, gr, takeCertificateDate, referee);*/
		}
	}

	/**
	 * 美容考试资格证书申请 showCode【2】 CQ
	 * @param gr
	 * @param show
	 */
	public void groomerQualificationCertificateApplyForCQ(GroomerRegister gr, GroomerShow show) {
		String grade = gr.getGrade();
		if ("8".equals(grade) || "9".equals(grade) || "10".equals(grade) || "2".equals(grade)
				|| "11".equals(grade)) {
			String level = gr.getShowLevel();
			if (!"A".equals(level.trim())) {
				GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
				gqc.setCertificateType("1");
				gqc.preInsert();
				gqc.setCertificateCode(null);
				gqc.setRegisterId(gr.getId());
				gqc.setMemberCode(gr.getMemberCode());
				gqc.setCorsage(null);
				gqc.setPrintState("0");
				gqc.setReviewState("0");
				gqc.setPaymentState("1");
				gqc.setProccessState("0");
				gqc.setTakeCertificateDate(gr.getTakeCertificateDate());
				gqc.setReviewer(gr.getReferee());
				gqc.setIsFree("1");
				if ("B".equals(level.trim())) {
					gqc.setLevelEn("A");
					gqc.setLevelCn("A");
				} else if ("C".equals(level.trim())) {
					gqc.setLevelEn("B");
					gqc.setLevelCn("B");
				}
				gqc.setCertificateSource("1");
				groomerQualificationCertificateService.saveCertificate(gqc);
				groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());
				remindService.addMemberRemind(
						"恭喜您通过" + show.getShowName()
								+ "，获得申领CKU美容师资格证书的资质。请您自考试当日起61天内申请领取资格证书，逾期将不可以自行办理。",
						gr.getMemberCode());
				// 领取美容师资格证书并生成国际宠物美容师证书
				/*save(id, gr, takeCertificateDate, referee);*/
			}
		} else if ("0".equals(grade) || "1".equals(grade)) {
			String level = gr.getShowLevel();
			if (!"A".equals(level.trim())) {
				if ("B".equals(level.trim())) {
					List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
							.eqCertificate(gr.getMemberCode(), "A", "1");
					if (list.size() > 0) {// 存在同级别证书 则作废
						for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
							groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
							groomerQualificationCertificateDao
									.deleteCertificate(groomerQualificationCertificate);
						}
					}
				}
			} else if ("C".equals(level.trim())) {
				List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
						.eqCertificate(gr.getMemberCode(), "B", "1");
				if (list.size() > 0) {// 存在同级别证书 则作废
					for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
						groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
						groomerQualificationCertificateDao
								.deleteCertificate(groomerQualificationCertificate);
					}
				}
			}
		}
	}

	/**
	 * 美容考试中华荣耀证书申请 showCode【2】 ZHRY
	 * @param gr
	 * @param show
	 */
	public void groomerQualificationCertificateApplyForZHRY(GroomerRegister gr, GroomerShow show){
		// 考试通过才会有中华荣耀证书
		if (!"0".equals(gr.getGrade()) && !"1".equals(gr.getGrade())) {
			GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
			gqc.setCertificateType("1");
			gqc.preInsert();
			gqc.setCertificateCode(null);
			gqc.setRegisterId(gr.getId());
			gqc.setMemberCode(gr.getMemberCode());
			gqc.setCorsage(null);
			gqc.setPrintState("0");
			gqc.setReviewState("0");
			gqc.setPaymentState("1");
			gqc.setProccessState("0");
			gqc.setTakeCertificateDate(gr.getTakeCertificateDate());
			gqc.setReviewer(gr.getReferee());
			gqc.setIsFree("1");
			gqc.setCertificateSource("1");
			String level = gr.getShowLevel();
			if (level.trim().equals("教师")) {
				gqc.setLevelCn(level);
				gqc.setLevelEn("MASTER");
			} else if (level.trim().equals("MASTER")) {
				gqc.setLevelEn(level);
				gqc.setLevelCn("教师");
			} else {
				gqc.setLevelEn(level);
				gqc.setLevelCn(level);
			}
			if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn(), "1")
					.size() <= 0) {
				groomerQualificationCertificateService.saveCertificate(gqc);
			}
			groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());
			remindService.addRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师中华荣耀证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师中华荣耀证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			// 领取美容师资格证书并生成国际宠物美容师证书
			/*save(gr.getId(), gr, gr.getTakeCertificateDate(), gr.getReferee());*/
		} else if ("0".equals(gr.getGrade())) {// 未通过
			remindService.addRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel(), "1");
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}
		} else if ("1".equals(gr.getGrade())) {
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel(), "1");
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废第一次证书
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}
		}
	}

	/**
	 * 美容派多格证书申请 showCode【2】 PDG
	 * @param gr
	 * @param show
	 */
	public void groomerQualificationCertificateApplyForPDG(GroomerRegister gr, GroomerShow show) {
		// 考试通过才会有派多格的证书
		if ("2".equals(gr.getGrade())) {
			GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
			gqc.setCertificateType("6");
			gqc.preInsert();
			gqc.setCertificateCode(null);
			gqc.setRegisterId(gr.getId());
			gqc.setMemberCode(gr.getMemberCode());
			gqc.setCorsage(null);
			gqc.setPrintState("0");
			gqc.setReviewState("0");
			gqc.setPaymentState("1");
			gqc.setProccessState("0");
			gqc.setTakeCertificateDate(gr.getTakeCertificateDate());
			gqc.setReviewer(gr.getReferee());
			gqc.setIsFree("1");
			gqc.setCertificateSource("1");
			String level = gr.getShowLevel();
			gqc.setLevelEn(level);
			gqc.setLevelCn(level);
			/*if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn())
					.size() <= 0) {
				groomerQualificationCertificateService.saveCertificate(gqc);
			}*/
			List<GroomerQualificationCertificate> pdgByShowCodeAndMemberCode = groomerQualificationCertificateService.getPdgByShowCodeAndMemberCode(gr.getShowCode(), gr.getMemberCode());
			if (CollectionUtils.isEmpty(pdgByShowCodeAndMemberCode)) {
				groomerQualificationCertificateService.insertCertificate(gqc);
				logger.info("-----------------插入派多格证书成功");
			}
			/*groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());*/
			remindService.addRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领派多格美容资格证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领派多格美容资格证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
		} else if ("0".equals(gr.getGrade())) {// 未通过
			remindService.addRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			/*List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel());
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}*/
		} /*else if ("1".equals(gr.getGrade())) {
			List<GroomerQualificationCertificate> list = groomerQualificationCertificateDao
					.eqCertificate(gr.getMemberCode(), gr.getShowLevel());
			if (list.size() > 0 && "教师".equals(gr.getShowLevel())) {// 存在同级别证书 则作废第一次证书
				for (GroomerQualificationCertificate groomerQualificationCertificate : list) {
					groomerQualificationCertificate.setRemarks("第二次同级别考试不合格作废上一次");
					groomerQualificationCertificateDao
							.deleteCertificate(groomerQualificationCertificate);
				}
			}
		}*/
	}

	/**
	 * FCI美容大赛证书生成 showCode【2】 FGJ
	 * @param gr
	 * @param show
	 */
	public void fciGroomerQualificationCertificateApplyForFci(GroomerRegister gr, GroomerShow show) {
		// 考试通过会发Fci的证书
		if ((Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.PASSED.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.FIRST.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.SECOND.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.THIRD.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.EXCELLENT.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.EXTREMELY_EXCELLENT.getCode())
				|| Objects.equals(Integer.parseInt(gr.getGrade()), OperationExamStatusEnum.BEST_OVERALL.getCode()))) {
			FciGroomerQualificationCertificate fciGroomerQualificationCertificate = new FciGroomerQualificationCertificate();
			fciGroomerQualificationCertificate.preInsert();
			fciGroomerQualificationCertificate.setLevelEn(gr.getShowLevel());
			fciGroomerQualificationCertificate.setSourceType(String.valueOf(FciGroomerQCSourceTypeEnum.FCI_SHOW.code()));
			fciGroomerQualificationCertificate.setDogCategory(gr.getShowDogBreed());
			fciGroomerQualificationCertificate.setRefereeSignaturePhotoBase64List(Lists.newArrayList());
			fciGroomerQualificationCertificate.setMemberCode(gr.getMemberCode());
			fciGroomerQualificationCertificate.setRegisterId(gr.getId());
			fciGroomerQualificationCertificate.setTakeCertificateDate(new Date());
			fciGroomerQualificationCertificate.setIssueDate(new Date());
			fciGroomerQualificationCertificate.setPrintState("0");
			fciGroomerQualificationCertificate.setRunningNumber("");
			fciGroomerQualificationCertificate.setPaymentState("1");
			fciGroomerQualificationCertificate.setPaymentTime(null);
			fciGroomerQualificationCertificate.setIsFree("1");
			fciGroomerQualificationCertificate.setCertificateState("0");
			fciGroomerQualificationCertificate.setPaper("0");
			fciGroomerQualificationCertificate.setFciCertificateCode(null);
			fciGroomerQualificationCertificate.setCertificateId(null);
			fciGroomerQualificationCertificate.setCertificateType("7");
			fciGroomerQualificationCertificate.setRefereeSignaturePhotoBase64("");
			fciGroomerQualificationCertificate.setRemarks("");
			fciGroomerQualificationCertificate.setDelFlag("0");
			fciGroomerQualificationCertificate.setReferee(gr.getReferee());

			/*if (groomerQualificationCertificateDao.eqCertificatepay(gr.getMemberCode(), gqc.getLevelEn())
					.size() <= 0) {
				groomerQualificationCertificateService.saveCertificate(gqc);
			}*/
			/*groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());*/
			if (fciGroomerQualificationCertificateService.eqCertificatepay(gr.getMemberCode(), fciGroomerQualificationCertificate.getLevelEn())
					.size() <= 0) {
				fciGroomerQualificationCertificateService.saveCertificate(fciGroomerQualificationCertificate);
			}
			//groomerQualificationCertificate(gr.getMemberCode(), gqc, gr.getId());
			remindService.addRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师Fci资格证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"恭喜您通过" + show.getShowName()
							+ "，获得申领CKU美容师Fci资格证书的资质。请您自考试当日起61天内申请领取证书，逾期将不可以自行办理。",
					gr.getMemberCode());
			// 领取美容师资格证书并生成国际宠物美容师证书
			/*save(gr.getId(), gr, gr.getTakeCertificateDate(), gr.getReferee());*/
		} else if ("0".equals(gr.getGrade())) {// 未通过
			remindService.addRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
			remindService.addMemberRemind(
					"感谢您此次参加" + show.getShowName()
							+ "。虽然您在此次考试中未能顺利通过，但请不要气馁；希望您能够进一步提升与突破自我，期待您在下一次考试中取得骄人成绩！",
					gr.getMemberCode());
		} else if ("1".equals(gr.getGrade())) {

		}
	}

	/**
	 * fci活动App自动选择等级
	 * @param member
	 * @return
	 * @throws ZAException
	 */
	public String autoFciSelectLevel(Member member) throws ZAException {
		String memberCode = member.getMemberCode();
		// Date birthday = member.getBirthday();
		FciGroomerQualificationCertificate gqc = fciGroomerQualificationCertificateService.getLevel(memberCode);
		if (gqc == null) {
			logger.info("---------------查询记录-------------- ： {}", JSONObjectUtils.toJsonString(gqc));
			return "C";
		} else {
			String level = gqc.getLevelEn();
			if ("国际宠物美容师".equals(level) || "国际高级宠物美容师".equals(level) || "宠物造型师".equals(level)) {
				return "C";
			}
			// Date issueDate = gqc.getIssueDate();
			// Calendar curr = Calendar.getInstance();
			// 实现报名自动选择美容师上一级的赛事
			if (level.equals("C")) {// C--B
				/*
				 * if (b) { curr.set(Calendar.MONTH,curr.get(Calendar.MONTH)-6); Date
				 * date=curr.getTime(); if (issueDate.after(date)) { throw new
				 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "持有证书时间不足半年!"); } }
				 */
				return "B";
			} else if (level.equals("B")) {// B-->A
				/*
				 * if (b) { curr.set(Calendar.YEAR,curr.get(Calendar.YEAR)-1); Date
				 * date=curr.getTime(); if (issueDate.after(date)) { throw nesw
				 * ZAException(ZAErrorCode.ZA_VALID_FAILED, "持有证书时间不足一年!"); } }
				 */
				return "A";
			}
			return level;
		}
	}
}