package com.cku.oa.groomer.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.GroomerCourseDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.schools.mrschool.service.OSSUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 美容课程表Service
 * @author cxt
 * @version 2017-06-19
 */
@Service
@Transactional(readOnly = true)
public class GroomerCourseService extends CrudService<GroomerCourseDao, GroomerCourse> {
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;

	public GroomerCourse get(String id) {
		return super.get(id);
	}

	public List<GroomerCourse> findList(GroomerCourse groomerCourse) {
		return super.findList(groomerCourse);
	}

	public Page<GroomerCourse> findPage(Page<GroomerCourse> page, GroomerCourse groomerCourse) {
		return super.findPage(page, groomerCourse);
	}
	public Page<GroomerCourse> findPageByApp(Page<GroomerCourse> page, GroomerCourse groomerCourse) {
		return super.findPage(page, groomerCourse);

	}

	@Transactional(readOnly = false)
	public void save(GroomerCourse groomerCourse) {
		super.save(groomerCourse);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerCourse groomerCourse) {
		super.delete(groomerCourse);
	}

	/*
	 * 查询最近20场的课程
	 * @see com.thinkgem.jeesite.common.service.CrudService#findList(com.thinkgem.jeesite.common.persistence.DataEntity)
	 */
	public List<GroomerCourse> findCourseList(GroomerCourse groomerCourse) {
		List<GroomerCourse> courseList = dao.findCourseList(groomerCourse);
		List<GroomerCourse> list = courseList.stream().map(data->{
			GroomerCourse vo = new GroomerCourse();
			BeanUtil.copyProperties(vo, data, "MM/dd");
			vo.setCourseName(data.getCode()+"-"+data.getCourseName());
		return 	vo;
		}).collect(Collectors.toList());
		return list;
	}

	public void export(GroomerCourse groomerCourse, HttpServletResponse response) throws IOException {
		List<GroomerCourse> groomerCourseList=dao.findList(groomerCourse);
		groomerCourseList = groomerCourseList.stream().map(data->{
			data.setSchoolId(trainingInstitutionDao.get(data.getSchoolId()).getSchoolNameCn());
			data.setDiplomaLevel(DictUtils.getDictLabel(data.getDiplomaLevel(), "course_level",""));
			data.setType(DictUtils.getDictLabel(data.getType(), "course_type",""));
			data.setStates(DictUtils.getDictLabel(data.getStates(), "course_states",""));
			return data;
		}).collect(Collectors.toList());
		new ExportExcel("", GroomerCourse.class, 2).setDataList(groomerCourseList).write(response, "美容师课程.xlsx").dispose();
	}

	@Transactional(readOnly = false)
	public void offStates(GroomerCourse groomerCourse) {
		GroomerCourse course = dao.get(groomerCourse.getId());
		if(course == null ){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"id错误");
		}
		course.setStates("5");
		dao.update(course);
	}

	@Transactional(readOnly = false)
	public void saveReview(GroomerCourse groomerCourse) {
		if("4".equals(groomerCourse.getStates()) && StringUtils.isBlank(groomerCourse.getReviewRemarks())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"审核不通过请注明原因");
		}
		groomerCourse.setLaunchTime(new Date());
		dao.update(groomerCourse);
	}

	public void review(GroomerCourse groomerCourse, Model model) {
		if(StringUtils.isNotBlank(groomerCourse.getTeacherId())){
			TeacherLecturer teacherLecturer = schoolsTeacherDao.get(groomerCourse.getTeacherId());
			model.addAttribute("teacherLecturer", teacherLecturer);
		}
		if(StringUtils.isNotBlank(groomerCourse.getIntroduce())){
			String[] split = groomerCourse.getIntroduce().split(",");
			if(split.length == 3){
				groomerCourse.setPic1(split[0]);
				groomerCourse.setPic2(split[1]);
				groomerCourse.setPic3(split[1]);
			}else if(split.length == 2){
				groomerCourse.setPic1(split[0]);
				groomerCourse.setPic2(split[1]);
			}else if(split.length == 1){
				groomerCourse.setPic1(split[0]);
			}
		}
		if(StringUtils.isNotBlank(groomerCourse.getCourseDetails())){
			groomerCourse.setCourseDetails(StringEscapeUtils.unescapeHtml4(groomerCourse.getCourseDetails()));
		}
		if(StringUtils.isNotBlank(groomerCourse.getVideo())){
			groomerCourse.setVideoUrl(OSSUtils.getVodUrl(groomerCourse.getVideo()));
		}
	}

	@Transactional(readOnly = false)
    public int autoOffCourse() {
		return dao.autoOffCourse();
    }

	public GroomerCourse getCourseByCode(String code){
		return  dao.getCourseByCode(code);
	}

}