package com.cku.oa.groomer.enums;

import com.cku.oa.sys.entity.user.IEnum;

import java.util.Objects;

/**
 * 美容证书级别枚举
 * @author hjx
 */
public enum CosmetologyCertificateLevelEnum implements IEnum<Integer> {

	LEVEL_A(1, "A"),

	LEVEL_B(2, "B"),

	LEVEL_C(3, "C");

	private Integer code;

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	private String message;

	CosmetologyCertificateLevelEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	public static CosmetologyCertificateLevelEnum getCode(String level) {
		for (CosmetologyCertificateLevelEnum value : CosmetologyCertificateLevelEnum.values()) {
			if (Objects.equals(value.getMessage(), level)) {
				return value;
			}
		}
		return null;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
