package com.cku.oa.goods.service;

import java.util.List;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.goods.entity.SysBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.goods.entity.SysBusinessCate;
import com.cku.oa.goods.dao.SysBusinessCateDao;
import org.springframework.util.CollectionUtils;

/**
 * 业务分类Service
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@Service
@Transactional(readOnly = true)
public class SysBusinessCateService extends CrudService<SysBusinessCateDao, SysBusinessCate> {

	@Autowired
	private SysBusinessServiceService sysBusinessServiceService;

	public SysBusinessCate get(String id) {
		return super.get(id);
	}

	public List<SysBusinessCate> findList(SysBusinessCate sysBusinessCate) {
		return super.findList(sysBusinessCate);
	}

	public Page<SysBusinessCate> findPage(Page<SysBusinessCate> page, SysBusinessCate sysBusinessCate) {
		return super.findPage(page, sysBusinessCate);
	}

	/**
	 * 查询全部
	 *
	 * @author yuanshuai
	 * @date 2023/7/28 16:36
	 */
	public List<SysBusinessCate> findAllList() {
		return dao.findAllList(new SysBusinessCate());
	}

	@Transactional(readOnly = false)
	public void save(SysBusinessCate sysBusinessCate) {
		super.save(sysBusinessCate);
	}

	@Transactional(readOnly = false)
	public void delete(SysBusinessCate sysBusinessCate) {
		//已使用不可删除
		List<SysBusinessService> businessServiceList = sysBusinessServiceService.findListByCate(sysBusinessCate.getId());
		if (!CollectionUtils.isEmpty(businessServiceList)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有服务使用此分类");
		}
		super.delete(sysBusinessCate);
	}

}