package com.cku.oa.gcWeb.web;

import com.cku.oa.gcWeb.entity.GCWebInfo;
import com.cku.oa.gcWeb.service.GCWebInfoService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 美容官网信息Controller
 * @author yuanshuai
 * @version 2023-01-30
 */
@Controller
@RequestMapping(value = "${adminPath}/gcWeb/info")
public class GCWebInfoController extends BaseController {

	@Autowired
	private GCWebInfoService gcWebInfoService;
	
	@ModelAttribute
	public GCWebInfo get(@RequestParam(required=false) String id) {
		GCWebInfo entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = gcWebInfoService.get(id);
		}
		if (entity == null){
			entity = new GCWebInfo();
		}
		return entity;
	}
	
	@RequiresPermissions("gcWeb:info:view")
	@RequestMapping(value = {"list", ""})
	public String list(GCWebInfo gcWebInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GCWebInfo> page = gcWebInfoService.findPage(new Page<>(request, response), gcWebInfo);
		model.addAttribute("gcWebInfo", gcWebInfo);
		model.addAttribute("page", page);
		return "oa/gcWeb/gcWebInfoList";
	}

	@RequiresPermissions("gcWeb:info:view")
	@RequestMapping(value = "form")
	public String form(GCWebInfo gcWebInfo, Model model) {
		model.addAttribute("gcWebInfo", gcWebInfo);
		return "oa/gcWeb/gcWebInfoForm";
	}

	@RequiresPermissions("gcWeb:info:edit")
	@RequestMapping(value = "save")
	public String save(GCWebInfo gcWebInfo, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, gcWebInfo)){
			return form(gcWebInfo, model);
		}
		if (StringUtils.isNotBlank(gcWebInfo.getContent())) {
			gcWebInfo.setContent(StringEscapeUtils.unescapeHtml4(gcWebInfo.getContent()));
		}
		gcWebInfoService.save(gcWebInfo);
		addMessage(redirectAttributes, "保存美容官网信息成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/info/?repage";
	}
	
	@RequiresPermissions("gcWeb:info:del")
	@RequestMapping(value = "delete")
	public String delete(GCWebInfo gcWebInfo, RedirectAttributes redirectAttributes) {
		gcWebInfoService.delete(gcWebInfo);
		addMessage(redirectAttributes, "删除美容官网信息成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/info/?repage";
	}

}