package com.cku.oa.gcWeb.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.gcWeb.entity.GCWebContest;
import com.cku.oa.gcWeb.service.GCWebContestService;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.net.URLDecoder;
import java.util.Objects;

/**
 * 美容官网考试大赛Controller
 * @author yuanshuai
 * @version 2023-01-29
 */
@Controller
@RequestMapping(value = "${adminPath}/gcWeb/contest")
public class GCWebContestController extends BaseController {

	@Autowired
	private GCWebContestService gcWebContestService;
	
	@ModelAttribute
	public GCWebContest get(@RequestParam(required=false) String id) {
		GCWebContest entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = gcWebContestService.get(id);
		}
		if (entity == null){
			entity = new GCWebContest();
		}
		return entity;
	}
	
	@RequiresPermissions("gcWeb:contest:view")
	@RequestMapping(value = {"list", ""})
	public String list(GCWebContest gcWebContest, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GCWebContest> page = gcWebContestService.findPage(new Page<GCWebContest>(request, response), gcWebContest);
		model.addAttribute("gcWebContest", gcWebContest);
		model.addAttribute("page", page);
		return "oa/gcWeb/gcWebContestList";
	}

	@RequiresPermissions("gcWeb:contest:view")
	@RequestMapping(value = "form")
	public String form(GCWebContest gcWebContest, Model model) {
		if (Objects.isNull(gcWebContest.getShowFlag())) {
			gcWebContest.setShowFlag(1);
		}
		model.addAttribute("gcWebContest", gcWebContest);
		return "oa/gcWeb/gcWebContestForm";
	}

	@RequiresPermissions("gcWeb:contest:edit")
	@RequestMapping(value = "save")
	public String save(GCWebContest gcWebContest, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, gcWebContest)) {
			return form(gcWebContest, model);
		}
		if (StringUtils.isNotBlank(gcWebContest.getContent())) {
			gcWebContest.setContent(StringEscapeUtils.unescapeHtml4(gcWebContest.getContent()));
		}
		gcWebContestService.save(gcWebContest);
		addMessage(redirectAttributes, "保存美容官网考试大赛成功");
		return "redirect:" + Global.getAdminPath() + "/gcWeb/contest/?repage";
	}
	
	@RequiresPermissions("gcWeb:contest:del")
	@RequestMapping(value = "delete")
	public String delete(GCWebContest gcWebContest, RedirectAttributes redirectAttributes) {
		gcWebContestService.delete(gcWebContest);
		addMessage(redirectAttributes, "删除美容官网考试大赛成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/contest/?repage";
	}

}