package com.cku.oa.finance.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.finance.entity.PaymentPayOther;
import com.cku.oa.finance.service.PaymentPayOtherService;

/**
 * 代收代入Controller
 * @author lyy
 * @version 2016-08-16
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentPayOther")
public class PaymentPayOtherController extends BaseController {

	@Autowired
	private PaymentPayOtherService paymentPayOtherService;
	
	@ModelAttribute
	public PaymentPayOther get(@RequestParam(required=false) String id) {
		PaymentPayOther entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = paymentPayOtherService.get(id);
		}
		if (entity == null){
			entity = new PaymentPayOther();
		}
		return entity;
	}
	
	@RequiresPermissions("finance:paymentPayOther:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentPayOther paymentPayOther, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentPayOther> page = paymentPayOtherService.findPage(new Page<PaymentPayOther>(request, response), paymentPayOther); 
		model.addAttribute("page", page);
		return "oa/finance/paymentPayOtherList";
	}

	@RequiresPermissions("finance:paymentPayOther:view")
	@RequestMapping(value = "form")
	public String form(PaymentPayOther paymentPayOther, Model model) {
		model.addAttribute("paymentPayOther", paymentPayOther);
		return "oa/finance/paymentPayOtherForm";
	}

	@RequiresPermissions("finance:paymentPayOther:add")
	@RequestMapping(value = "save")
	public String save(PaymentPayOther paymentPayOther, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentPayOther)){
			return form(paymentPayOther, model);
		}
		paymentPayOtherService.savePayOther(paymentPayOther);
		addMessage(redirectAttributes, "保存代收代入成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentPayOther/?repage";
	}
	
//	@RequiresPermissions("finance:paymentPayOther:edit")
//	@RequestMapping(value = "delete")
//	public String delete(PaymentPayOther paymentPayOther, RedirectAttributes redirectAttributes) {
//		paymentPayOtherService.delete(paymentPayOther);
//		addMessage(redirectAttributes, "删除代收代入成功");
//		return "redirect:"+Global.getAdminPath()+"/finance/paymentPayOther/?repage";
//	}

}