package com.cku.oa.finance.service;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.dao.PaymentChargingItemGroupDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentChargingItemGroup;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * OA订单录入组合收费项Service
 *
 * @author 赖广龙
 * @version 2017-06-23
 */
@Service
@Transactional(readOnly = true)
public class PaymentChargingItemGroupService
		extends CrudService<PaymentChargingItemGroupDao, PaymentChargingItemGroup> {

	public PaymentChargingItemGroup get(String id) {
		return super.get(id);
	}

	public List<PaymentChargingItemGroup> findList(PaymentChargingItemGroup paymentChargingItemGroup) {
		return super.findList(paymentChargingItemGroup);
	}

	public Page<PaymentChargingItemGroup> findPage(Page<PaymentChargingItemGroup> page,
			PaymentChargingItemGroup paymentChargingItemGroup) {
		return super.findPage(page, paymentChargingItemGroup);
	}

	@Transactional(readOnly = false)
	public void save(PaymentChargingItemGroup paymentChargingItemGroup) {
		super.save(paymentChargingItemGroup);
	}

	@Transactional(readOnly = false)
	public void delete(PaymentChargingItemGroup paymentChargingItemGroup) {
		super.delete(paymentChargingItemGroup);
	}

	public List<PaymentChargingItem> getPaymentChargingItemGroupList() {
		List<PaymentChargingItem> chargingItems = Lists.newArrayList();
		List<PaymentChargingItemGroup> paymentChargingItemGroupList = dao.findList(new PaymentChargingItemGroup());
		for (PaymentChargingItemGroup paymentChargingItemGroup : paymentChargingItemGroupList) {
			PaymentChargingItem item = new PaymentChargingItem();
			item.setId("yw" + paymentChargingItemGroup.getId());
			item.setName(paymentChargingItemGroup.getName());
			item.setPrice(paymentChargingItemGroup.getPrice());
			chargingItems.add(item);
		}
		return chargingItems;
	}

	public List<PaymentChargingItem> findPaymentChargingItemById(String groupId) {
		return dao.findPaymentChargingItemById(groupId);
	}

	/***
	 * 根据groupId 模糊查询
	 * 
	 * @param groupId
	 * @return
	 */
	public List<PaymentChargingItem> findPaymentChargingItemFuzzy(String fuzzyGroupId) {
		return dao.findPaymentChargingItemFuzzy(fuzzyGroupId);
	}

	public List<String> departmentList() {
		return dao.departmentList();
	}

	/**
	 * 根据分组ID查询收费项ID集合
	 * 
	 * @param groupId
	 * @return
	 */
	public List<String> getPaymentChargingItemIdsByPaymentChargingItemGroupId(String groupId) {
		return dao.getPaymentChargingItemIdsByPaymentChargingItemGroupId(groupId);
	}

	/**
	 * 根据分组ID查询收费项集合
	 * 
	 * @param groupId
	 * @return
	 */
	public List<PaymentChargingItem> getPaymentChargingItemsByPaymentChargingItemGroupId(String groupId) {
		return dao.getPaymentChargingItemsByPaymentChargingItemGroupId(groupId);
	}

}