package com.cku.oa.finance.service;
import com.cku.oa.constant.Constants;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.entity.ShowApplyDiscount;
import com.cku.oa.show.service.ShowApplyDiscountService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.statistics.service.SplitOrderService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;

/**
 * Created with IntelliJ IDEA. User: lyy Date: 2016/7/26 Time: 16:33
 */
@Service
@Transactional(readOnly = true)
public class DeductCostService extends CrudService<PaymentRecordDao, PaymentRecord> {
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	public RemindService remindService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public PaymentChargingItemService paymentChargingItemService;
	@Autowired
	public ShowApplyDao showApplyDao;
	@Autowired
	public ShowApplyService showApplyService;
	@Autowired
	public MainShowsDao mainShowsDao;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private SplitOrderService splitOrderService;
	@Autowired
	public KennelDao kennelDao;
	@Autowired
	public GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private ShowApplyDiscountService showApplyDiscountService;

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	/**
	 * 会员扣费
	 *
	 * @param paymentRecord 2bdd35b2a0c7455aa14f7c3fe559e593
	 */
	@Transactional(readOnly = false)
	public void deductCost(PaymentRecord paymentRecord) throws ZAException {
		paymentRecord.setRemarks(paymentRecord.getPaymentRemarks());
		Member member = memberDao.getByMemberCode(paymentRecord.getMemberCode());
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(paymentRecord.getChargingItemId());
		// 会员冻结校验
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "会员已冻结！");
		}
		// 俱乐部年费权限标识
		boolean hasPermission = SecurityUtils.getSubject().isPermitted("finance:deductCost:clubYear");
		// 构造基础数据
		buildPaymentRecord(paymentRecord);
		// 新增提现收费项,id为256，直接扣账户余额，扣费金额取页面传来的金额
		// 设置注册地址
		paymentRecordService.setRecordRegister(paymentRecord);
		if ("256".equals(paymentChargingItem.getId())) {
			paymentRecord.setPrice(paymentChargingItem.getPrice());
			memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
					paymentRecord.getRunningNumber());
			super.save(paymentRecord);
		} else if ("601".equals(paymentChargingItem.getId()) || "602".equals(paymentChargingItem.getId())) {
			// 有特殊扣费权限并且扣俱乐部年费的可自定义价格
			if (hasPermission) {
				paymentRecord.setPaymentAmount(paymentRecord.getPaymentAmount());
			} else {
				paymentRecord.setPaymentAmount(paymentRecord.getPrice());
			}
			memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
					paymentRecord.getRunningNumber());
			super.save(paymentRecord);
		} else if ("2bdd35b2a0c7455aa14f7c3fe559e593".equals(paymentChargingItem.getId())) {
			if (StringUtils.isEmpty(paymentRecord.getPaymentRemarks())) {
				throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "备注请填写洗护师证书号!");
			}

			GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao
					.getByCertificateCode(paymentRecord.getPaymentRemarks(), "4");
			if (groomerQualificationCertificate == null || !paymentRecord.getMemberCode().equals(groomerQualificationCertificate.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "没有匹配该会员的洗护师证书，请重新填写洗护师证书号!");
			}
			// 修改为纸质打印
			groomerQualificationCertificate.setPaper("0");
			groomerQualificationCertificateDao.update(groomerQualificationCertificate);
			memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
					paymentRecord.getRunningNumber());
			super.save(paymentRecord);
		} else {
			// 排除特殊收费项 进行常规扣费操作
			//收费项-报名退费手续费
			final String showRefundHandleItem = "b196aba404ce4ff2b331d32ba1e3152f";
			if (paymentChargingItem.getName().indexOf("退费") > 0
					&& !showRefundHandleItem.equals(paymentChargingItem.getId())) {
				//退费且不是报名退费手续费
				// 退费不用校验会员是否激活
				paymentRecord.setPrice(paymentChargingItem.getPrice());
				memberService.memberRecharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
						paymentRecord.getPaymentTime(), paymentRecord.getRunningNumber());
				paymentRecord.setPrice("-" + paymentRecord.getPrice());
				paymentRecord.setPaymentAmount("-" + paymentRecord.getPaymentAmount());
				paymentRecord.setPaymentWay("cku.org");
				super.save(paymentRecord);
			} else {
				// 非退费
				// 部门扣费校验
				if ("100000004".equals(paymentRecord.getCode().trim())) {
					// 美容部的扣费 不要校验有效无效
					paymentRecord.setPaymentAmount(paymentRecord.getPrice());
					memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
							paymentRecord.getRunningNumber());
					super.save(paymentRecord);
				} else if (StringUtils.isBlank(paymentRecord.getCode())) {
					// 财务部的扣费 也不校验
					memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
							paymentRecord.getRunningNumber());
					super.save(paymentRecord);
				} else if (MemberUtil.isActiveMember(member)) {
					// 其他部门必须会员有效才可扣费
					paymentRecord.setPaymentAmount(paymentChargingItem.getPrice());
					memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
							paymentRecord.getRunningNumber());
					super.save(paymentRecord);
				} else {
					throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "会员无效！");
				}
			}
		}
		// 流水拆分
		splitOrderService.initSplit(paymentRecord.getRunningNumber());
	}

	/**
	 * 构造基础数据
	 *
	 * @param paymentRecord
	 * @throws ZAException
	 * @作者 chaixueteng
	 */
	public void buildPaymentRecord(PaymentRecord paymentRecord) {
		String runningNum = SysCodeUtil.getPayRunningNumber();
		paymentRecord.setRunningNumber(runningNum);
		paymentRecord.setChargingItemNum(1);
		paymentRecord.setCreateDate(new Date());
		paymentRecord.setPaymentTime(new Date());
		paymentRecord.setPaymentState("2");
		paymentRecord.setPaymentWay("25");// 默认余额支付
	}

	/**
	 * 合并付款功能
	 *
	 * @param paymentRecords 所有需要合并付款的项目
	 * @throws ZAException
	 */
	@Transactional(readOnly = false)
	public void mergePaySave(List<PaymentRecord> paymentRecords) throws ZAException {
		for (PaymentRecord paymentRecord : paymentRecords) {
			paySave(paymentRecord);
		}
	}

	/**
	 * 公用支付方法
	 *
	 * @param paymentRecord
	 * @throws ZAException
	 */
	@Transactional(readOnly = false)
	public synchronized void paySave(PaymentRecord paymentRecord) throws ZAException {
		SysContext sysContext = new SysContext("1", "0", "0");
		Member member = memberDao.getByMemberCode(paymentRecord.getMemberCode());
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "会员已冻结！");
		}
		// 公共扣费是否有修改价格权限
		boolean hasPermission = SecurityUtils.getSubject().isPermitted("finance:deductCost:other");
		if (!paymentRecord.getPrice().equals(paymentRecord.getPaymentAmount()) && !hasPermission) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "无修改价格扣费权限！");
		}
		// 报名服务费、赛事报名费 判断犬主名下犬只有没有未提交订单
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentRecord.getChargingItemId());
		if (paymentChargingItem.getShortName().startsWith("show_apply@phoneApplyFee")
				|| paymentChargingItem.getShortName().startsWith("show_apply@fee")) {
			//如果是后台报名且犬主人是外籍会员则不校验未缴费订单
			ShowApply showApply = showApplyService.get(paymentRecord.getBusinessId());
			Member dogOwner;
			if (paymentRecord.getMemberCode().equals(showApply.getDogOwnerMemberCode())) {
				dogOwner = member;
			} else {
				dogOwner = memberService.getByMemberCode(showApply.getDogOwnerMemberCode());
			}
			if (!showApply.getApplyCode().startsWith("BM")
					|| (showApply.getApplyCode().startsWith("BM") && !"foreign".equals(dogOwner.getMemberType()))) {
				if (showApplyService.isUnpaidShowApplyById(paymentRecord.getBusinessId())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前犬主名下犬只已有未缴费的赛事订单，请先处理。");
				}
			}
		}

		sysContext.payment(sysContext,
				"会员号：" + paymentRecord.getMemberCode() + "。业务表id:" + paymentRecord.getBusinessId() + "。项目id:"
						+ paymentRecord.getChargingItemId(),
				paymentRecord.getMemberCode(), "payment_record", paymentRecord.getId(),
				paymentRecord.getRunningNumber(), (str) -> {
					// TODO 流水号生成策略。3种
					String runningNum = SysCodeUtil.getPayRunningNumber();
					memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
							runningNum);
					Date paymentTime = new Date();
					paymentRecord.setPaymentTime(paymentTime);
					String sql = bulidSql(member, paymentChargingItem.getShortName(), runningNum, paymentRecord);

					if (sql.contains(";")) {
						Arrays.asList(sql.split(";")).stream().filter(item -> StringUtils.isNotBlank(item))
								.forEach(item -> {
									int j = dao.changePaymentState(item);
									if (j <= 0) {
										throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE,
												"修改业务状态失败！");
									}
								});
					} else {
						int j = dao.changePaymentState(sql);
						if (j <= 0) {
							throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
						}
					}
					// 判断是否是犬只参赛费（××合办）收费项，如果是在流水表里添加赛事业务模式标示
					String chargingItemName = paymentChargingItem.getName();
					if (chargingItemName.indexOf("犬只参赛费") > -1 && chargingItemName.indexOf("合办") > -1) {
						ShowApply showApply = showApplyDao.get(paymentRecord.getBusinessId());
						MainShows mainShows = mainShowsDao.get(showApply.getMainShowId());
						if ("1".equals(mainShows.getBusinessModelFlag())) {
							paymentRecord.setShowBusinessModelFlag("1");
						}

					}
					paymentRecord.setPaymentWay("cku.org");
					paymentRecord.setPaymentState("2");
					paymentRecord.setRunningNumber(runningNum);

					paymentRecordService.setRecordRegister(paymentRecord);
					super.save(paymentRecord);
					splitOrderService.initSplit(runningNum);
					//增加会员变动记录
					if (memberService.isMemberKennelChargingItem(paymentChargingItem.getShortName())) {
						memberService.saveMemberRecord(paymentRecord.getRunningNumber(), member, paymentRecord.getCreateBy());
					}
					//更新会员表第一次缴费时间
					memberService.updateFirstPaymentTime(runningNum, member);
					//如果是赛事满减 需要填入订单号
					ShowApplyDiscount showApplyDiscount = showApplyDiscountService.getByShowApplyId(paymentRecord.getBusinessId());
					if (paymentChargingItem.getShortName().startsWith("show_apply@fee")
							&& showApplyDiscount != null) {
						showApplyDiscount.setRunningNumber(runningNum);
						showApplyDiscount.preUpdate();
						showApplyDiscountService.save(showApplyDiscount);
					}
				});
	}

	;

	public static final int PAYMENT_SUCCESSS = 2;
	public static final String MEMBER_PAY = "";
	public static final String PHONEAPPLYFEE = "show_apply@phoneApplyFee";
	public static final String GROOMERRLYFEE = "sys_member@GR";
	public static final String GROOMERFLYFEE = "sys_member@GF";
	public static final String MEMER_FOREIGN = "sys_member@WJ";// 外籍会员费
	public static final String MEMER_BASIC = "sys_member@B";// 基础会员费
	public static final String MEMBER_PROFESSIONAL = "sys_member@P";// 专业会员费
	public static final String MEMBER_PROFESSIONAL_FIRST = "sys_member@F";// 专业会员的新注册费
	public static final String MEMBER_PROFESSIONAL_BREED = "sys_member@PB";// 繁育专业会员费
	public static final String MEMBER_PROFESSIONAL_BREED_FIRST = "sys_member@PBF";// 繁育专业会员的新注册费
	public static final String MEMBER_BASIC_TO_PROFESSIONAL = "sys_member@BTP";// 普通会员升级为专业会员
	public static final String MEMBER_DG = "sys_member@D";// 犬运动会员续费
	public static final String BIRTH_CERTIFICATE_CHANGEINFO = "dog_birth_certificate@changeInfo";// 出生证明修改毛色或芯片
	public static final String KENNEL_ZC = "kennel@ZC";// 犬舍名称初次注册费
	public static final String KENNEL_ND = "kennel@ND";// 犬舍年度登记费
	public static final String KENNEL_YJ = "kennel@YJ";// 永久犬舍名称登记费
	public static final String CHAMPION_LOGIN = "show_champion_login";// 冠军登录
	public static final String KENNELALLIANCE_FEE = "kennel_alliance@";// 犬舍联盟费用
	private static final String DOG_CHIP = "dog_chip";// 新生犬登记
	private static final String SHOW_APPLY = "show_apply@fee";// 新生犬登记
	private static final String KENNEL_CALCULATION = "kennel@calculation"; // 犬舍保留费

	/**
	 * CKU美容资格证书A级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_A = "groomer_qualification_certificate@A";
	/**
	 * CKU美容资格证书B级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_B = "groomer_qualification_certificate@B";

	/**
	 * CKU美容资格证书C级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_C = "groomer_qualification_certificate@C";

	/**
	 * CKU美容资格证书教师级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_MASTER = "groomer_qualification_certificate@M";

	/**
	 * Fci美容资格证书A级
	 */
	private static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_A = "fci_groomer_qualification_certificate@A";

	/**
	 * Fci美容资格证书B级
	 */
	private static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_B = "fci_groomer_qualification_certificate@B";

	/**
	 * Fci美容资格证书C级
	 */
	private static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_C = "fci_groomer_qualification_certificate@C";

	/**
	 * Fci美容资格证书教师级级
	 */
	private static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_MASTER = "fci_groomer_qualification_certificate@M";

	/**
	 * CKU美容资格证书教师级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_PET = "groomer_qualification_certificate@PET";

	/**
	 * CKU美容资格证书教师级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_PET_DOLD = "groomer_qualification_certificate@PET_GOLD";

	public String bulidSql(Member member, String shortName, String runningNum, PaymentRecord paymentRecord) {
		logger.info("-------------收费项---------- : {}", shortName);
		StringBuffer buffer = new StringBuffer(128);
		String tableName = shortName.split("@")[0];
		if (DOG_CHIP.equals(tableName)) {
			// 新生犬登记的所有扣费都是直接标记为已付费，已审核
			buffer.append(
					"UPDATE dog_chip SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE id = '")
					.append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.startsWith(PHONEAPPLYFEE)) {
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(-1, "会员无效！");
			}
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("phone_apply_flag = 1 ,payment_amount ='")
					.append(paymentRecord.getPaymentAmount()).append("',phone_apply_running_number= '")
					.append(runningNum).append("' ").append("WHERE id='").append(paymentRecord.getBusinessId())
					.append("'");
		} else if (shortName.equals(GROOMERRLYFEE)) {// 美容师预备会员
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerRenewSql(buffer, paymentRecord.getBusinessId(), member);
		} else if (shortName.equals(GROOMERFLYFEE)) {// 美容师正式会员
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerRenewSql(buffer, paymentRecord.getBusinessId(), member);
		} else if (shortName.equals(MEMER_FOREIGN)) {// 外籍会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memerForeignSql(buffer, paymentRecord.getBusinessId(), member);
		} else if (shortName.equals(MEMER_BASIC)) {// 基础会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memerBasicSql(buffer, paymentRecord.getBusinessId(), member);
			// if(!MemberUtil.isBasicMember(member)){
			// throw new ZAException(-1,"会员不是基础会员不能缴费！");
			// }
			// String date = "";
			// if(member.getMemberEndDate()!=null &&
			// member.getMemberEndDate().getTime()>System.currentTimeMillis()){
			// date = DateUtils.get1YearLater(member.getMemberEndDate());
			// buffer.append("UPDATE ").append(tableName).append(" SET
			// ").append("member_end_date = '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }else{
			// Date current = new Date();//当前日期
			// date = DateUtils.get1YearLater(current);
			// buffer.append("UPDATE ").append(tableName).append(" SET
			// ").append("member_end_date = '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }
			//
			// RemindService remindService =
			// (RemindService)SpringContextHolder.getBean("remindService");
			// String s[] = date.split("-");
			// String d = s[0]+"年"+s[1]+"月"+s[2]+"日";
			// StringBuffer sb = new StringBuffer();
			// sb.append("您的基础会员缴费业务办理成功，会员有效期").append(d).append("。");
			// remindService.addRemind(sb.toString(),member.getMemberCode());
			// System.out.println(sb);

		} else if (shortName.equals(MEMBER_PROFESSIONAL)) {// 专业会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalSql(buffer, paymentRecord.getBusinessId(), member);
			// String date = "";
			// if(MemberUtil.isBasicMember(member)){
			// throw new ZAException(-1,"会员不是专业会员不能缴费！");
			// }
			//
			// //根据当前日期获取用户的日期，如果用户过期没超过一个月，则在原来的时间上续费1年
			// //如果用户过期超过一个月，则一方面需要缴纳初次登记费，另一方面日期要按缴费当天计算
			// if(member.getMemberEndDate() == null){
			// Date current = new Date();//当前日期
			// date = DateUtils.get1YearLater(current);
			// }else{
			// Date endDate = member.getMemberEndDate();
			// Calendar calendar = Calendar.getInstance();//日历对象
			// calendar.setTime(endDate);//设置当前日期
			// calendar.add(Calendar.MONTH, 1);//月份+1
			// if(calendar.getTime().getTime() > System.currentTimeMillis()){
			// //用户过期小于一个月，可以直接补交会员费
			// date = DateUtils.get1YearLater(member.getMemberEndDate());
			// }else{
			// date = DateUtils.get1YearLater(new Date());
			// }
			//
			// buffer.append("UPDATE ").append(tableName).append(" SET
			// ").append("member_end_date = '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }
			//
			// RemindService remindService =
			// (RemindService)SpringContextHolder.getBean("remindService");
			// String s[] = date.split("-");
			// String d = s[0]+"年"+s[1]+"月"+s[2]+"日";
			// StringBuffer sb = new StringBuffer();
			// sb.append("您的专业会员缴费业务办理成功，会员有效期").append(d).append("。");
			// remindService.addRemind(sb.toString(),member.getMemberCode());
			// System.out.println(sb);

		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED)) { // 繁育专业会员续费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedSql(buffer, member.getId());
		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED_FIRST)) { // 繁育专业会员注册费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedSql(buffer, member.getId(), member.getMemberCode());
		} else if (shortName.equals(MEMBER_BASIC_TO_PROFESSIONAL)) {// 基础会员升级为专业会员
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberBasicToProfessionalSql(buffer, paymentRecord.getBusinessId(), member.getMemberCode());
			// //会员升级为专业会员的时候需要重新缴费，重新计算会员的时间
			// //设置会员的截止时间为今天。
			// SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
			// String date = format.format(new Date());
			// buffer.append("UPDATE ").append(tableName).append(" SET
			// ").append("member_type = '").append(MemberType.professional.toString())
			// .append("', member_end_date = '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			//
			// RemindService remindService =
			// (RemindService)SpringContextHolder.getBean("remindService");
			// remindService.addRemind("您的基础会员升级为专业会员业务办理成功，恭喜您成为cku专业会员。",member.getMemberCode());
		} else if (shortName.equals(MEMBER_PROFESSIONAL_FIRST)) {// 专业会员初次注册费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalFirstSql(buffer, paymentRecord.getBusinessId());
			// SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
			// String date = format.format(new Date());
			// buffer.append("UPDATE ").append(tableName).append(" SET
			// ").append("member_type = '").append(MemberType.professional.toString())
			// .append("', member_end_date = '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.equals(MEMBER_DG)) {
			if (member.getDgEndDate() != null && member.getDgEndDate().getTime() > System.currentTimeMillis()) {
				String date = DateUtils.get1YearLater(member.getMemberEndDate());
				buffer.append("UPDATE ").append(tableName).append(" SET ").append("dg_end_date = '").append(date)
						.append("',dg_member_type = 1 ").append("WHERE id='").append(paymentRecord.getBusinessId())
						.append("'");
			} else {
				Date current = new Date();// 当前日期
				String date = DateUtils.get1YearLater(current);
				buffer.append("UPDATE ").append(tableName).append(" SET ").append("dg_end_date = '").append(date)
						.append("',dg_member_type = 1 ").append("WHERE id='").append(paymentRecord.getBusinessId())
						.append("'");
			}
		} else if (shortName.equals(BIRTH_CERTIFICATE_CHANGEINFO)) {
			// 出生纸毛色变更传入的businessId参数为businessId@colorFlag格式，需要取出colorFlag后重置businessId
			String businessId = paymentRecord.getBusinessId();
			String[] split = businessId.split("@");
			String colorFlag = split[1];
			paymentRecord.setBusinessId(split[0]);
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(paymentRecord.getBusinessId());
			String identificationFlag = null;
			if (split.length > 2) {
				identificationFlag = split[2];
				dogBirthCertificateService.updateDogChipChange(dogBirthCertificate, identificationFlag);
				// 更新犬表芯片号
				dogBirthCertificateService.updateDogChip(dogBirthCertificate, identificationFlag);
			}
			// //更新毛色
			buffer.append("UPDATE dog_birth_certificate SET color_flag = '" + colorFlag + "'");
			if (identificationFlag != null) {
				// 芯片号查重
				dogBirthCertificate.setIdentificationFlag(identificationFlag);
				dogBirthCertificateService.validateIdentificationFlag(dogBirthCertificate);
				buffer.append(",identification_flag = '" + identificationFlag + "'");

				// 判断是否到11月11号
				Date createDate = dogBirthCertificate.getCreateDate();
				Date date11 = com.cku.util.DateUtils.strToDateLong("2018-11-11 00:00:00");
				if (createDate.getTime() - date11.getTime() > 0) {
					Map<String, String> map = dogBirthCertificateService.createCabCode(paymentRecord.getBusinessId(),
							identificationFlag);
					String cabRegisterCode = map.get("cabRegisterCode");
					String cabPassport = map.get("cabPassport");

					buffer.append(",cab_passport = '" + cabPassport + "'");
					buffer.append(",cab_register_code = '" + cabRegisterCode + "'");
				}
			}

			buffer.append(" WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.equals(KENNEL_ZC)) {
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelFirstSql(buffer, paymentRecord.getBusinessId());
		} else if (shortName.equals(KENNEL_ND)) {
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelYearSql(buffer, paymentRecord.getBusinessId());
			// Kennel kennel = kennelService.get(paymentRecord.getBusinessId());
			// String date = "";
			// if(kennel.getEndTime()!=null &&
			// kennel.getEndTime().getTime()>System.currentTimeMillis()){//冠：kennel.getEndTime()!=null可以不写
			// date = DateUtils.get1YearLater(kennel.getEndTime());
			// buffer.append("UPDATE ").append(tableName).append(" SET ").append("end_time =
			// '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }else{
			// Date current = new Date();//当前日期
			// date = DateUtils.get1YearLater(current);
			// buffer.append("UPDATE ").append(tableName).append(" SET ").append("end_time =
			// '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }
			//
			// RemindService remindService =
			// (RemindService)SpringContextHolder.getBean("remindService");
			// String s[] = date.split("-");
			// String d = s[0]+"年"+s[1]+"月"+s[2]+"日";
			// StringBuffer sb = new StringBuffer();
			// sb.append("您的犬舍缴费业务办理成功，犬舍有效期").append(d).append("。");
			// remindService.addRemind(sb.toString(),kennel.getMemberCode());
			// System.out.println(sb);

		} else if (shortName.equals(KENNEL_YJ)) {
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelPermanentSql(buffer, paymentRecord.getBusinessId());
		} else if (shortName.equals(KENNEL_CALCULATION)) {
			// 犬舍保留费 2017-02-01 实行
			// 取消犬舍核算 2019年2月25日10:01:11
			// KennelService kennelService =
			// (KennelService)SpringContextHolder.getBean("kennelService");
			// kennelService.calculteSql(buffer, paymentRecord.getBusinessId());
			// Kennel kennel = kennelService.get(paymentRecord.getBusinessId());
			// if(kennel.getEndTime()!=null &&
			// kennel.getEndTime().getTime()>System.currentTimeMillis()){//冠：kennel.getEndTime()!=null可以不写
			// SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
			// Calendar calendar = Calendar.getInstance();//日历对象
			// calendar.setTime(kennel.getEndTime());
			// calendar.add(Calendar.YEAR, 100);
			// String date = format.format(calendar.getTime());
			// buffer.append("UPDATE ").append(tableName).append(" SET ").append("end_time =
			// '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }else{
			// SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
			// Calendar calendar = Calendar.getInstance();//日历对象
			// calendar.setTime(new Date());
			// calendar.add(Calendar.YEAR, 100);
			// String date = format.format(calendar.getTime());
			// buffer.append("UPDATE ").append(tableName).append(" SET ").append("end_time =
			// '").append(date).append("' ")
			// .append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
			// }
			//
			// RemindService remindService =
			// (RemindService)SpringContextHolder.getBean("remindService");
			// StringBuffer sb = new StringBuffer();
			// sb.append("您的犬舍缴费业务办理成功。");
			// remindService.addRemind(sb.toString(),kennel.getMemberCode());
		} else if (tableName.equals(CHAMPION_LOGIN)) {
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(-1, "会员无效！");
			}
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ")
					.append(PAYMENT_SUCCESSS).append(" ,").append("running_number = '").append(runningNum).append("',")
					.append("payment_membership_code = '").append(member.getMemberCode()).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(paymentRecord.getPaymentTime()))
					.append("'").append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.startsWith(KENNELALLIANCE_FEE)) {
			// 犬舍联盟费用，有kennel_alliance@6000和kennel_alliance@12000
			String fee = shortName.split("@")[1];
			String ku_flag = "";
			if ("12000".equals(fee)) {
				ku_flag = "1";
			} else if ("6000".equals(fee)) {
				ku_flag = "2";
			}
			// 更新犬舍联盟表的有效截至时间为本年年底
			buffer.append("UPDATE kennel_alliance set end_date ='").append(DateUtils.getYear() + "-12-31")
					.append("' WHERE id = '").append(paymentRecord.getBusinessId()).append("'");
			// 更新会员表的犬舍联盟套餐和犬舍联盟会员有效结束时间为本年年底
			if (memberDao.updateKennelAlliance(member.getMemberCode(), ku_flag) <= 0) {
				throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改会员表犬舍联盟状态失败！");
			}
		} else if (shortName.startsWith(SHOW_APPLY)) {
			// 如果是报名费，判断血统证书号是否是CKU开头，如果不是，不用校验会员是否有效
			ShowApply showApply = showApplyDao.get(paymentRecord.getBusinessId());
			if (showApply.getPedigreeCertified().toUpperCase().startsWith("CKU")
					&& !MemberUtil.isActiveMember(member)) {
				throw new ZAException(-1, "会员无效！");
			}
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ")
					.append(PAYMENT_SUCCESSS).append(" ,").append("running_number = '").append(runningNum).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(paymentRecord.getPaymentTime()))
					.append("',");
			if (StringUtils.isNotBlank(showApply.getPaymentAmount())) {
				buffer.append("payment_amount = CONCAT(payment_amount,'+").append(paymentRecord.getPaymentAmount())
						.append("')");
			} else {
				buffer.append("payment_amount = '").append(paymentRecord.getPaymentAmount()).append("'");
			}
			buffer.append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.startsWith("groomer_qualification_certificate")) {
			logger.info("-------------收费项---------- : {}", JSONObjectUtils.toJsonString(shortName));
			switch (shortName) {
				case GROOMER_QUALIFICATION_CERTIFICATE_A:
				case GROOMER_QUALIFICATION_CERTIFICATE_B:
				case GROOMER_QUALIFICATION_CERTIFICATE_C:
				case GROOMER_QUALIFICATION_CERTIFICATE_MASTER:
					GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao
							.get(paymentRecord.getBusinessId());
					logger.info("美容资格证书支付回调接口，查询资格证书信息 : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
					FciGroomerQualificationCertificate fciGroomerQualificationCertificate = this.generateFciCertificate(groomerQualificationCertificate);
					fciGroomerQualificationCertificateService.save(fciGroomerQualificationCertificate);
					break;
			}
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ")
					.append(PAYMENT_SUCCESSS).append(" ,").append("running_number = '").append(runningNum).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(paymentRecord.getPaymentTime()))
					.append("'").append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else if (shortName.startsWith("fci_groomer_qualification_certificate")) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ")
					.append(PAYMENT_SUCCESSS).append(" ,").append("running_number = '").append(runningNum).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(paymentRecord.getPaymentTime()))
					.append("'").append(",take_certificate_date = now(), issue_date = now(), certificate_state = '1', update_date = now()")
					.append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		} else {
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(-1, "会员无效！");
			}
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ")
					.append(PAYMENT_SUCCESSS).append(" ,").append("running_number = '").append(runningNum).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(paymentRecord.getPaymentTime()))
					.append("'").append("WHERE id='").append(paymentRecord.getBusinessId()).append("'");
		}

		return buffer.toString();
	}

	;

	/**
	 * 美容缴费成功发送消息
	 *
	 * @Author chaixueteng
	 * @2016年9月1日下午7:22:13
	 */
	public void sendGroomerMsg(String memberCode, String date) {
		Date parseDate = DateUtils.parseDate(date);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy年M月d日");
		remindService.addRemind("您CKU美容师的会员年费缴纳成功，会员有效期至" + sdf.format(parseDate) + "。", memberCode);
		System.out.println("您CKU美容师的会员年费缴纳成功，会员有效期至" + sdf.format(parseDate) + "。");
	}

	/**
	 * @description: 定时任务执行方法，每天凌晨3点，过期的会员进行续费
	 * @author: laiguanglong
	 * @date: 2016年10月31日 下午2:48:26
	 */
	@Transactional(readOnly = false)
	public int aotoRenew() {
		// 会员续费，扣费项为一个的
		int countOne = renewOneItem();
		// 会员续费，扣费项为二个的
		int countTwo = renewTwoItem();
		return countOne + countTwo;
	}

	/**
	 * @description: 会员续费，扣费项为一个的
	 * @author: laiguanglong
	 * @date: 2016年12月1日 上午11:32:12
	 */
	private int renewOneItem() {
		int count = 0;
		// 1获取过期会员，基础会员，专业会员过期一个月内的，一个收费项的
		List<Member> memberList = memberDao.getExpireMemberOneMonthIn();
		// 2续费
		for (Member member : memberList) {
			String chargingItemId = "";
			if ("basic".equals(member.getMemberType())) {
				chargingItemId = "1";
			} else if ("professional".equals(member.getMemberType()) && "0".equals(member.getRegisterFlag())) {
				chargingItemId = "3";
			} else if ("professional".equals(member.getMemberType()) && "1".equals(member.getRegisterFlag())) {
				chargingItemId = "99901";
				// 判断犬舍过期时间和会员过期时间时候相等
				Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
				if (member.getMemberEndDate() != null && kennel.getEndTime() != null) {
					if (!kennel.getEndTime().equals(member.getMemberEndDate())) {
						continue;
					}
				}
			} else {
				continue;
			}
			PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(chargingItemId);
			if (Double.parseDouble(member.getAccountBalance()) < Double.parseDouble(paymentChargingItem.getPrice())) {
				continue;
			}
			PaymentRecord paymentRecord = new PaymentRecord();
			paymentRecord.setChargingItemId(paymentChargingItem.getId());
			paymentRecord.setPrice(paymentChargingItem.getPrice());
			paymentRecord.setPaymentAmount(paymentChargingItem.getPrice());
			paymentRecord.setMemberCode(member.getMemberCode());
			paymentRecord.setBusinessId(member.getId());
			paymentRecord.setChargingItemNum(1);
			paymentRecord.setPaymentRemarks("系统自动续会员费");
			try {
				paySave(paymentRecord);
				count++;
				logger.warn("会员" + member.getMemberCode() + "会员自动付费成功");
			} catch (Exception e) {
				logger.warn("会员" + member.getMemberCode() + "会员自动付费失败：" + e.getMessage());
				continue;
			}
		}
		return count;
	}

	/**
	 * @description: 会员续费，扣费项为二个的
	 * @author: laiguanglong
	 * @date: 2016年12月1日 上午11:38:46
	 */
	private int renewTwoItem() {
		int count = 0;
		// 1获取过期会员，专业会员过期一个月以上的，两个收费项
		List<Member> memberList = memberDao.getExpireMemberOneMonthOut();
		// 2续费
		for (Member member : memberList) {
			PaymentRecord r1 = new PaymentRecord();
			PaymentRecord r2 = new PaymentRecord();
			PaymentChargingItem item1 = null;
			PaymentChargingItem item2 = null;
			if ("0".equals(member.getRegisterFlag())) {
				item1 = paymentChargingItemDao.get("2");
				item2 = paymentChargingItemDao.get("3");
			} else {
				item1 = paymentChargingItemDao.get("99902");
				item2 = paymentChargingItemDao.get("99901");
				// 判断犬舍过期时间和会员过期时间时候相等
				Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
				if (member.getMemberEndDate() != null && kennel.getEndTime() != null) {
					if (!kennel.getEndTime().equals(member.getMemberEndDate())) {
						continue;
					}
				}
			}

			r1.setChargingItemId(item1.getId());
			r1.setPrice(item1.getPrice());
			r1.setPaymentAmount(item1.getPrice());
			r1.setMemberCode(member.getMemberCode());
			r1.setBusinessId(member.getId());
			r1.setChargingItemNum(1);
			r1.setPaymentRemarks("系统自动续会员费");

			r2.setChargingItemId(item2.getId());
			r2.setPrice(item2.getPrice());
			r2.setPaymentAmount(item2.getPrice());
			r2.setMemberCode(member.getMemberCode());
			r2.setBusinessId(member.getId());
			r2.setChargingItemNum(1);
			r2.setPaymentRemarks("系统自动续会员费");

			List<PaymentRecord> records = new ArrayList<PaymentRecord>();
			records.add(r1);
			records.add(r2);

			try {
				mergePaySave(records);
				count++;
				logger.warn("会员" + member.getMemberCode() + "会员自动付费成功");
			} catch (Exception e) {
				logger.warn("会员" + member.getMemberCode() + "会员自动付费失败：" + e.getMessage());
				continue;
			}
		}
		return count;
	}

	/**
	 * 封装fci证书信息
	 * @param groomerQualificationCertificate
	 * @return
	 */
	private FciGroomerQualificationCertificate generateFciCertificate(GroomerQualificationCertificate groomerQualificationCertificate){
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = new FciGroomerQualificationCertificate();
		fciGroomerQualificationCertificate.setMemberCode(groomerQualificationCertificate.getMemberCode());
		fciGroomerQualificationCertificate.setRegisterId(groomerQualificationCertificate.getRegisterId());
		fciGroomerQualificationCertificate.setTakeCertificateDate(null);
		fciGroomerQualificationCertificate.setIssueDate(null);
		fciGroomerQualificationCertificate.setPrintState(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setRunningNumber(null);
		fciGroomerQualificationCertificate.setPaymentState(Constants.STRING_NUM_ONE);
		fciGroomerQualificationCertificate.setPaymentTime(null);
		fciGroomerQualificationCertificate.setIsFree(Constants.STRING_NUM_ONE);
		fciGroomerQualificationCertificate.setCertificateState(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setPaper(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setFciCertificateCode("");
		fciGroomerQualificationCertificate.setCertificateId(groomerQualificationCertificate.getId());
		fciGroomerQualificationCertificate.setRemarks("");
		fciGroomerQualificationCertificate.setDelFlag(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setCertificateType("5");
		fciGroomerQualificationCertificate.setLevelEn(groomerQualificationCertificate.getLevelEn());
		fciGroomerQualificationCertificate.setReferee(groomerQualificationCertificate.getReviewer());
		return fciGroomerQualificationCertificate;
	}
}