/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.vo.PaymentRefundOrderVO;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 订单DAO接口
 *
 * @author lyy
 * @version 2016-08-04
 */
@MyBatisDao
public interface PaymentOrderDao extends CrudDao<PaymentOrder> {
	int locked(PaymentOrder paymentOrder);

	PaymentOrder getByorderCode(String orderCode);

	PaymentOrder getOrderByRunningNum(@Param("pedigreeNum") String pedigreeNum);
	
	List<PaymentOrder> getOrderByRunningNums(@Param("orderCodes") List<String> orderCodes);

	String getOrderCount(PaymentOrder paymentOrder);

	void updateBusinessRunningNo(@Param("runningNumber") String runningNumber, @Param("tableName") String tableName,
			@Param("id") String id); // 更新业务表的订单流水信息

	void updateDogBirthCertificateRunningNo(@Param("runningNumber") String runningNumber,
			@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode); // 更新出生证明业务表的订单流水信息

	void deleteOrderItem(@Param("tableName") String talbeName, @Param("id") String id);

	void deleteDogBirthCertificate(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	List<PaymentOrder> findUnpayedOrderByDate(@Param("date") Date date);

	int countByPaymentState(@Param("memberCode") String memberCode, @Param("paymentState") String paymentState);

	// //查询未支付的赛事订单
	// List<PaymentOrder> searchApply(@Param("memberCode")String
	// memberCod,@Param("businessTable")String businessTable);
	// 根据会员查询消费金额和支出金额
	Map<String, String> getConsumeMsgByMemberCode(@Param("memberCode") String memberCode);

	// 删除订单清空优惠劵使用标记位
	void clearCouponItem(@Param("tableName") String tableName, @Param("businessIds") String businessIds);

	// 删除订单清空参赛卷劵使用标记位
	void clearCouponShowItem(@Param("tableName") String tableName, @Param("businessIds") String businessIds,
			@Param("pedigreeCertified") String pedigreeCertified);

	List<PaymentOrder> dogChipInjectList(PaymentOrder order);

	List<PaymentRefundOrderVO> findRefundListPage(PaymentRefundOrderVO PaymentRefundOrderVO);

	List<String> getReviewState(@Param("table") String table, @Param("ids") List<String> ids);

	void saveBusinessState(@Param("table") String table, @Param("ids") Set<String> ids, @Param("vo") DogChip vo);

	List<PaymentOrder> findListCost(PaymentOrder paymentOrder);
	
	PaymentOrder getByIdForUpdate(@Param("id")String id);
	
	PaymentOrder getByBusinessOrderCode(@Param("businessOrderCode")String businessOrderCode);

	/**
	 * 通过表名
	 * @author yuanshuai
	 * @date 2023/6/19 17:38
	 */
    String findBusinessIdsByTableNameAndOrderCode(@Param("tableName")String tableName, @Param("orderCode")String orderCode);


	List<PaymentOrder> getByRunningNumbers(@Param("runningNumbers")List<String> runningNumbers);
	
	Boolean deleteDogChipTempMember( @Param("dogChipId") String dogChipId);
}