/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dogsporting.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬运动会员Entity
 * @author yuanshuai
 * @version 2021-06-15
 */
public class DogSportingMembers extends DataEntity<DogSportingMembers> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	@ExcelField(title="姓名*", align=2, sort=1)
	private String name;		// 会员姓名
	@ExcelField(title="会员类型*", align=2, sort=2)
	private String memberType;		// 会员类型（dog_sporting_member_type）
	@ExcelField(title="性别*", align=2, sort=3)
	private String gender;		// 性别（user_gender）
	@ExcelField(title="证件类型*", align=2, sort=5)
	private String cardType;		// 证件类型（user_card_type）
	@ExcelField(title="证件号*", align=2, sort=6)
	private String cardNo;		// 证件号
	@ExcelField(title="电话*", align=2, sort=4)
	private String mobile;		// 电话
	@ExcelField(title="省*", align=2, sort=7)
	private String province;		// 省
	@ExcelField(title="市*", align=2, sort=8)
	private String city;		// 市
	@ExcelField(title="区*", align=2, sort=9)
	private String area;		// 区
	@ExcelField(title="街道", align=2, sort=10)
	private String street;		// 街道
	private String idPhoto;		// 证件照

	@ExcelField(title = "备注", align = 2, sort = 11)
	private String remarks;

	
	public DogSportingMembers() {
		super();
	}

	public DogSportingMembers(String id){
		super(id);
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=64, message="会员姓名长度必须介于 1 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=1, message="会员类型长度必须介于 1 和 1 之间")
	public String getMemberType() {
		return memberType;
	}

	public void setMemberType(String memberType) {
		this.memberType = memberType;
	}
	
	@Length(min=1, max=8, message="性别长度必须介于 1 和 8 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}
	
	@Length(min=1, max=16, message="证件类型长度必须介于 1 和 16 之间")
	public String getCardType() {
		return cardType;
	}

	public void setCardType(String cardType) {
		this.cardType = cardType;
	}
	
	@Length(min=1, max=32, message="证件号长度必须介于 1 和 32 之间")
	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}
	
	@Length(min=1, max=32, message="电话长度必须介于 1 和 32 之间")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
	
	@Length(min=1, max=32, message="省长度必须介于 1 和 32 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}
	
	@Length(min=1, max=32, message="市长度必须介于 1 和 32 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}
	
	@Length(min=1, max=32, message="区长度必须介于 1 和 32 之间")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}
	
	@Length(min=0, max=50, message="街道长度必须介于 0 和 50 之间")
	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}
	
	@Length(min=0, max=64, message="证件照长度必须介于 0 和 64 之间")
	public String getIdPhoto() {
		return idPhoto;
	}

	public void setIdPhoto(String idPhoto) {
		this.idPhoto = idPhoto;
	}

	@Override
	@Length(min=0, max=500, message="备注长度必须介于 0 和 500 之间")
	public String getRemarks() {
		return remarks;
	}

	@Override
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
}