package com.cku.oa.dog.web;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DogVideoAppraisal;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.DogVideoAppraisalService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.service.OrgService;
import com.cku.restful.v1.dog.model.RestDogColorMark;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.service.DictService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping(value = "${adminPath}/dogvideoappraisal")
public class DogVideoAppraisalController extends BaseController {

	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;

	@Autowired
	private DogTypeService dogTypeService;

	@Autowired
	private DogColorMarkService dogColorMarkService;

	@Autowired
	private DictService dictService;

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private OrgService orgService;

	@ModelAttribute
	public DogVideoAppraisal get(@RequestParam(required = false) String id) {
		DogVideoAppraisal entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogVideoAppraisalService.get(id);
		}
		if (entity == null) {
			entity = new DogVideoAppraisal();
		}
		return entity;
	}

	@RequiresPermissions("dogVideoAppraisal:edit")
	@RequestMapping(value = "editExamine")
	public String editExamine(DogVideoAppraisal dogVideoAppraisal, Model model, RedirectAttributes redirectAttributes) {
		DogVideoAppraisal old = dogVideoAppraisalService.get(dogVideoAppraisal.getId());
		if(old.getDogBreed() != dogVideoAppraisal.getDogBreed()) {
			dogVideoAppraisal
					.setDogBreedCn(dogTypeService.getByDogBreedCode(dogVideoAppraisal.getDogBreed()).getBreedCnName());
		}
		if(old.getDogColor() != dogVideoAppraisal.getDogColor()) {
			dogVideoAppraisal.setDogColorCn(dogColorMarkService.getDogColorMarkCn(dogVideoAppraisal.getDogColor()));
		}
		dogVideoAppraisal.setAppraisalMember(UserUtils.getUser().getName());

		// 审核通过 修改订单状态
//		if("1".equals(dogVideoAppraisal.getReviewState())) {
//			paymentOrderDetailDao.updateBusinessRefund(dogVideoAppraisal.getId());
//		}
		dogVideoAppraisalService.save(dogVideoAppraisal);
		addMessage(redirectAttributes, "修改视频鉴定成功");
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/examineList?repage";
	}

	@RequiresPermissions("dogVideoAppraisal:examine:view")
	@RequestMapping(value = { "examineList", "" })
	public String examineList(DogVideoAppraisal dogVideoAppraisal, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		dogVideoAppraisal.setReviewState("5");
		dogVideoAppraisal.setPaymentState("2");

//		String beginCreateDate = request.getParameter("beginDate");
//		String endCreateDate = request.getParameter("endDate");
//		Calendar cal = Calendar.getInstance();
//		int year = cal.get(Calendar.YEAR);
//		int month = cal.get(Calendar.MONTH )+1;
//		int day = cal.get(Calendar.DAY_OF_MONTH);
//		if(beginCreateDate == null || beginCreateDate.equals("")) {
//			beginCreateDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
//        }
//		if(endCreateDate == null || endCreateDate.equals("")) {
//			endCreateDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
//		}
//		dogVideoAppraisal.setBeginCreateDate(beginCreateDate);
//		dogVideoAppraisal.setEndCreateDate(endCreateDate);

		Page<DogVideoAppraisal> page = dogVideoAppraisalService.findPage(new Page<DogVideoAppraisal>(request, response),
				dogVideoAppraisal);


		List<DogVideoAppraisal> list = page.getList();
		for(DogVideoAppraisal videoAppraisal:list){
			String runningNumber = videoAppraisal.getRunningNumber();
			if(StringUtils.isNotBlank(runningNumber)){
				//查询订单详情是否在退款中或审核通过  不可操作业务
				PaymentOrderDetail byOrderCode = paymentOrderDetailDao.getByOrderCode(runningNumber);
				if(byOrderCode!=null && ("3".equals(byOrderCode.getBusinessRefundState()) || "1".equals(byOrderCode.getBusinessRefundState()))){
					videoAppraisal.setBusinessRefundState(byOrderCode.getBusinessRefundState());
				}
			}
		}
//		model.addAttribute("beginCreateDate",DateUtils.parseDate(beginCreateDate));
//		model.addAttribute("endCreateDate",DateUtils.parseDate(endCreateDate));

		model.addAttribute("page", page);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("dogVideoAppraisal", dogVideoAppraisal);
		return "oa/dog/dogvideoappraisal/dogVideoAppraisalexamineList";
	}



	@RequiresPermissions("dogVideoAppraisal:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogVideoAppraisal dogVideoAppraisal, HttpServletRequest request, HttpServletResponse response,
			Model model) {

//		String beginCreateDate = request.getParameter("beginDate");
//		String endCreateDate = request.getParameter("endDate");
//		Calendar cal = Calendar.getInstance();
//		int year = cal.get(Calendar.YEAR);
//		int month = cal.get(Calendar.MONTH )+1;
//		int day = cal.get(Calendar.DAY_OF_MONTH);
//		if(beginCreateDate == null || beginCreateDate.equals("")) {
//			beginCreateDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 00:00:00";
//        }
//		if(endCreateDate == null || endCreateDate.equals("")) {
//			endCreateDate = String.valueOf(year)+"-"+String.valueOf(month)+"-"+String.valueOf(day)+" 23:59:59";
//		}
//		dogVideoAppraisal.setBeginCreateDate(beginCreateDate);
//		dogVideoAppraisal.setEndCreateDate(endCreateDate);
		Page<DogVideoAppraisal> page = dogVideoAppraisalService.findPage(new Page<DogVideoAppraisal>(request, response),
				dogVideoAppraisal);

		List<DogVideoAppraisal> list = page.getList();
		for(DogVideoAppraisal videoAppraisal:list){
			String runningNumber = videoAppraisal.getRunningNumber();
			if(StringUtils.isNotBlank(runningNumber)){
				//查询订单详情是否在退款中或审核通过  不可操作业务
				PaymentOrderDetail byOrderCode = paymentOrderDetailDao.getByOrderCode(runningNumber);
				if(byOrderCode!=null && ("3".equals(byOrderCode.getBusinessRefundState()) || "1".equals(byOrderCode.getBusinessRefundState()))){
					videoAppraisal.setBusinessRefundState(byOrderCode.getBusinessRefundState());
				}
			}
		}

//		model.addAttribute("beginCreateDate",DateUtils.parseDate(beginCreateDate));
//		model.addAttribute("endCreateDate",DateUtils.parseDate(endCreateDate));
		model.addAttribute("page", page);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("orgList", orgService.findAll());
		model.addAttribute("dogVideoAppraisal", dogVideoAppraisal);

		return "oa/dog/dogvideoappraisal/dogVideoAppraisalList";
	}

	@RequiresPermissions("dogVideoAppraisal:view")
	@RequestMapping(value = "form")
	public String form(DogVideoAppraisal dogVideoAppraisal, Model model) {
		DogVideoAppraisal info = dogVideoAppraisalService.getInfo(dogVideoAppraisal);
		model.addAttribute("info", info);
		return "oa/dog/dogvideoappraisal/dogVideoAppraisalForm";
	}

	@RequiresPermissions("dogVideoAppraisal:print")
	@RequestMapping(value = "print")
	public String print(DogVideoAppraisal dogVideoAppraisal, Model model,RedirectAttributes redirectAttributes) {

		try {
			return dogVideoAppraisalService.print(dogVideoAppraisal,model);
		} catch (ZAException e) {
			logger.warn("打印出错", e);
			addMessage(redirectAttributes, "打印出错:" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
	}

	@RequiresPermissions("dogVideoAppraisal:print")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogVideoAppraisal dogVideoAppraisal, Model model,RedirectAttributes redirectAttributes) {

		try {
			dogVideoAppraisalService.resetPrint(dogVideoAppraisal,model);
		} catch (ZAException e) {
			logger.warn("重置打印出错", e);
			addMessage(redirectAttributes, "重置打印出错:" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
	}



	@RequiresPermissions("dogVideoAppraisal:edit")
	@RequestMapping(value = "edit")
	public String save(DogVideoAppraisal dogVideoAppraisal, Model model, RedirectAttributes redirectAttributes) {
		DogVideoAppraisal old = dogVideoAppraisalService.get(dogVideoAppraisal.getId());
		if(old.getDogBreed() != dogVideoAppraisal.getDogBreed()) {
			dogVideoAppraisal
					.setDogBreedCn(dogTypeService.getByDogBreedCode(dogVideoAppraisal.getDogBreed()).getBreedCnName());
		}
		if(old.getDogColor() != dogVideoAppraisal.getDogColor()) {
			dogVideoAppraisal.setDogColorCn(dogColorMarkService.getDogColorMarkCn(dogVideoAppraisal.getDogColor()));
		}
		dogVideoAppraisalService.save(dogVideoAppraisal);
		addMessage(redirectAttributes, "修改视频鉴定成功");
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
	}



	@RequiresPermissions("dogVideoAppraisal:view")
	@RequestMapping(value = "reviewStatePage")
	public String reviewStatePage(DogVideoAppraisal dogVideoAppraisal, Model model) {
		DogVideoAppraisal info = dogVideoAppraisalService.getInfo(dogVideoAppraisal);
		info.setAppraisalMember(UserUtils.getUser().getLoginName());
		model.addAttribute("info", info);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		// 查询颜色
		List<RestDogColorMark> list = new ArrayList<RestDogColorMark>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogVideoAppraisal.getDogBreed());

		if(!StringUtils.isEmpty(dogType.getDogColor()) ) {
			for (String dogColor : dogType.getDogColor().split(",")) {
				DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogColor);
				if (dogColorMark != null) {
					RestDogColorMark vo = new RestDogColorMark();
					BeanUtil.copyProperties(vo, dogColorMark, "yyyy-MM-dd");
					list.add(vo);
				}
			}
		}else {
			List<DogColorMark> colors = dogColorMarkService.findList(new DogColorMark());
			for(DogColorMark color: colors) {
				RestDogColorMark vo = new RestDogColorMark();
				BeanUtil.copyProperties(vo, color, "yyyy-MM-dd");
				list.add(vo);
			}
		}

		model.addAttribute("colorList", list);
		model.addAttribute("appraisalMember", UserUtils.getUser().getLoginName());
		model.addAttribute("appraisalDate",DateUtils.getDate());

		Dict dict = new Dict();
		dict.setType("video_appraisal_review_state");
		model.addAttribute("reviewList",dictService.findList(dict));
		return "oa/dog/dogvideoappraisal/reviewStatePage";
	}


	@RequiresPermissions("dogVideoAppraisal:view")
	@RequestMapping(value = "editPage")
	public String editPage(DogVideoAppraisal dogVideoAppraisal, Model model) {
		DogVideoAppraisal info = dogVideoAppraisalService.getInfo(dogVideoAppraisal);
		model.addAttribute("info", info);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		// 查询颜色
		List<RestDogColorMark> list = new ArrayList<RestDogColorMark>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogVideoAppraisal.getDogBreed());
		if(!StringUtils.isEmpty(dogType.getDogColor()) ) {
			for (String dogColor : dogType.getDogColor().split(",")) {
				DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogColor);
				if (dogColorMark != null) {
					RestDogColorMark vo = new RestDogColorMark();
					BeanUtil.copyProperties(vo, dogColorMark, "yyyy-MM-dd");
					list.add(vo);
				}
			}
		}else {
			List<DogColorMark> colors = dogColorMarkService.findList(new DogColorMark());
			for(DogColorMark color: colors) {
				RestDogColorMark vo = new RestDogColorMark();
				BeanUtil.copyProperties(vo, color, "yyyy-MM-dd");
				list.add(vo);
			}
		}

		model.addAttribute("colorList", list);
		return "oa/dog/dogvideoappraisal/dogVideoAppraisalEdit";
	}

	@RequiresPermissions("dogVideoAppraisal:edit")
	@RequestMapping(value = "delete")
	public String delete(DogVideoAppraisal dogVideoAppraisal, RedirectAttributes redirectAttributes) {
		dogVideoAppraisalService.delete(dogVideoAppraisal);
		addMessage(redirectAttributes, "删除视频鉴定成功");
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
	}

	@RequiresPermissions("dogVideoAppraisal:resolve")
	@RequestMapping(value = "resolve")
	public String resolve(DogVideoAppraisal dogVideoAppraisal, RedirectAttributes redirectAttributes) {
		dogVideoAppraisalService.resolve(dogVideoAppraisal);
		addMessage(redirectAttributes, "处理视频鉴定成功");
		return "redirect:" + Global.getAdminPath() + "/dogvideoappraisal/list/?repage";
	}


}
//package com.cku.oa.dog.web;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//
//import org.springframework.ui.Model;
//
//import org.apache.shiro.authz.annotation.RequiresPermissions;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.web.bind.annotation.ModelAttribute;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.servlet.mvc.support.RedirectAttributes;
//
//import com.thinkgem.jeesite.common.utils.StringUtils;
//
//import com.cku.oa.dog.entity.DogVideoAppraisal;
//import com.cku.oa.dog.service.DogVideoAppraisalService;
//import com.thinkgem.jeesite.common.config.Global;
//import com.thinkgem.jeesite.common.persistence.Page;
//import com.thinkgem.jeesite.common.web.BaseController;
//
//@Controller
//@RequestMapping(value = "${adminPath}/dogvideoappraisal")
//public class DogVideoAppraisalController extends BaseController {
//
//	@Autowired
//	private DogVideoAppraisalService dogVideoAppraisalService;
//
//
//	@ModelAttribute
//	public DogVideoAppraisal get(@RequestParam(required=false) String id) {
//		DogVideoAppraisal entity = null;
//		if (StringUtils.isNotBlank(id)){
//			entity = dogVideoAppraisalService.get(id);
//		}
//		if (entity == null){
//			entity = new DogVideoAppraisal();
//		}
//		return entity;
//	}
//
//	@RequiresPermissions("com.cku.oa:dogvideoappraisal:dogVideoAppraisal:view")
//	@RequestMapping(value = {"list", ""})
//	public String list(DogVideoAppraisal dogVideoAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
//		Page<DogVideoAppraisal> page = dogVideoAppraisalService.findPage(new Page<DogVideoAppraisal>(request, response), dogVideoAppraisal);
//		model.addAttribute("page", page);
//		return "modules/com.cku.oa/dogvideoappraisal/dogVideoAppraisalList";
//	}
//
//	@RequiresPermissions("com.cku.oa:dogvideoappraisal:dogVideoAppraisal:view")
//	@RequestMapping(value = "form")
//	public String form(DogVideoAppraisal dogVideoAppraisal, Model model) {
//		model.addAttribute("dogVideoAppraisal", dogVideoAppraisal);
//		return "modules/com.cku.oa/dogvideoappraisal/dogVideoAppraisalForm";
//	}
//
//	@RequiresPermissions("com.cku.oa:dogvideoappraisal:dogVideoAppraisal:edit")
//	@RequestMapping(value = "save")
//	public String save(DogVideoAppraisal dogVideoAppraisal, Model model, RedirectAttributes redirectAttributes) {
//		if (!beanValidator(model, dogVideoAppraisal)){
//			return form(dogVideoAppraisal, model);
//		}
//		dogVideoAppraisalService.save(dogVideoAppraisal);
//		addMessage(redirectAttributes, "保存视频鉴定成功");
//		return "redirect:"+Global.getAdminPath()+"/com.cku.oa/dogvideoappraisal/dogVideoAppraisal/?repage";
//	}
//
//	@RequiresPermissions("com.cku.oa:dogvideoappraisal:dogVideoAppraisal:edit")
//	@RequestMapping(value = "delete")
//	public String delete(DogVideoAppraisal dogVideoAppraisal, RedirectAttributes redirectAttributes) {
//		dogVideoAppraisalService.delete(dogVideoAppraisal);
//		addMessage(redirectAttributes, "删除视频鉴定成功");
//		return "redirect:"+Global.getAdminPath()+"/com.cku.oa/dogvideoappraisal/dogVideoAppraisal/?repage";
//	}
//
//}
